﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace uart { // NOLINT(whitespace/braces)

class IPortSession;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IPortSession, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IPortSession)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenPort, (::nn::sf::Out<bool> isSuccess, ::std::int32_t name, ::std::int32_t baudRate, ::std::int32_t flowControlMode, ::nn::sf::NativeHandle&& sendHandle, ::std::uint64_t sendLength, ::nn::sf::NativeHandle&& receiveHandle, ::std::uint64_t receiveLength, bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenPortForDev, (::nn::sf::Out<bool> isSuccess, ::std::int32_t portIndex, ::std::int32_t baudRate, ::std::int32_t flowControlMode, ::nn::sf::NativeHandle&& sendHandle, ::std::uint64_t sendLength, ::nn::sf::NativeHandle&& receiveHandle, ::std::uint64_t receiveLength, bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetWritableLength, (::nn::sf::Out<::std::int64_t> size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Send, (::nn::sf::Out<::std::int64_t> doneBytes, const ::nn::sf::InBuffer& inData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReadableLength, (::nn::sf::Out<::std::int64_t> size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Receive, (::nn::sf::Out<::std::int64_t> doneBytes, const ::nn::sf::OutBuffer& outData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BindPortEvent, (::nn::sf::Out<bool> result, ::nn::sf::Out<::nn::sf::NativeHandle> handle, ::std::int32_t eventType, ::std::int64_t threshold))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnbindPortEvent, (::nn::sf::Out<bool> result, ::std::int32_t eventType))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IPortSession)

        ::nn::Result OpenPort(::nn::sf::Out<bool> isSuccess, ::std::int32_t name, ::std::int32_t baudRate, ::std::int32_t flowControlMode, ::nn::sf::NativeHandle&& sendHandle, ::std::uint64_t sendLength, ::nn::sf::NativeHandle&& receiveHandle, ::std::uint64_t receiveLength, bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenPort, (isSuccess, name, baudRate, flowControlMode, ::std::move(sendHandle), sendLength, ::std::move(receiveHandle), receiveLength, isInvertTx, isInvertRx, isInvertRts, isInvertCts));
        }

        ::nn::Result OpenPortForDev(::nn::sf::Out<bool> isSuccess, ::std::int32_t portIndex, ::std::int32_t baudRate, ::std::int32_t flowControlMode, ::nn::sf::NativeHandle&& sendHandle, ::std::uint64_t sendLength, ::nn::sf::NativeHandle&& receiveHandle, ::std::uint64_t receiveLength, bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenPortForDev, (isSuccess, portIndex, baudRate, flowControlMode, ::std::move(sendHandle), sendLength, ::std::move(receiveHandle), receiveLength, isInvertTx, isInvertRx, isInvertRts, isInvertCts));
        }

        ::nn::Result GetWritableLength(::nn::sf::Out<::std::int64_t> size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetWritableLength, (size));
        }

        ::nn::Result Send(::nn::sf::Out<::std::int64_t> doneBytes, const ::nn::sf::InBuffer& inData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Send, (doneBytes, inData));
        }

        ::nn::Result GetReadableLength(::nn::sf::Out<::std::int64_t> size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReadableLength, (size));
        }

        ::nn::Result Receive(::nn::sf::Out<::std::int64_t> doneBytes, const ::nn::sf::OutBuffer& outData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Receive, (doneBytes, outData));
        }

        ::nn::Result BindPortEvent(::nn::sf::Out<bool> result, ::nn::sf::Out<::nn::sf::NativeHandle> handle, ::std::int32_t eventType, ::std::int64_t threshold) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BindPortEvent, (result, handle, eventType, threshold));
        }

        ::nn::Result UnbindPortEvent(::nn::sf::Out<bool> result, ::std::int32_t eventType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnbindPortEvent, (result, eventType));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IPortSession
    {
    public:
        nn::Result OpenPort(nn::sf::Out<bool> isSuccess, std::int32_t name, std::int32_t baudRate, std::int32_t flowControlMode, nn::sf::NativeHandle&& sendHandle, std::uint64_t sendLength, nn::sf::NativeHandle&& receiveHandle, std::uint64_t receiveLength, bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts) NN_NOEXCEPT;
        nn::Result OpenPortForDev(nn::sf::Out<bool> isSuccess, std::int32_t portIndex, std::int32_t baudRate, std::int32_t flowControlMode, nn::sf::NativeHandle&& sendHandle, std::uint64_t sendLength, nn::sf::NativeHandle&& receiveHandle, std::uint64_t receiveLength, bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts) NN_NOEXCEPT;
        nn::Result GetWritableLength(nn::sf::Out<std::int64_t> size) NN_NOEXCEPT;
        nn::Result Send(nn::sf::Out<std::int64_t> doneBytes, const nn::sf::InBuffer& inData) NN_NOEXCEPT;
        nn::Result GetReadableLength(nn::sf::Out<std::int64_t> size) NN_NOEXCEPT;
        nn::Result Receive(nn::sf::Out<std::int64_t> doneBytes, const nn::sf::OutBuffer& outData) NN_NOEXCEPT;
        nn::Result BindPortEvent(nn::sf::Out<bool> result, nn::sf::Out<nn::sf::NativeHandle> handle, std::int32_t eventType, std::int64_t threshold) NN_NOEXCEPT;
        nn::Result UnbindPortEvent(nn::sf::Out<bool> result, std::int32_t eventType) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result OpenPort(nn::sf::Out<bool> isSuccess, std::int32_t name, std::int32_t baudRate, std::int32_t flowControlMode, nn::sf::NativeHandle&& sendHandle, std::uint64_t sendLength, nn::sf::NativeHandle&& receiveHandle, std::uint64_t receiveLength, bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts) NN_NOEXCEPT;
    nn::Result OpenPortForDev(nn::sf::Out<bool> isSuccess, std::int32_t portIndex, std::int32_t baudRate, std::int32_t flowControlMode, nn::sf::NativeHandle&& sendHandle, std::uint64_t sendLength, nn::sf::NativeHandle&& receiveHandle, std::uint64_t receiveLength, bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts) NN_NOEXCEPT;
    nn::Result GetWritableLength(nn::sf::Out<std::int64_t> size) NN_NOEXCEPT;
    nn::Result Send(nn::sf::Out<std::int64_t> doneBytes, const nn::sf::InBuffer& inData) NN_NOEXCEPT;
    nn::Result GetReadableLength(nn::sf::Out<std::int64_t> size) NN_NOEXCEPT;
    nn::Result Receive(nn::sf::Out<std::int64_t> doneBytes, const nn::sf::OutBuffer& outData) NN_NOEXCEPT;
    nn::Result BindPortEvent(nn::sf::Out<bool> result, nn::sf::Out<nn::sf::NativeHandle> handle, std::int32_t eventType, std::int64_t threshold) NN_NOEXCEPT;
    nn::Result UnbindPortEvent(nn::sf::Out<bool> result, std::int32_t eventType) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::uart::IPortSession))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenPort, (::nn::sf::Out<bool> isSuccess, ::std::int32_t name, ::std::int32_t baudRate, ::std::int32_t flowControlMode, ::nn::sf::NativeHandle&& sendHandle, ::std::uint64_t sendLength, ::nn::sf::NativeHandle&& receiveHandle, ::std::uint64_t receiveLength, bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenPort, (isSuccess, name, baudRate, flowControlMode, ::std::move(sendHandle), sendLength, ::std::move(receiveHandle), receiveLength, isInvertTx, isInvertRx, isInvertRts, isInvertCts));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenPortForDev, (::nn::sf::Out<bool> isSuccess, ::std::int32_t portIndex, ::std::int32_t baudRate, ::std::int32_t flowControlMode, ::nn::sf::NativeHandle&& sendHandle, ::std::uint64_t sendLength, ::nn::sf::NativeHandle&& receiveHandle, ::std::uint64_t receiveLength, bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenPortForDev, (isSuccess, portIndex, baudRate, flowControlMode, ::std::move(sendHandle), sendLength, ::std::move(receiveHandle), receiveLength, isInvertTx, isInvertRx, isInvertRts, isInvertCts));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetWritableLength, (::nn::sf::Out<::std::int64_t> size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetWritableLength, (size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Send, (::nn::sf::Out<::std::int64_t> doneBytes, const ::nn::sf::InBuffer& inData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Send, (doneBytes, inData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReadableLength, (::nn::sf::Out<::std::int64_t> size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReadableLength, (size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Receive, (::nn::sf::Out<::std::int64_t> doneBytes, const ::nn::sf::OutBuffer& outData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Receive, (doneBytes, outData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BindPortEvent, (::nn::sf::Out<bool> result, ::nn::sf::Out<::nn::sf::NativeHandle> handle, ::std::int32_t eventType, ::std::int64_t threshold))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BindPortEvent, (result, handle, eventType, threshold));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnbindPortEvent, (::nn::sf::Out<bool> result, ::std::int32_t eventType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnbindPortEvent, (result, eventType));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::uart::IPortSession>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::uart::IPortSession))

    // nn::Result OpenPort(nn::sf::Out<bool> isSuccess, std::int32_t name, std::int32_t baudRate, std::int32_t flowControlMode, nn::sf::NativeHandle&& sendHandle, std::uint64_t sendLength, nn::sf::NativeHandle&& receiveHandle, std::uint64_t receiveLength, bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenPort)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(sendHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(receiveHandle, 1, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(2, (sendHandle, receiveHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isInvertTx, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isInvertRx, (bool), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isInvertRts, (bool), 2)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isInvertCts, (bool), 3)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(name, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(baudRate, (::std::int32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flowControlMode, (::std::int32_t), 12)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sendLength, (::std::uint64_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(receiveLength, (::std::uint64_t), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(9, (isInvertTx, isInvertRx, isInvertRts, isInvertCts, name, baudRate, flowControlMode, sendLength, receiveLength))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(isSuccess, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (isSuccess))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isSuccess), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(baudRate), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flowControlMode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sendHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sendLength), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(receiveHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(receiveLength), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isInvertTx), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isInvertRx), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isInvertRts), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isInvertCts)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenPort)

    // nn::Result OpenPortForDev(nn::sf::Out<bool> isSuccess, std::int32_t portIndex, std::int32_t baudRate, std::int32_t flowControlMode, nn::sf::NativeHandle&& sendHandle, std::uint64_t sendLength, nn::sf::NativeHandle&& receiveHandle, std::uint64_t receiveLength, bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenPortForDev)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(sendHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(receiveHandle, 1, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(2, (sendHandle, receiveHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isInvertTx, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isInvertRx, (bool), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isInvertRts, (bool), 2)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isInvertCts, (bool), 3)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(portIndex, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(baudRate, (::std::int32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flowControlMode, (::std::int32_t), 12)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sendLength, (::std::uint64_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(receiveLength, (::std::uint64_t), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(9, (isInvertTx, isInvertRx, isInvertRts, isInvertCts, portIndex, baudRate, flowControlMode, sendLength, receiveLength))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(isSuccess, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (isSuccess))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isSuccess), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(portIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(baudRate), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flowControlMode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sendHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sendLength), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(receiveHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(receiveLength), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isInvertTx), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isInvertRx), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isInvertRts), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isInvertCts)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenPortForDev)

    // nn::Result GetWritableLength(nn::sf::Out<std::int64_t> size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetWritableLength)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(size, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetWritableLength)

    // nn::Result Send(nn::sf::Out<std::int64_t> doneBytes, const nn::sf::InBuffer& inData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Send)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inData, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(doneBytes, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (doneBytes))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(doneBytes), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Send)

    // nn::Result GetReadableLength(nn::sf::Out<std::int64_t> size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReadableLength)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(size, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReadableLength)

    // nn::Result Receive(nn::sf::Out<std::int64_t> doneBytes, const nn::sf::OutBuffer& outData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Receive)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outData, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(doneBytes, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (doneBytes))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(doneBytes), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Receive)

    // nn::Result BindPortEvent(nn::sf::Out<bool> result, nn::sf::Out<nn::sf::NativeHandle> handle, std::int32_t eventType, std::int64_t threshold) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BindPortEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(eventType, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(threshold, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (eventType, threshold))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(result, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (result))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(result), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(threshold)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BindPortEvent)

    // nn::Result UnbindPortEvent(nn::sf::Out<bool> result, std::int32_t eventType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnbindPortEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(eventType, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (eventType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(result, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (result))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(result), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnbindPortEvent)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::uart::IPortSession, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::uart::IPortSession))

    // nn::Result OpenPort(nn::sf::Out<bool> isSuccess, std::int32_t name, std::int32_t baudRate, std::int32_t flowControlMode, nn::sf::NativeHandle&& sendHandle, std::uint64_t sendLength, nn::sf::NativeHandle&& receiveHandle, std::uint64_t receiveLength, bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenPort, (::nn::sf::Out<bool> isSuccess, ::std::int32_t name, ::std::int32_t baudRate, ::std::int32_t flowControlMode, ::nn::sf::NativeHandle&& sendHandle, ::std::uint64_t sendLength, ::nn::sf::NativeHandle&& receiveHandle, ::std::uint64_t receiveLength, bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenPort)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isSuccess)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(baudRate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flowControlMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sendHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sendLength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(receiveHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(receiveLength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isInvertTx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isInvertRx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isInvertRts)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isInvertCts)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenPort)
    }

    // nn::Result OpenPortForDev(nn::sf::Out<bool> isSuccess, std::int32_t portIndex, std::int32_t baudRate, std::int32_t flowControlMode, nn::sf::NativeHandle&& sendHandle, std::uint64_t sendLength, nn::sf::NativeHandle&& receiveHandle, std::uint64_t receiveLength, bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenPortForDev, (::nn::sf::Out<bool> isSuccess, ::std::int32_t portIndex, ::std::int32_t baudRate, ::std::int32_t flowControlMode, ::nn::sf::NativeHandle&& sendHandle, ::std::uint64_t sendLength, ::nn::sf::NativeHandle&& receiveHandle, ::std::uint64_t receiveLength, bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenPortForDev)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isSuccess)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(portIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(baudRate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flowControlMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sendHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sendLength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(receiveHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(receiveLength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isInvertTx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isInvertRx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isInvertRts)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isInvertCts)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenPortForDev)
    }

    // nn::Result GetWritableLength(nn::sf::Out<std::int64_t> size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetWritableLength, (::nn::sf::Out<::std::int64_t> size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetWritableLength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetWritableLength)
    }

    // nn::Result Send(nn::sf::Out<std::int64_t> doneBytes, const nn::sf::InBuffer& inData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Send, (::nn::sf::Out<::std::int64_t> doneBytes, const ::nn::sf::InBuffer& inData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Send)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(doneBytes)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Send)
    }

    // nn::Result GetReadableLength(nn::sf::Out<std::int64_t> size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReadableLength, (::nn::sf::Out<::std::int64_t> size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReadableLength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReadableLength)
    }

    // nn::Result Receive(nn::sf::Out<std::int64_t> doneBytes, const nn::sf::OutBuffer& outData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Receive, (::nn::sf::Out<::std::int64_t> doneBytes, const ::nn::sf::OutBuffer& outData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Receive)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(doneBytes)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Receive)
    }

    // nn::Result BindPortEvent(nn::sf::Out<bool> result, nn::sf::Out<nn::sf::NativeHandle> handle, std::int32_t eventType, std::int64_t threshold) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BindPortEvent, (::nn::sf::Out<bool> result, ::nn::sf::Out<::nn::sf::NativeHandle> handle, ::std::int32_t eventType, ::std::int64_t threshold))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BindPortEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(result)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(threshold)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BindPortEvent)
    }

    // nn::Result UnbindPortEvent(nn::sf::Out<bool> result, std::int32_t eventType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnbindPortEvent, (::nn::sf::Out<bool> result, ::std::int32_t eventType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnbindPortEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(result)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnbindPortEvent)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::uart::IPortSession>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::uart::IPortSession))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenPort)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(sendHandle)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(receiveHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenPort)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(isSuccess),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(name),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(baudRate),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flowControlMode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(sendHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sendLength),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(receiveHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(receiveLength),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isInvertTx),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isInvertRx),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isInvertRts),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isInvertCts)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenPortForDev)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(sendHandle)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(receiveHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenPortForDev)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(isSuccess),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(portIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(baudRate),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flowControlMode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(sendHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sendLength),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(receiveHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(receiveLength),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isInvertTx),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isInvertRx),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isInvertRts),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isInvertCts)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetWritableLength)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetWritableLength)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Send)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Send)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(doneBytes),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReadableLength)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReadableLength)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Receive)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Receive)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(doneBytes),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BindPortEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BindPortEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(result),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(eventType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(threshold)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnbindPortEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnbindPortEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(result),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(eventType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenPort)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenPortForDev)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetWritableLength)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Send)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReadableLength)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Receive)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BindPortEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnbindPortEvent)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::uart::IPortSession))
