﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   UART ドライバライブラリのサスペンド・レジューム機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace uart {
namespace driver {

//! @name サスペンド・レジューム
//! @{

/**
 * @brief   全ポートをサスペンドします。
 *
 * @pre
 *  ライブラリは初期化済の状態である必要があります。
 *
 * @post
 *  全ポートがサスペンド状態になります。
 *
 * @details
 *  全ポートをサスペンドします。@n
 *  サスペンド後もポートのオープン状態は維持されますが、ハードウェアは省電力状態に移行し、機能が利用できない状態になります。@n
 *  また、サスペンド状態中は新たなポートのオープンやオープン済ポートのクローズはできません。@n
 *  すでにサスペンド状態で本関数を呼び出した場合、何もしません。
 */
void SuspendAllPorts() NN_NOEXCEPT;

/**
 * @brief   全ポートをレジュームします。
 *
 * @pre
 *  ライブラリは初期化済の状態である必要があります。
 *
 * @post
 *  全ポートがサスペンド前の状態になります。
 *
 * @details
 *  全ポートをレジュームし、サスペンド前の状態に戻します。@n
 *  サスペンド前の状態で本関数を呼び出した場合、何もしません。
 */
void ResumeAllPorts() NN_NOEXCEPT;

//! @}

} // dirver
} // uart
} // nn


