﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      uart モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_UART_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(uart, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_UART_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(uart, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_UART_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(uart, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_UART_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(uart, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_UART_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(uart, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_UART_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(uart, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_UART_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(uart, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_UART_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(uart, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_UART_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(uart, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_UART_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(uart, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_UART_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(uart, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_UART_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(uart, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_UART_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(uart, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_UART_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(uart, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_UART_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(uart, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_UART_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(uart, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_UART_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(uart, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_UART_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(uart, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_UART_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(uart, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_UART_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(uart, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_UART_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Trace, 0, format, args)
#define NN_DETAIL_UART_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Trace, 1, format, args)
#define NN_DETAIL_UART_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Trace, 2, format, args)
#define NN_DETAIL_UART_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Trace, 3, format, args)

#define NN_DETAIL_UART_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Info, 0, format, args)
#define NN_DETAIL_UART_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Info, 1, format, args)
#define NN_DETAIL_UART_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Info, 2, format, args)
#define NN_DETAIL_UART_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Info, 3, format, args)

#define NN_DETAIL_UART_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Warn, 0, format, args)
#define NN_DETAIL_UART_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Warn, 1, format, args)
#define NN_DETAIL_UART_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Warn, 2, format, args)
#define NN_DETAIL_UART_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Warn, 3, format, args)

#define NN_DETAIL_UART_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Error, 0, format, args)
#define NN_DETAIL_UART_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Error, 1, format, args)
#define NN_DETAIL_UART_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Error, 2, format, args)
#define NN_DETAIL_UART_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Error, 3, format, args)

#define NN_DETAIL_UART_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Fatal, 0, format, args)
#define NN_DETAIL_UART_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Fatal, 1, format, args)
#define NN_DETAIL_UART_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Fatal, 2, format, args)
#define NN_DETAIL_UART_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(uart, Fatal, 3, format, args)

#define NN_DETAIL_UART_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(uart, Trace, 0, text, length)
#define NN_DETAIL_UART_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(uart, Trace, 1, text, length)
#define NN_DETAIL_UART_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(uart, Trace, 2, text, length)
#define NN_DETAIL_UART_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(uart, Trace, 3, text, length)

#define NN_DETAIL_UART_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(uart, Info, 0, text, length)
#define NN_DETAIL_UART_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(uart, Info, 1, text, length)
#define NN_DETAIL_UART_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(uart, Info, 2, text, length)
#define NN_DETAIL_UART_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(uart, Info, 3, text, length)

#define NN_DETAIL_UART_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(uart, Warn, 0, text, length)
#define NN_DETAIL_UART_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(uart, Warn, 1, text, length)
#define NN_DETAIL_UART_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(uart, Warn, 2, text, length)
#define NN_DETAIL_UART_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(uart, Warn, 3, text, length)

#define NN_DETAIL_UART_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(uart, Error, 0, text, length)
#define NN_DETAIL_UART_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(uart, Error, 1, text, length)
#define NN_DETAIL_UART_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(uart, Error, 2, text, length)
#define NN_DETAIL_UART_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(uart, Error, 3, text, length)

#define NN_DETAIL_UART_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(uart, Fatal, 0, text, length)
#define NN_DETAIL_UART_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(uart, Fatal, 1, text, length)
#define NN_DETAIL_UART_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(uart, Fatal, 2, text, length)
#define NN_DETAIL_UART_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(uart, Fatal, 3, text, length)
