﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief   温度計測サービスのサーバに関する定義です。
 */

#include <nn/nn_Common.h>

#include <nn/sf/sf_Types.h>

#include <nn/ts/server/ts_IMeasurementServer.autogen.h>

namespace nn {
namespace ts {
namespace server {

//!< 温度計測サービスを扱うクラスです。
class MeasurementServer
        : public nn::sf::ISharedObject
{

public:
    ::nn::Result GetTemperatureRange(nn::sf::Out<LimitTemperature> outLimitTemperature, std::uint8_t location) NN_NOEXCEPT;
    ::nn::Result GetTemperature(nn::sf::Out<int> outTemperature, std::uint8_t location) NN_NOEXCEPT;
    ::nn::Result GetTemperatureMilliC(nn::sf::Out<int> outTemperatureMilliC, std::uint8_t location) NN_NOEXCEPT;
    ::nn::Result SetMeasurementMode(::std::uint8_t location, ::std::uint8_t measurementMode) NN_NOEXCEPT;
};

} // server
} // ts
} // nn
