﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * @file
 * @brief   温度センサーライブラリの公開ヘッダ。
 */


/**
 * @namespace   nn::ts
 *
 * @brief       温度センサーライブラリの名前空間です。
 *
 * @detail      本ライブラリの持つ状態は以下のようになります。
 *              未初期化以外の状態を初期化済み状態と呼びます。
 *              @li 未初期化：ライブラリを初期化する前の状態です。
 *                  初期化以外の何れの処理も実行できない状態です。
 *
 *              @li 初期化済み：ライブラリが初期化済みの状態です。
 *                  温度値の取得、温度検知に関する設定が可能です。
 *
 *              @li セッションクローズ：温度検知のセッションが開かれていない状態です。
 *                  温度検知に関する制御は行えません。
 *
 *              @li セッションオープン：温度検知のセッションが開かれている状態です。
 *                  温度検知に関する制御が可能です。
 *
 *              @li 検知条件未設定：温度検知の通知を受け取るための設定が行われていない状態です。
 *                  通知機能の有効化ができません。
 *
 *              @li 検知条件設定済み：温度検知の通知を受け取るための設定が完了した状態です。
 *                  通知機能の有効化が可能です。
 */

#include <nn/ts/ts_Library.h>
#include <nn/ts/ts_Detection.h>
#include <nn/ts/ts_Measurement.h>
#include <nn/ts/ts_Location.h>
#include <nn/ts/ts_Types.h>
