﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/time/time_CalendarTime.h>
#include <nn/time/time_LocationName.h>
#include <nn/time/time_Types.h>
#include <nn/timesrv/detail/service/timesrv_ISteadyClock.sfdl.h>
#include <nn/timesrv/detail/service/timesrv_ISystemClock.sfdl.h>
#include <nn/timesrv/detail/service/timesrv_ITimeZoneService.sfdl.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace time { namespace sf { // NOLINT(whitespace/braces)

struct ClockSnapshot;

}}}

namespace nn { namespace timesrv { namespace detail { namespace service { // NOLINT(whitespace/braces)

class IStaticService;

}}}}

namespace nn { namespace time { namespace sf { // NOLINT(whitespace/braces)

struct ClockSnapshot
{
    nn::time::SystemClockContext userSystemClockContext;
    nn::time::SystemClockContext netSystemClockContext;
    nn::time::PosixTime userSystemClockPosixTime;
    nn::time::PosixTime netSystemClockPosixTime;
    nn::time::CalendarTime userCalendarTime;
    nn::time::CalendarTime netCalendarTime;
    nn::time::sf::CalendarAdditionalInfo userCalendarAdditionalInfo;
    nn::time::sf::CalendarAdditionalInfo netCalendarAdditionalInfo;
    nn::time::SteadyClockTimePoint steadyClockTimePoint;
    nn::time::LocationName locationName;
    bool isAutomaticCorrectionEnabled;
    std::uint8_t initialType;
    std::uint8_t version;
    std::uint8_t padding[1];
};

}}}

namespace nn { namespace timesrv { namespace detail { namespace service { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IStaticService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IStaticService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardUserSystemClock, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>> outStandardUserSystemClock))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardNetworkSystemClock, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>> outStandardNetworkSystemClock))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardSteadyClock, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISteadyClock>> outStandardSteadyClock))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTimeZoneService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ITimeZoneService>> outTimeZoneService))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardLocalSystemClock, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>> outStandardLocalSystemClock))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetEphemeralNetworkSystemClock, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>> outEphemeralNetworkSystemClock))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedMemoryNativeHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetStandardSteadyClockInternalOffset, (::nn::TimeSpanType internalOffset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsStandardUserSystemClockAutomaticCorrectionEnabled, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetStandardUserSystemClockAutomaticCorrectionEnabled, (bool value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardUserSystemClockInitialYear, (::nn::sf::Out<::std::int32_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsStandardNetworkSystemClockAccuracySufficient, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardUserSystemClockAutomaticCorrectionUpdatedTime, (::nn::sf::Out<::nn::time::SteadyClockTimePoint> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CalculateMonotonicSystemClockBaseTimePoint, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::time::SystemClockContext& systemClockContext))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetClockSnapshot, (::nn::sf::Out<::nn::time::sf::ClockSnapshot> outValue, ::std::uint8_t initialType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetClockSnapshotFromSystemClockContext, (::nn::sf::Out<::nn::time::sf::ClockSnapshot> outValue, const ::nn::time::SystemClockContext& userSystemClockContext, const ::nn::time::SystemClockContext& netSystemClockContext, ::std::uint8_t initialType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CalculateStandardUserSystemClockDifferenceByUser, (::nn::sf::Out<::nn::TimeSpanType> outValue, const ::nn::time::sf::ClockSnapshot& from, const ::nn::time::sf::ClockSnapshot& to))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CalculateSpanBetween, (::nn::sf::Out<::nn::TimeSpanType> outValue, const ::nn::time::sf::ClockSnapshot& from, const ::nn::time::sf::ClockSnapshot& to))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IStaticService)

        ::nn::Result GetStandardUserSystemClock(::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>> outStandardUserSystemClock) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetStandardUserSystemClock, (outStandardUserSystemClock));
        }

        ::nn::Result GetStandardNetworkSystemClock(::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>> outStandardNetworkSystemClock) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetStandardNetworkSystemClock, (outStandardNetworkSystemClock));
        }

        ::nn::Result GetStandardSteadyClock(::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISteadyClock>> outStandardSteadyClock) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetStandardSteadyClock, (outStandardSteadyClock));
        }

        ::nn::Result GetTimeZoneService(::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ITimeZoneService>> outTimeZoneService) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTimeZoneService, (outTimeZoneService));
        }

        ::nn::Result GetStandardLocalSystemClock(::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>> outStandardLocalSystemClock) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetStandardLocalSystemClock, (outStandardLocalSystemClock));
        }

        ::nn::Result GetEphemeralNetworkSystemClock(::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>> outEphemeralNetworkSystemClock) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetEphemeralNetworkSystemClock, (outEphemeralNetworkSystemClock));
        }

        ::nn::Result GetSharedMemoryNativeHandle(::nn::sf::Out<::nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSharedMemoryNativeHandle, (outHandle));
        }

        ::nn::Result SetStandardSteadyClockInternalOffset(::nn::TimeSpanType internalOffset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetStandardSteadyClockInternalOffset, (internalOffset));
        }

        ::nn::Result IsStandardUserSystemClockAutomaticCorrectionEnabled(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsStandardUserSystemClockAutomaticCorrectionEnabled, (outValue));
        }

        ::nn::Result SetStandardUserSystemClockAutomaticCorrectionEnabled(bool value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetStandardUserSystemClockAutomaticCorrectionEnabled, (value));
        }

        ::nn::Result GetStandardUserSystemClockInitialYear(::nn::sf::Out<::std::int32_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetStandardUserSystemClockInitialYear, (outValue));
        }

        ::nn::Result IsStandardNetworkSystemClockAccuracySufficient(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsStandardNetworkSystemClockAccuracySufficient, (outValue));
        }

        ::nn::Result GetStandardUserSystemClockAutomaticCorrectionUpdatedTime(::nn::sf::Out<::nn::time::SteadyClockTimePoint> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetStandardUserSystemClockAutomaticCorrectionUpdatedTime, (outValue));
        }

        ::nn::Result CalculateMonotonicSystemClockBaseTimePoint(::nn::sf::Out<::std::int64_t> outValue, const ::nn::time::SystemClockContext& systemClockContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CalculateMonotonicSystemClockBaseTimePoint, (outValue, systemClockContext));
        }

        ::nn::Result GetClockSnapshot(::nn::sf::Out<::nn::time::sf::ClockSnapshot> outValue, ::std::uint8_t initialType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetClockSnapshot, (outValue, initialType));
        }

        ::nn::Result GetClockSnapshotFromSystemClockContext(::nn::sf::Out<::nn::time::sf::ClockSnapshot> outValue, const ::nn::time::SystemClockContext& userSystemClockContext, const ::nn::time::SystemClockContext& netSystemClockContext, ::std::uint8_t initialType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetClockSnapshotFromSystemClockContext, (outValue, userSystemClockContext, netSystemClockContext, initialType));
        }

        ::nn::Result CalculateStandardUserSystemClockDifferenceByUser(::nn::sf::Out<::nn::TimeSpanType> outValue, const ::nn::time::sf::ClockSnapshot& from, const ::nn::time::sf::ClockSnapshot& to) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CalculateStandardUserSystemClockDifferenceByUser, (outValue, from, to));
        }

        ::nn::Result CalculateSpanBetween(::nn::sf::Out<::nn::TimeSpanType> outValue, const ::nn::time::sf::ClockSnapshot& from, const ::nn::time::sf::ClockSnapshot& to) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CalculateSpanBetween, (outValue, from, to));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IStaticService
    {
    public:
        nn::Result GetStandardUserSystemClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock>> outStandardUserSystemClock) NN_NOEXCEPT;
        nn::Result GetStandardNetworkSystemClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock>> outStandardNetworkSystemClock) NN_NOEXCEPT;
        nn::Result GetStandardSteadyClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISteadyClock>> outStandardSteadyClock) NN_NOEXCEPT;
        nn::Result GetTimeZoneService(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ITimeZoneService>> outTimeZoneService) NN_NOEXCEPT;
        nn::Result GetStandardLocalSystemClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock>> outStandardLocalSystemClock) NN_NOEXCEPT;
        nn::Result GetEphemeralNetworkSystemClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock>> outEphemeralNetworkSystemClock) NN_NOEXCEPT;
        nn::Result GetSharedMemoryNativeHandle(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
        nn::Result SetStandardSteadyClockInternalOffset(nn::TimeSpanType internalOffset) NN_NOEXCEPT;
        nn::Result IsStandardUserSystemClockAutomaticCorrectionEnabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result SetStandardUserSystemClockAutomaticCorrectionEnabled(bool value) NN_NOEXCEPT;
        nn::Result GetStandardUserSystemClockInitialYear(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT;
        nn::Result IsStandardNetworkSystemClockAccuracySufficient(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result GetStandardUserSystemClockAutomaticCorrectionUpdatedTime(nn::sf::Out<nn::time::SteadyClockTimePoint> outValue) NN_NOEXCEPT;
        nn::Result CalculateMonotonicSystemClockBaseTimePoint(nn::sf::Out<std::int64_t> outValue, const nn::time::SystemClockContext& systemClockContext) NN_NOEXCEPT;
        nn::Result GetClockSnapshot(nn::sf::Out<nn::time::sf::ClockSnapshot> outValue, std::uint8_t initialType) NN_NOEXCEPT;
        nn::Result GetClockSnapshotFromSystemClockContext(nn::sf::Out<nn::time::sf::ClockSnapshot> outValue, const nn::time::SystemClockContext& userSystemClockContext, const nn::time::SystemClockContext& netSystemClockContext, std::uint8_t initialType) NN_NOEXCEPT;
        nn::Result CalculateStandardUserSystemClockDifferenceByUser(nn::sf::Out<nn::TimeSpanType> outValue, const nn::time::sf::ClockSnapshot& from, const nn::time::sf::ClockSnapshot& to) NN_NOEXCEPT;
        nn::Result CalculateSpanBetween(nn::sf::Out<nn::TimeSpanType> outValue, const nn::time::sf::ClockSnapshot& from, const nn::time::sf::ClockSnapshot& to) NN_NOEXCEPT;
    };
#endif

}}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetStandardUserSystemClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock>> outStandardUserSystemClock) NN_NOEXCEPT;
    nn::Result GetStandardNetworkSystemClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock>> outStandardNetworkSystemClock) NN_NOEXCEPT;
    nn::Result GetStandardSteadyClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISteadyClock>> outStandardSteadyClock) NN_NOEXCEPT;
    nn::Result GetTimeZoneService(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ITimeZoneService>> outTimeZoneService) NN_NOEXCEPT;
    nn::Result GetStandardLocalSystemClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock>> outStandardLocalSystemClock) NN_NOEXCEPT;
    nn::Result GetEphemeralNetworkSystemClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock>> outEphemeralNetworkSystemClock) NN_NOEXCEPT;
    nn::Result GetSharedMemoryNativeHandle(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result SetStandardSteadyClockInternalOffset(nn::TimeSpanType internalOffset) NN_NOEXCEPT;
    nn::Result IsStandardUserSystemClockAutomaticCorrectionEnabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result SetStandardUserSystemClockAutomaticCorrectionEnabled(bool value) NN_NOEXCEPT;
    nn::Result GetStandardUserSystemClockInitialYear(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT;
    nn::Result IsStandardNetworkSystemClockAccuracySufficient(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result GetStandardUserSystemClockAutomaticCorrectionUpdatedTime(nn::sf::Out<nn::time::SteadyClockTimePoint> outValue) NN_NOEXCEPT;
    nn::Result CalculateMonotonicSystemClockBaseTimePoint(nn::sf::Out<std::int64_t> outValue, const nn::time::SystemClockContext& systemClockContext) NN_NOEXCEPT;
    nn::Result GetClockSnapshot(nn::sf::Out<nn::time::sf::ClockSnapshot> outValue, std::uint8_t initialType) NN_NOEXCEPT;
    nn::Result GetClockSnapshotFromSystemClockContext(nn::sf::Out<nn::time::sf::ClockSnapshot> outValue, const nn::time::SystemClockContext& userSystemClockContext, const nn::time::SystemClockContext& netSystemClockContext, std::uint8_t initialType) NN_NOEXCEPT;
    nn::Result CalculateStandardUserSystemClockDifferenceByUser(nn::sf::Out<nn::TimeSpanType> outValue, const nn::time::sf::ClockSnapshot& from, const nn::time::sf::ClockSnapshot& to) NN_NOEXCEPT;
    nn::Result CalculateSpanBetween(nn::sf::Out<nn::TimeSpanType> outValue, const nn::time::sf::ClockSnapshot& from, const nn::time::sf::ClockSnapshot& to) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::timesrv::detail::service::IStaticService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardUserSystemClock, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>> outStandardUserSystemClock))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetStandardUserSystemClock, (outStandardUserSystemClock));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardNetworkSystemClock, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>> outStandardNetworkSystemClock))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetStandardNetworkSystemClock, (outStandardNetworkSystemClock));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardSteadyClock, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISteadyClock>> outStandardSteadyClock))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetStandardSteadyClock, (outStandardSteadyClock));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTimeZoneService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ITimeZoneService>> outTimeZoneService))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTimeZoneService, (outTimeZoneService));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardLocalSystemClock, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>> outStandardLocalSystemClock))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetStandardLocalSystemClock, (outStandardLocalSystemClock));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetEphemeralNetworkSystemClock, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>> outEphemeralNetworkSystemClock))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetEphemeralNetworkSystemClock, (outEphemeralNetworkSystemClock));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedMemoryNativeHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSharedMemoryNativeHandle, (outHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetStandardSteadyClockInternalOffset, (::nn::TimeSpanType internalOffset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetStandardSteadyClockInternalOffset, (internalOffset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsStandardUserSystemClockAutomaticCorrectionEnabled, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsStandardUserSystemClockAutomaticCorrectionEnabled, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetStandardUserSystemClockAutomaticCorrectionEnabled, (bool value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetStandardUserSystemClockAutomaticCorrectionEnabled, (value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardUserSystemClockInitialYear, (::nn::sf::Out<::std::int32_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetStandardUserSystemClockInitialYear, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsStandardNetworkSystemClockAccuracySufficient, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsStandardNetworkSystemClockAccuracySufficient, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardUserSystemClockAutomaticCorrectionUpdatedTime, (::nn::sf::Out<::nn::time::SteadyClockTimePoint> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetStandardUserSystemClockAutomaticCorrectionUpdatedTime, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateMonotonicSystemClockBaseTimePoint, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::time::SystemClockContext& systemClockContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CalculateMonotonicSystemClockBaseTimePoint, (outValue, systemClockContext));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetClockSnapshot, (::nn::sf::Out<::nn::time::sf::ClockSnapshot> outValue, ::std::uint8_t initialType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetClockSnapshot, (outValue, initialType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetClockSnapshotFromSystemClockContext, (::nn::sf::Out<::nn::time::sf::ClockSnapshot> outValue, const ::nn::time::SystemClockContext& userSystemClockContext, const ::nn::time::SystemClockContext& netSystemClockContext, ::std::uint8_t initialType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetClockSnapshotFromSystemClockContext, (outValue, userSystemClockContext, netSystemClockContext, initialType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateStandardUserSystemClockDifferenceByUser, (::nn::sf::Out<::nn::TimeSpanType> outValue, const ::nn::time::sf::ClockSnapshot& from, const ::nn::time::sf::ClockSnapshot& to))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CalculateStandardUserSystemClockDifferenceByUser, (outValue, from, to));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateSpanBetween, (::nn::sf::Out<::nn::TimeSpanType> outValue, const ::nn::time::sf::ClockSnapshot& from, const ::nn::time::sf::ClockSnapshot& to))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CalculateSpanBetween, (outValue, from, to));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::timesrv::detail::service::IStaticService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::timesrv::detail::service::IStaticService))

    // nn::Result GetStandardUserSystemClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock>> outStandardUserSystemClock) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStandardUserSystemClock)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outStandardUserSystemClock, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outStandardUserSystemClock))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStandardUserSystemClock)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStandardUserSystemClock)

    // nn::Result GetStandardNetworkSystemClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock>> outStandardNetworkSystemClock) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStandardNetworkSystemClock)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outStandardNetworkSystemClock, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outStandardNetworkSystemClock))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStandardNetworkSystemClock)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStandardNetworkSystemClock)

    // nn::Result GetStandardSteadyClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISteadyClock>> outStandardSteadyClock) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStandardSteadyClock)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outStandardSteadyClock, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outStandardSteadyClock))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStandardSteadyClock)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStandardSteadyClock)

    // nn::Result GetTimeZoneService(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ITimeZoneService>> outTimeZoneService) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTimeZoneService)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outTimeZoneService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outTimeZoneService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTimeZoneService)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTimeZoneService)

    // nn::Result GetStandardLocalSystemClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock>> outStandardLocalSystemClock) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStandardLocalSystemClock)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outStandardLocalSystemClock, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outStandardLocalSystemClock))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStandardLocalSystemClock)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStandardLocalSystemClock)

    // nn::Result GetEphemeralNetworkSystemClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock>> outEphemeralNetworkSystemClock) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetEphemeralNetworkSystemClock)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outEphemeralNetworkSystemClock, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outEphemeralNetworkSystemClock))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outEphemeralNetworkSystemClock)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetEphemeralNetworkSystemClock)

    // nn::Result GetSharedMemoryNativeHandle(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSharedMemoryNativeHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSharedMemoryNativeHandle)

    // nn::Result SetStandardSteadyClockInternalOffset(nn::TimeSpanType internalOffset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetStandardSteadyClockInternalOffset)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(50)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(internalOffset, (::nn::TimeSpanType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (internalOffset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(internalOffset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetStandardSteadyClockInternalOffset)

    // nn::Result IsStandardUserSystemClockAutomaticCorrectionEnabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsStandardUserSystemClockAutomaticCorrectionEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsStandardUserSystemClockAutomaticCorrectionEnabled)

    // nn::Result SetStandardUserSystemClockAutomaticCorrectionEnabled(bool value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetStandardUserSystemClockAutomaticCorrectionEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetStandardUserSystemClockAutomaticCorrectionEnabled)

    // nn::Result GetStandardUserSystemClockInitialYear(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStandardUserSystemClockInitialYear)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStandardUserSystemClockInitialYear)

    // nn::Result IsStandardNetworkSystemClockAccuracySufficient(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsStandardNetworkSystemClockAccuracySufficient)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsStandardNetworkSystemClockAccuracySufficient)

    // nn::Result GetStandardUserSystemClockAutomaticCorrectionUpdatedTime(nn::sf::Out<nn::time::SteadyClockTimePoint> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStandardUserSystemClockAutomaticCorrectionUpdatedTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::time::SteadyClockTimePoint), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStandardUserSystemClockAutomaticCorrectionUpdatedTime)

    // nn::Result CalculateMonotonicSystemClockBaseTimePoint(nn::sf::Out<std::int64_t> outValue, const nn::time::SystemClockContext& systemClockContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CalculateMonotonicSystemClockBaseTimePoint)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(300)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(systemClockContext, (::nn::time::SystemClockContext), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (systemClockContext))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(systemClockContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CalculateMonotonicSystemClockBaseTimePoint)

    // nn::Result GetClockSnapshot(nn::sf::Out<nn::time::sf::ClockSnapshot> outValue, std::uint8_t initialType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetClockSnapshot)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(400)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::time::sf::ClockSnapshot>), 208, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(initialType, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (initialType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(initialType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetClockSnapshot)

    // nn::Result GetClockSnapshotFromSystemClockContext(nn::sf::Out<nn::time::sf::ClockSnapshot> outValue, const nn::time::SystemClockContext& userSystemClockContext, const nn::time::SystemClockContext& netSystemClockContext, std::uint8_t initialType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetClockSnapshotFromSystemClockContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(401)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::time::sf::ClockSnapshot>), 208, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(initialType, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(userSystemClockContext, (::nn::time::SystemClockContext), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(netSystemClockContext, (::nn::time::SystemClockContext), 40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (initialType, userSystemClockContext, netSystemClockContext))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(72)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(userSystemClockContext), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(netSystemClockContext), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(initialType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetClockSnapshotFromSystemClockContext)

    // nn::Result CalculateStandardUserSystemClockDifferenceByUser(nn::sf::Out<nn::TimeSpanType> outValue, const nn::time::sf::ClockSnapshot& from, const nn::time::sf::ClockSnapshot& to) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CalculateStandardUserSystemClockDifferenceByUser)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(500)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(from, 0, (const ::nn::time::sf::ClockSnapshot&), 208, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(to, 1, (const ::nn::time::sf::ClockSnapshot&), 208, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (from, to))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::TimeSpanType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(from), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(to)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CalculateStandardUserSystemClockDifferenceByUser)

    // nn::Result CalculateSpanBetween(nn::sf::Out<nn::TimeSpanType> outValue, const nn::time::sf::ClockSnapshot& from, const nn::time::sf::ClockSnapshot& to) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CalculateSpanBetween)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(501)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(from, 0, (const ::nn::time::sf::ClockSnapshot&), 208, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(to, 1, (const ::nn::time::sf::ClockSnapshot&), 208, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (from, to))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::TimeSpanType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(from), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(to)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CalculateSpanBetween)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::TimeSpanType), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::time::SteadyClockTimePoint), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::time::SystemClockContext), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::time::sf::ClockSnapshot), 208, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::timesrv::detail::service::IStaticService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::timesrv::detail::service::IStaticService))

    // nn::Result GetStandardUserSystemClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock>> outStandardUserSystemClock) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardUserSystemClock, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>> outStandardUserSystemClock))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStandardUserSystemClock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStandardUserSystemClock)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStandardUserSystemClock)
    }

    // nn::Result GetStandardNetworkSystemClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock>> outStandardNetworkSystemClock) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardNetworkSystemClock, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>> outStandardNetworkSystemClock))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStandardNetworkSystemClock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStandardNetworkSystemClock)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStandardNetworkSystemClock)
    }

    // nn::Result GetStandardSteadyClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISteadyClock>> outStandardSteadyClock) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardSteadyClock, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISteadyClock>> outStandardSteadyClock))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStandardSteadyClock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStandardSteadyClock)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStandardSteadyClock)
    }

    // nn::Result GetTimeZoneService(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ITimeZoneService>> outTimeZoneService) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTimeZoneService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ITimeZoneService>> outTimeZoneService))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTimeZoneService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTimeZoneService)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTimeZoneService)
    }

    // nn::Result GetStandardLocalSystemClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock>> outStandardLocalSystemClock) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardLocalSystemClock, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>> outStandardLocalSystemClock))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStandardLocalSystemClock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStandardLocalSystemClock)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStandardLocalSystemClock)
    }

    // nn::Result GetEphemeralNetworkSystemClock(nn::sf::Out<nn::sf::SharedPointer<nn::timesrv::detail::service::ISystemClock>> outEphemeralNetworkSystemClock) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetEphemeralNetworkSystemClock, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>> outEphemeralNetworkSystemClock))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetEphemeralNetworkSystemClock)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outEphemeralNetworkSystemClock)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetEphemeralNetworkSystemClock)
    }

    // nn::Result GetSharedMemoryNativeHandle(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedMemoryNativeHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSharedMemoryNativeHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSharedMemoryNativeHandle)
    }

    // nn::Result SetStandardSteadyClockInternalOffset(nn::TimeSpanType internalOffset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetStandardSteadyClockInternalOffset, (::nn::TimeSpanType internalOffset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetStandardSteadyClockInternalOffset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(internalOffset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetStandardSteadyClockInternalOffset)
    }

    // nn::Result IsStandardUserSystemClockAutomaticCorrectionEnabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsStandardUserSystemClockAutomaticCorrectionEnabled, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsStandardUserSystemClockAutomaticCorrectionEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsStandardUserSystemClockAutomaticCorrectionEnabled)
    }

    // nn::Result SetStandardUserSystemClockAutomaticCorrectionEnabled(bool value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetStandardUserSystemClockAutomaticCorrectionEnabled, (bool value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetStandardUserSystemClockAutomaticCorrectionEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetStandardUserSystemClockAutomaticCorrectionEnabled)
    }

    // nn::Result GetStandardUserSystemClockInitialYear(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardUserSystemClockInitialYear, (::nn::sf::Out<::std::int32_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStandardUserSystemClockInitialYear)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStandardUserSystemClockInitialYear)
    }

    // nn::Result IsStandardNetworkSystemClockAccuracySufficient(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsStandardNetworkSystemClockAccuracySufficient, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsStandardNetworkSystemClockAccuracySufficient)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsStandardNetworkSystemClockAccuracySufficient)
    }

    // nn::Result GetStandardUserSystemClockAutomaticCorrectionUpdatedTime(nn::sf::Out<nn::time::SteadyClockTimePoint> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStandardUserSystemClockAutomaticCorrectionUpdatedTime, (::nn::sf::Out<::nn::time::SteadyClockTimePoint> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStandardUserSystemClockAutomaticCorrectionUpdatedTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStandardUserSystemClockAutomaticCorrectionUpdatedTime)
    }

    // nn::Result CalculateMonotonicSystemClockBaseTimePoint(nn::sf::Out<std::int64_t> outValue, const nn::time::SystemClockContext& systemClockContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateMonotonicSystemClockBaseTimePoint, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::time::SystemClockContext& systemClockContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CalculateMonotonicSystemClockBaseTimePoint)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(systemClockContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CalculateMonotonicSystemClockBaseTimePoint)
    }

    // nn::Result GetClockSnapshot(nn::sf::Out<nn::time::sf::ClockSnapshot> outValue, std::uint8_t initialType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetClockSnapshot, (::nn::sf::Out<::nn::time::sf::ClockSnapshot> outValue, ::std::uint8_t initialType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetClockSnapshot)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(initialType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetClockSnapshot)
    }

    // nn::Result GetClockSnapshotFromSystemClockContext(nn::sf::Out<nn::time::sf::ClockSnapshot> outValue, const nn::time::SystemClockContext& userSystemClockContext, const nn::time::SystemClockContext& netSystemClockContext, std::uint8_t initialType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetClockSnapshotFromSystemClockContext, (::nn::sf::Out<::nn::time::sf::ClockSnapshot> outValue, const ::nn::time::SystemClockContext& userSystemClockContext, const ::nn::time::SystemClockContext& netSystemClockContext, ::std::uint8_t initialType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetClockSnapshotFromSystemClockContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(userSystemClockContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(netSystemClockContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(initialType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetClockSnapshotFromSystemClockContext)
    }

    // nn::Result CalculateStandardUserSystemClockDifferenceByUser(nn::sf::Out<nn::TimeSpanType> outValue, const nn::time::sf::ClockSnapshot& from, const nn::time::sf::ClockSnapshot& to) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateStandardUserSystemClockDifferenceByUser, (::nn::sf::Out<::nn::TimeSpanType> outValue, const ::nn::time::sf::ClockSnapshot& from, const ::nn::time::sf::ClockSnapshot& to))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CalculateStandardUserSystemClockDifferenceByUser)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(from)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(to)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CalculateStandardUserSystemClockDifferenceByUser)
    }

    // nn::Result CalculateSpanBetween(nn::sf::Out<nn::TimeSpanType> outValue, const nn::time::sf::ClockSnapshot& from, const nn::time::sf::ClockSnapshot& to) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateSpanBetween, (::nn::sf::Out<::nn::TimeSpanType> outValue, const ::nn::time::sf::ClockSnapshot& from, const ::nn::time::sf::ClockSnapshot& to))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CalculateSpanBetween)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(from)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(to)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CalculateSpanBetween)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::timesrv::detail::service::IStaticService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::timesrv::detail::service::IStaticService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStandardUserSystemClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>), outStandardUserSystemClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStandardUserSystemClock)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outStandardUserSystemClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outStandardUserSystemClock, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStandardNetworkSystemClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>), outStandardNetworkSystemClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStandardNetworkSystemClock)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outStandardNetworkSystemClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outStandardNetworkSystemClock, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStandardSteadyClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISteadyClock>), outStandardSteadyClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStandardSteadyClock)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outStandardSteadyClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outStandardSteadyClock, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTimeZoneService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::timesrv::detail::service::ITimeZoneService>), outTimeZoneService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTimeZoneService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outTimeZoneService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outTimeZoneService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStandardLocalSystemClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>), outStandardLocalSystemClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStandardLocalSystemClock)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outStandardLocalSystemClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outStandardLocalSystemClock, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetEphemeralNetworkSystemClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::timesrv::detail::service::ISystemClock>), outEphemeralNetworkSystemClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetEphemeralNetworkSystemClock)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outEphemeralNetworkSystemClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outEphemeralNetworkSystemClock, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSharedMemoryNativeHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSharedMemoryNativeHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetStandardSteadyClockInternalOffset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetStandardSteadyClockInternalOffset)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(internalOffset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsStandardUserSystemClockAutomaticCorrectionEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsStandardUserSystemClockAutomaticCorrectionEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetStandardUserSystemClockAutomaticCorrectionEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetStandardUserSystemClockAutomaticCorrectionEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStandardUserSystemClockInitialYear)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStandardUserSystemClockInitialYear)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsStandardNetworkSystemClockAccuracySufficient)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsStandardNetworkSystemClockAccuracySufficient)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStandardUserSystemClockAutomaticCorrectionUpdatedTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStandardUserSystemClockAutomaticCorrectionUpdatedTime)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CalculateMonotonicSystemClockBaseTimePoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CalculateMonotonicSystemClockBaseTimePoint)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(systemClockContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetClockSnapshot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetClockSnapshot)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(initialType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetClockSnapshotFromSystemClockContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetClockSnapshotFromSystemClockContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(userSystemClockContext),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(netSystemClockContext),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(initialType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CalculateStandardUserSystemClockDifferenceByUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(from)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(to)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CalculateStandardUserSystemClockDifferenceByUser)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(from),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(to)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CalculateSpanBetween)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(from)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(to)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CalculateSpanBetween)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(from),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(to)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStandardUserSystemClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStandardNetworkSystemClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStandardSteadyClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTimeZoneService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStandardLocalSystemClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetEphemeralNetworkSystemClock)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSharedMemoryNativeHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetStandardSteadyClockInternalOffset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsStandardUserSystemClockAutomaticCorrectionEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetStandardUserSystemClockAutomaticCorrectionEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStandardUserSystemClockInitialYear)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsStandardNetworkSystemClockAccuracySufficient)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStandardUserSystemClockAutomaticCorrectionUpdatedTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CalculateMonotonicSystemClockBaseTimePoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetClockSnapshot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetClockSnapshotFromSystemClockContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CalculateStandardUserSystemClockDifferenceByUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CalculateSpanBetween)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::timesrv::detail::service::IStaticService))
