﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/detail/time_CommonDetail.h>
#include <nn/timesrv/detail/service/timesrv_IStaticService.sfdl.h>

#include <nn/timesrv/detail/service/timesrv_StaticServiceServer.h>
#include <nn/timesrv/detail/util/timesrv_SfExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn
{
namespace timesrv
{
namespace detail
{
namespace service
{

namespace
{
    static const Capabilities g_AlmightyCapabilities = { true, true, true, true, true };
}

class HipcServerManager
{
private:
    nn::timesrv::detail::util::SfExpHeapAllocator<16 * 1024> m_SfExpHeapAllocator;
    nn::sf::UnmanagedServiceObject<IStaticService, StaticServiceServer> m_AlmightyStaticService;

public:
    explicit HipcServerManager(ServiceProvider* pServiceProvider) NN_NOEXCEPT
        : m_SfExpHeapAllocator(nn::lmem::CreationOption_NoOption),
          m_AlmightyStaticService(g_AlmightyCapabilities, pServiceProvider, m_SfExpHeapAllocator.GetBase())
    {
    }

    ~HipcServerManager() NN_NOEXCEPT
    {
    }

    void GetStaticServiceSharedPointer(sf::SharedPointer<IStaticService>* pStaticService) NN_NOEXCEPT
    {
        *pStaticService = m_AlmightyStaticService.GetShared();
    }
};

}
}
}
}
