﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/detail/time_CommonDetail.h>

#include <nn/timesrv/detail/core/timesrv_SteadyClockCore.h>
#include <nn/util/util_Uuid.h>

#include <atomic>

namespace nn
{
namespace timesrv
{
namespace detail
{
namespace core
{

class TickBasedSteadyClockCore : public SteadyClockCore
{
private:
    virtual Result GetCurrentTimePointImpl(nn::time::SteadyClockTimePoint* pSteadyClockTimePoint) const NN_NOEXCEPT NN_OVERRIDE;

public:
    TickBasedSteadyClockCore() NN_NOEXCEPT;
    virtual ~TickBasedSteadyClockCore() NN_NOEXCEPT;

private:
    nn::time::SourceId m_SourceId;
};

}
}
}
}
