﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/psc.h>

namespace nn
{
namespace timesrv
{
namespace detail
{
namespace core
{

class PmStateChangeCallback
{
public:
    PmStateChangeCallback()
    {
    }

    virtual void FullAwakeCallback() NN_NOEXCEPT {}
    virtual void MinimumAwakeCallback() NN_NOEXCEPT {}
    virtual void SleepReadyCallback() NN_NOEXCEPT {}
    virtual void ShutdownReadyCallback() NN_NOEXCEPT {}
};

Result InitializePmModule(nn::psc::PmModule* pPmModule, PmStateChangeCallback* pPmStateChangeCallback) NN_NOEXCEPT;

void FinalizePmModule(nn::psc::PmModule* pPmModule) NN_NOEXCEPT;

void HandlePmModule(nn::psc::PmModule* pPmModule) NN_NOEXCEPT;

}
}
}
}
