﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/time_Types.h>

namespace nn
{
namespace timesrv
{
namespace detail
{
namespace core
{

/**
* @brief        PMIC RTC値を秒単位で取得します
*
* @param[in]    pOutSeconds 経過秒数を入れるアドレス
*
* @pre
*   - pOutSeconds != nullptr
*
* @detail
*   PMICは 年月日・時刻 の値を返しますが、関数内部で経過秒数に変換したものを返します。
*/
// TODO:秒を返すのはPMICの仕様ではないのでAPI名が微妙
// チップやOSによらず経過秒数を返すような抽象化を用意するのが良さそう
Result RequestPmicSeconds(int64_t* pOutSeconds) NN_NOEXCEPT;

/**
 * @brief       RTC がリセットされたかどうかを取得します
 * @retval      true    リセットされた
 * @retval      false   リセットされていない
 */
bool IsPmicRtcResetDetected() NN_NOEXCEPT;

/**
 * @brief       RTC がリセットされたかどうかのフラグをクリアします
 */
void ClearPmicRtcResetDetected() NN_NOEXCEPT;

}
}
}
}
