﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/time_Common.h>

#include <nn/time/time_Types.h>

namespace nn
{
namespace time
{

//! @name 特権が必要な EphemeralNetworkSystemClock API
//! @{

    /**
     * @brief   現在時刻を指定してクロックを補正します。
     *
     * @param[in]   posixTime   補正後の時刻への参照を指定します。
     *
     * @return  処理の結果が返ります。事前条件を満たしていない場合、以下に列挙されていない失敗が返ることがあります。
     * @retval  ResultSuccess                       成功しました。
     *
     * @pre
     *  - TIME ライブラリが初期化されている
     *
     * @details
     *  この関数を成功させるには、特権が必要です。
     */
    Result SetEphemeralNetworkSystemClockCurrentTime(const PosixTime& posixTime) NN_NOEXCEPT;

//! @}

}
}
