﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/detail/time_CommonDetail.h>

#include <nn/timesrv/detail/service/timesrv_ISystemClock.sfdl.h>
#include <nn/timesrv/detail/service/timesrv_ISteadyClock.sfdl.h>
#include <nn/timesrv/detail/service/timesrv_ITimeZoneService.sfdl.h>
#include <nn/timesrv/detail/service/timesrv_IStaticService.sfdl.h>

#if NN_DETAIL_TIME_CONFIG_SERVER_MODEL == NN_DETAIL_TIME_CONFIG_SERVER_MODEL_THREAD
#include <nn/timesrv/detail/service/timesrv_ServiceProvider.h>
#endif

#include <nn/os/os_Thread.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_HipcSimpleClientSessionManager.h>


namespace nn
{
namespace time
{
namespace detail
{
namespace service
{

class ServiceProviderClient
{
private:
#if NN_DETAIL_TIME_CONFIG_SERVER_MODEL == NN_DETAIL_TIME_CONFIG_SERVER_MODEL_THREAD
    // TODO: コンストラクタに時間がかかりすぎるようなら、オブジェクトの生成もスレッドに移す
    // TODO: その際、 DFC モデルでも、準備完了まで API がブロックするように変更する
    nn::timesrv::detail::service::ServiceProvider m_ServiceProvider;

#if NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
    nn::os::ThreadType m_ThreadType;
    static void ServerManagerThreadFunction(void* pContext) NN_NOEXCEPT;
#endif
#endif

public:
    ServiceProviderClient() NN_NOEXCEPT;
    ~ServiceProviderClient() NN_NOEXCEPT;

    Result GetUserStaticServiceSharedPointer(
        nn::sf::SharedPointer<nn::timesrv::detail::service::IStaticService>* pStaticService) NN_NOEXCEPT;
    Result GetAdminStaticServiceSharedPointer(
        nn::sf::SharedPointer<nn::timesrv::detail::service::IStaticService>* pStaticService) NN_NOEXCEPT;
    Result GetSystemStaticServiceSharedPointer(
        nn::sf::SharedPointer<nn::timesrv::detail::service::IStaticService>* pStaticService) NN_NOEXCEPT;
    Result GetRepairStaticServiceSharedPointer(
        nn::sf::SharedPointer<nn::timesrv::detail::service::IStaticService>* pStaticService) NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;
};

}
}
}
}
