﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief サーバプロセス向け TCAP シムライブラリ初期化・終了関連 API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

#include <nn/sf/sf_Types.h>
#include <nn/tcap/server/tcap_IManager.sfdl.h>

namespace nn { namespace tcap {

//! @name サーバプロセス向け TCAP シムライブラリ初期化 API
//! @{

/**
 * @brief       TCAP シムライブラリを外部の Manager オブジェクトで初期化します。
 *
 * @param[in]   manager @ref server::IManager 型のオブジェクトへの SharedPointer です。
 *
 * @details     TCAP シムライブラリを外部の Manager オブジェクトで初期化します。@n
 *              ライブラリ初期化回数は内部でカウントされます。
 */
void InitializeWith(nn::sf::SharedPointer<server::IManager>&& manager) NN_NOEXCEPT;

//! @}

}} // namepsace nn::tcap
