﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief TCAP ライブラリの動作モード関連 API の宣言。
 */

#pragma once

#include <nn/nn_Common.h>

#include "tcap_OperationModeTypes.h"

namespace nn { namespace tcap {

//! @name TCAP ライブラリの動作モード関連 API
//! @{

/**
 * @brief       TCAP モジュールに現在の動作モードを設定します。
 *
 * @param[in]   OperationMode 動作モードを表す @ref nn::tc::OperationMode 型の列挙値です。
 *
 * @details     TCAP モジュールに現在の動作モードを設定します。
 */
void SetOperationMode(OperationMode OperationMode) NN_NOEXCEPT;

//! @}

}} // namepsace nn::tcap
