﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/tc/tc_IManager.sfdl.h>
#include <nn/os.h>

namespace nn { namespace tc {

// IManager 実装クラス
class ManagerImpl : public nn::sf::ISharedObject
{
public:
    nn::Result SetOperatingMode(nn::tc::OperatingMode operatingMode) NN_NOEXCEPT;
    nn::Result GetThermalEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, nn::tc::EventTarget target) NN_NOEXCEPT;
    nn::Result IsActionAllowed(nn::sf::Out<bool> pOutPossible, nn::tc::Action action) NN_NOEXCEPT;
    nn::Result EnableVirtualTemperature(nn::tc::Location location) NN_NOEXCEPT;
    nn::Result DisableVirtualTemperature(nn::tc::Location location) NN_NOEXCEPT;
    nn::Result SetVirtualTemperature(nn::tc::Location location, int temperature) NN_NOEXCEPT;
    nn::Result EnableFanControl() NN_NOEXCEPT;
    nn::Result DisableFanControl() NN_NOEXCEPT;
    nn::Result IsFanControlEnabled(nn::sf::Out<bool> pOutEnabled) NN_NOEXCEPT;
    nn::Result GetSkinTemperatureMilliC(nn::sf::Out<TemperatureMilliC> pOutSkinTemperatureMilliC) NN_NOEXCEPT;
};

}} // namespace nn::tc
