﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/tc/tc_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace tc { // NOLINT(whitespace/braces)

class IManager;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetOperatingMode, (::nn::tc::OperatingMode operatingMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetThermalEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle, ::nn::tc::EventTarget target))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsActionAllowed, (::nn::sf::Out<bool> pOutPossible, ::nn::tc::Action action))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnableVirtualTemperature, (::nn::tc::Location location))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DisableVirtualTemperature, (::nn::tc::Location location))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetVirtualTemperature, (::nn::tc::Location location, int temperature))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(EnableFanControl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DisableFanControl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsFanControlEnabled, (::nn::sf::Out<bool> pOutEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSkinTemperatureMilliC, (::nn::sf::Out<::nn::tc::TemperatureMilliC> pOutSkinTemperatureMilliC))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IManager)

        ::nn::Result SetOperatingMode(::nn::tc::OperatingMode operatingMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetOperatingMode, (operatingMode));
        }

        ::nn::Result GetThermalEvent(::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle, ::nn::tc::EventTarget target) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetThermalEvent, (pOutHandle, target));
        }

        ::nn::Result IsActionAllowed(::nn::sf::Out<bool> pOutPossible, ::nn::tc::Action action) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsActionAllowed, (pOutPossible, action));
        }

        ::nn::Result EnableVirtualTemperature(::nn::tc::Location location) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnableVirtualTemperature, (location));
        }

        ::nn::Result DisableVirtualTemperature(::nn::tc::Location location) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DisableVirtualTemperature, (location));
        }

        ::nn::Result SetVirtualTemperature(::nn::tc::Location location, int temperature) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetVirtualTemperature, (location, temperature));
        }

        ::nn::Result EnableFanControl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(EnableFanControl);
        }

        ::nn::Result DisableFanControl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DisableFanControl);
        }

        ::nn::Result IsFanControlEnabled(::nn::sf::Out<bool> pOutEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsFanControlEnabled, (pOutEnabled));
        }

        ::nn::Result GetSkinTemperatureMilliC(::nn::sf::Out<::nn::tc::TemperatureMilliC> pOutSkinTemperatureMilliC) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSkinTemperatureMilliC, (pOutSkinTemperatureMilliC));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IManager
    {
    public:
        nn::Result SetOperatingMode(nn::tc::OperatingMode operatingMode) NN_NOEXCEPT;
        nn::Result GetThermalEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, nn::tc::EventTarget target) NN_NOEXCEPT;
        nn::Result IsActionAllowed(nn::sf::Out<bool> pOutPossible, nn::tc::Action action) NN_NOEXCEPT;
        nn::Result EnableVirtualTemperature(nn::tc::Location location) NN_NOEXCEPT;
        nn::Result DisableVirtualTemperature(nn::tc::Location location) NN_NOEXCEPT;
        nn::Result SetVirtualTemperature(nn::tc::Location location, int temperature) NN_NOEXCEPT;
        nn::Result EnableFanControl() NN_NOEXCEPT;
        nn::Result DisableFanControl() NN_NOEXCEPT;
        nn::Result IsFanControlEnabled(nn::sf::Out<bool> pOutEnabled) NN_NOEXCEPT;
        nn::Result GetSkinTemperatureMilliC(nn::sf::Out<nn::tc::TemperatureMilliC> pOutSkinTemperatureMilliC) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result SetOperatingMode(nn::tc::OperatingMode operatingMode) NN_NOEXCEPT;
    nn::Result GetThermalEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, nn::tc::EventTarget target) NN_NOEXCEPT;
    nn::Result IsActionAllowed(nn::sf::Out<bool> pOutPossible, nn::tc::Action action) NN_NOEXCEPT;
    nn::Result EnableVirtualTemperature(nn::tc::Location location) NN_NOEXCEPT;
    nn::Result DisableVirtualTemperature(nn::tc::Location location) NN_NOEXCEPT;
    nn::Result SetVirtualTemperature(nn::tc::Location location, int temperature) NN_NOEXCEPT;
    nn::Result EnableFanControl() NN_NOEXCEPT;
    nn::Result DisableFanControl() NN_NOEXCEPT;
    nn::Result IsFanControlEnabled(nn::sf::Out<bool> pOutEnabled) NN_NOEXCEPT;
    nn::Result GetSkinTemperatureMilliC(nn::sf::Out<nn::tc::TemperatureMilliC> pOutSkinTemperatureMilliC) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::tc::IManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetOperatingMode, (::nn::tc::OperatingMode operatingMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetOperatingMode, (operatingMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetThermalEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle, ::nn::tc::EventTarget target))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetThermalEvent, (pOutHandle, target));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsActionAllowed, (::nn::sf::Out<bool> pOutPossible, ::nn::tc::Action action))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsActionAllowed, (pOutPossible, action));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableVirtualTemperature, (::nn::tc::Location location))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnableVirtualTemperature, (location));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DisableVirtualTemperature, (::nn::tc::Location location))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DisableVirtualTemperature, (location));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetVirtualTemperature, (::nn::tc::Location location, int temperature))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetVirtualTemperature, (location, temperature));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnableFanControl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(EnableFanControl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableFanControl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DisableFanControl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsFanControlEnabled, (::nn::sf::Out<bool> pOutEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsFanControlEnabled, (pOutEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSkinTemperatureMilliC, (::nn::sf::Out<::nn::tc::TemperatureMilliC> pOutSkinTemperatureMilliC))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSkinTemperatureMilliC, (pOutSkinTemperatureMilliC));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::tc::IManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::tc::IManager))

    // nn::Result SetOperatingMode(nn::tc::OperatingMode operatingMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetOperatingMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(operatingMode, (::nn::tc::OperatingMode), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (operatingMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(operatingMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetOperatingMode)

    // nn::Result GetThermalEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, nn::tc::EventTarget target) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetThermalEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOutHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOutHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::nn::tc::EventTarget), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (target))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetThermalEvent)

    // nn::Result IsActionAllowed(nn::sf::Out<bool> pOutPossible, nn::tc::Action action) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsActionAllowed)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(action, (::nn::tc::Action), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (action))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutPossible, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutPossible))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutPossible), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(action)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsActionAllowed)

    // nn::Result EnableVirtualTemperature(nn::tc::Location location) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableVirtualTemperature)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(location, (::nn::tc::Location), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (location))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(location)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableVirtualTemperature)

    // nn::Result DisableVirtualTemperature(nn::tc::Location location) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableVirtualTemperature)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(location, (::nn::tc::Location), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (location))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(location)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableVirtualTemperature)

    // nn::Result SetVirtualTemperature(nn::tc::Location location, int temperature) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetVirtualTemperature)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(location, (::nn::tc::Location), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(temperature, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (location, temperature))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(location), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(temperature)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetVirtualTemperature)

    // nn::Result EnableFanControl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableFanControl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableFanControl)

    // nn::Result DisableFanControl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableFanControl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableFanControl)

    // nn::Result IsFanControlEnabled(nn::sf::Out<bool> pOutEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsFanControlEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsFanControlEnabled)

    // nn::Result GetSkinTemperatureMilliC(nn::sf::Out<nn::tc::TemperatureMilliC> pOutSkinTemperatureMilliC) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSkinTemperatureMilliC)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSkinTemperatureMilliC, (::nn::tc::TemperatureMilliC), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutSkinTemperatureMilliC))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSkinTemperatureMilliC)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSkinTemperatureMilliC)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::tc::OperatingMode), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::tc::EventTarget), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::tc::Action), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::tc::Location), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::tc::TemperatureMilliC), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::tc::IManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::tc::IManager))

    // nn::Result SetOperatingMode(nn::tc::OperatingMode operatingMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetOperatingMode, (::nn::tc::OperatingMode operatingMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetOperatingMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(operatingMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetOperatingMode)
    }

    // nn::Result GetThermalEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, nn::tc::EventTarget target) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetThermalEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle, ::nn::tc::EventTarget target))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetThermalEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetThermalEvent)
    }

    // nn::Result IsActionAllowed(nn::sf::Out<bool> pOutPossible, nn::tc::Action action) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsActionAllowed, (::nn::sf::Out<bool> pOutPossible, ::nn::tc::Action action))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsActionAllowed)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutPossible)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(action)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsActionAllowed)
    }

    // nn::Result EnableVirtualTemperature(nn::tc::Location location) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableVirtualTemperature, (::nn::tc::Location location))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableVirtualTemperature)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(location)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableVirtualTemperature)
    }

    // nn::Result DisableVirtualTemperature(nn::tc::Location location) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DisableVirtualTemperature, (::nn::tc::Location location))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableVirtualTemperature)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(location)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableVirtualTemperature)
    }

    // nn::Result SetVirtualTemperature(nn::tc::Location location, int temperature) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetVirtualTemperature, (::nn::tc::Location location, int temperature))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetVirtualTemperature)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(location)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(temperature)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetVirtualTemperature)
    }

    // nn::Result EnableFanControl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnableFanControl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableFanControl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableFanControl)
    }

    // nn::Result DisableFanControl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableFanControl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableFanControl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableFanControl)
    }

    // nn::Result IsFanControlEnabled(nn::sf::Out<bool> pOutEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsFanControlEnabled, (::nn::sf::Out<bool> pOutEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsFanControlEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsFanControlEnabled)
    }

    // nn::Result GetSkinTemperatureMilliC(nn::sf::Out<nn::tc::TemperatureMilliC> pOutSkinTemperatureMilliC) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSkinTemperatureMilliC, (::nn::sf::Out<::nn::tc::TemperatureMilliC> pOutSkinTemperatureMilliC))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSkinTemperatureMilliC)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSkinTemperatureMilliC)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSkinTemperatureMilliC)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::tc::IManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::tc::IManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetOperatingMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetOperatingMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(operatingMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetThermalEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOutHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetThermalEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOutHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsActionAllowed)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsActionAllowed)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutPossible),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(action)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableVirtualTemperature)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableVirtualTemperature)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(location)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableVirtualTemperature)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableVirtualTemperature)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(location)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetVirtualTemperature)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetVirtualTemperature)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(location),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(temperature)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableFanControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableFanControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableFanControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableFanControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsFanControlEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsFanControlEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSkinTemperatureMilliC)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSkinTemperatureMilliC)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSkinTemperatureMilliC)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetOperatingMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetThermalEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsActionAllowed)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableVirtualTemperature)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableVirtualTemperature)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetVirtualTemperature)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableFanControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableFanControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsFanControlEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSkinTemperatureMilliC)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::tc::IManager))
