﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief    Private header file for SSL library.
 */

#pragma once

#include <nn/ssl/ssl_Types.h>

namespace nn { namespace ssl {
/**
 * @brief   The class used to enable SSLv2 or SSLv3.
 */
class ContextPrivate : public Context {

public:
    /**
     * @brief    SSL version to be used
     */
    enum SslVersion
    {
        SslVersion_SslV3  = 0x04, //!< SSLv3
    };

    nn::Result Create(SslVersion version) NN_NOEXCEPT;
};

}}
