﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <cstdint>
#include <cstddef>

#include <nn/ssl/ssl_Types.h>


namespace nn { namespace ssl { namespace detail {


//  Binary packed Built-in Data File structures.
//  THESE MUST BE BETWEEN THE PACK PRAGMAS.
#pragma pack(push, 1)
typedef struct BdfMetaHdrDataEntryStr
{
    uint32_t                    dataId;
    uint32_t                    dataStatus;
    uint32_t                    dataSize;
    uint32_t                    dataOffset;
} BdfMetaDataEntry;


typedef struct BdfMetaHdrStr
{
    uint32_t                    magicNum;
    uint32_t                    dataCount;
} BdfMetaHdr;
#pragma pack(pop)


class BuiltinDataLoader
{
public:
    virtual ~BuiltinDataLoader() {};
    virtual uint32_t GetDataBufSize() = 0;
    virtual int Load(uint8_t *pOutBuf, uint32_t maxBufSize, uint32_t *pOutDataSize) = 0;
};


class BuiltinDataInfo
{
public:
    //  This matches nn::ssl::TrustedCertStatus, but not all status
    //  values are valid for data types.  The managers and parsers are
    //  responsible for enforcing the correct status values.
    enum BuiltinDataStatus
    {
        BuiltinDataStatus_Invalid   = 0xFFFFFFFF,
        BuiltinDataStatus_Removed   = 0x00000000,
        BuiltinDataStatus_Enabled   = 0x00000001,
        BuiltinDataStatus_Disabled  = 0x00000002,
        BuiltinDataStatus_Revoked   = 0x00000003,
    };

private:
    uint32_t                    m_Id;
    BuiltinDataStatus           m_Status;
    const char                  *m_pName;
    BuiltinDataLoader           *m_pLoader;

public:
    static const uint32_t       g_BdfMagicNum = 0x546C7373;
    static const uint32_t       g_DataIdAll = 0xFFFFFFFF;

    BuiltinDataInfo(uint32_t           id,
                    BuiltinDataStatus  status,
                    const char         *pCertName,
                    BuiltinDataLoader  *pLoader);
    ~BuiltinDataInfo();

    uint32_t GetId();
    BuiltinDataStatus GetStatus();
    const char *GetName();
    int GetData(uint8_t *pOutData, uint32_t bufSize, uint32_t *pOutCertSize);
    uint32_t GetDataSize();
};

} } }    //  nn::ssl::detail
