﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace srepo {

/*!
    @brief      1 つの SystemReport インスタンスに記録できるキーバリューの最大数です。
*/
const int KeyValueCountMax = 100;

/*!
    @brief      イベント ID の最大長です。
*/
const size_t EventIdLengthMax = 31;

/*!
    @brief      キーの最大長です。
*/
const size_t KeyLengthMax = 63;

/*!
    @brief      バリューを文字列表現した場合の、バリューの最大長です。
*/
const size_t StringValueLengthMax = 63;

/*!
    @brief      キーバリューデータの最大サイズです。
*/
const size_t KeyValueSizeMax = 2 + KeyLengthMax + 2 + StringValueLengthMax;

/*!
    @brief      レポートデータの記録バッファの最小サイズです。
*/
const size_t ReportBufferSizeMin = 3;

/*!
    @brief      レポートデータの記録バッファの最大サイズです。
*/
const size_t ReportBufferSizeMax = ReportBufferSizeMin + KeyValueSizeMax * KeyValueCountMax;

/*!
    @brief      任意の 64 ビット長の ID です。

    @details
                アプリケーション ID 等、符号なし 64 ビット長のデータを記述します。
*/
struct Any64BitId
{
    Bit64 id;
};

/*!
    @brief      バリューをバイナリ列表現した場合の、バリューの最大長です。
*/
const size_t BinaryValueSizeMax = 2048;

/*!
    @brief      レポートの分類です。
*/
enum ReportCategory
{
    ReportCategory_Normal,       //!< 通常のレポート。
    ReportCategory_AntiPiracy,   //!< 海賊版対策用のレポート。

    ReportCategory_Defualt  = ReportCategory_Normal,
    ReportCategory_First    = ReportCategory_Normal,
    ReportCategory_Last     = ReportCategory_AntiPiracy
};

}}
