﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_StaticAssert.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/nn_ApplicationId.h>
#include <algorithm>
#include <atomic>
#include <cstdio>
#include <cstring>

#if defined (NN_BUILD_CONFIG_OS_WIN)
#include <nn/nn_Windows.h>
#endif

#include <nn/account/account_Types.h>
#include <nn/os.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_LockGuard.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_StringUtil.h>
#include <nn/util/util_Span.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/srepo/srepo_Result.h>

#include <nn/srepo/srepo_Types.h>
#include <nn/srepo/srepo_TypesAdmin.h>

#include <nn/srepo/detail/srepo_Log.h>
#include <nn/srepo/detail/srepo_TypesDetail.h>

#include <nn/srepo/detail/msgpack/srepo_MessagePack.h>

/*!
    @brief  nn::util::SNPrintf をASSERT付きで行うマクロ

    @details
        bufferサイズが足りていることを ASSERT で検証します。
        引数は nn::util::SNPrintf(...) と同様です。
*/
#define NN_DETAIL_SREPO_SN_PRINTF(buffer, len, ...)             \
    do                                                          \
    {                                                           \
        int _r = nn::util::SNPrintf(buffer, len, __VA_ARGS__);  \
        NN_SDK_ASSERT(_r < static_cast<int>(len), buffer);      \
        NN_UNUSED(_r);                                          \
    }                                                           \
    while (NN_STATIC_CONDITION(false))

/*!
    @brief  nn::util::Strlcpy をASSERT付きで行うマクロ

    @details
        bufferサイズが足りていることを ASSERT で検証します。
        引数は nn::util::Strlcpy(...) と同様です。
*/
#define NN_DETAIL_SREPO_STRLCPY(buffer, src, len)               \
    do                                                          \
    {                                                           \
        int _r = nn::util::Strlcpy(buffer, src, len);           \
        NN_SDK_ASSERT(_r < static_cast<int>(len), buffer);      \
        NN_UNUSED(_r);                                          \
    }                                                           \
    while (NN_STATIC_CONDITION(false))
