﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace srepo { namespace detail { namespace ipc {

//// SrepoService

/*!
    @brief      1 プロセスあたりの SrepoService 数です。
*/
const int SrepoServiceCountPerProcess = 1;

/*!
    @brief      SrepoService を利用するプロセス同時接続数です。
*/
const int SrepoServiceProcessCountMax = 16;

/*!
    @brief      SrepoService の最大数です。

    @details
                1 つの SrepoServiceObject をすべてのプロセスでシェアするため、 1 でカウントされます。
*/
const int SrepoServiceCountMax = 1;

//// Session

/*!
    @brief      1 プロセスあたりのセッション数です。
*/
const int SessionCountPerProcess = 1;

/*!
    @brief      一般権限のサービスの最大セッション数です。
*/
const int SessionCountMaxForUser = 15;

/*!
    @brief      全権のサービスの最大セッション数です。
*/
const int SessionCountMaxForAdministrator = 1;

//// Object

/*!
    @brief      1 プロセスあたりのオブジェクト数です。
*/
const int ObjectCountPerProcess = SrepoServiceCountPerProcess;

}}}}
