﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       PTM に関する設定 API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/settings/factory/settings_BatteryLot.h>
#include <nn/settings/system/settings_Common.h>

namespace nn { namespace settings { namespace system {

/**
 * @brief       PTM の電池 LOT を表す型です。
 */
typedef ::nn::settings::factory::BatteryLot PtmBatteryLot;

/**
 * @brief       PTM の電池残量パラメータを表す構造体です。
 */
struct PtmFuelGaugeParameter
{
    uint16_t rcomp0;
    uint16_t tempCo;
    uint16_t fullCap;
    uint16_t fullCapNom;
    uint16_t iavg_empty;
    uint16_t qrTable00;
    uint16_t qrTable10;
    uint16_t qrTable20;
    uint16_t qrTable30;
    NN_PADDING2;
    uint32_t cycles;
};

//! @name PTM 設定関連 API
//! @{

/**
 * @brief       PTM の電池 LOT を取得します。
 *
 * @param[out]  pOutValue                       電池 LOT を読み出すバッファ
 *
 * @pre
 *              - pOutValue != nullptr
 */
void GetPtmBatteryLot(PtmBatteryLot* pOutValue) NN_NOEXCEPT;

/**
 * @brief       PTM の電池 LOT を設定します。
 *
 * @param[in]   value                           電池 LOT
 */
void SetPtmBatteryLot(const PtmBatteryLot& value) NN_NOEXCEPT;

/**
 * @brief       PTM の電池残量パラメータを取得します。
 *
 * @param[out]  pOutValue                       電池残量パラメータを読み出すバッファ
 *
 * @pre
 *              - pOutValue != nullptr
 */
void GetPtmFuelGaugeParameter(PtmFuelGaugeParameter* pOutValue) NN_NOEXCEPT;

/**
 * @brief       PTM の電池残量パラメータを設定します。
 *
 * @param[in]   value                           電池残量パラメータ
 */
void SetPtmFuelGaugeParameter(const PtmFuelGaugeParameter& value) NN_NOEXCEPT;

//! @}

}}} // nn::settings::system
