﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       Mii 設定に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Common.h>
#include <nn/util/util_Uuid.h>

namespace nn { namespace settings { namespace system {

/**
 * @brief       Mii 作者 ID を返します。
 *
 * @param[out]  pOutValue                   Mii 作者 ID を読み出すバッファ
 *
 * @pre
 *              - pOutValue != nullptr
 */
void GetMiiAuthorId(::nn::util::Uuid* pOutValue) NN_NOEXCEPT;

}}} // namespace nn::settings::system
