﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       FATAL 表示に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os/os_SystemEventTypes.h>
#include <nn/settings/system/settings_Common.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace settings { namespace system {

/**
 * @brief       FATAL 表示向けダーティーフラグの定義です。
 */
struct FatalDirtyFlag
{
    typedef ::nn::util::BitFlagSet<128, FatalDirtyFlag>::Flag<0>
            LanguageCode;               //!< 言語設定
};

/**
 * @brief       FATAL 表示向けダーティーフラグ集合を扱う型です。
 */
typedef ::nn::util::BitFlagSet<128, FatalDirtyFlag> FatalDirtyFlagSet;

/**
 * @brief       FATAL 表示向けダーティーフラグの変更通知をバインドします。
 *
 * @param[in]   pEvent                      イベントオブジェクトを指すポインタ
 * @param[in]   clearMode                   イベントオブジェクトのクリアモード
 *
 * @pre
 *              - pEvent != nullptr
 *              - *pEvent は未初期化状態
 * @post
 *              - *pEvent は初期化状態
 *              - *pEvent はシグナル状態
 */
void BindFatalDirtyFlagEvent(
    ::nn::os::SystemEventType* pEvent,
    ::nn::os::EventClearMode clearMode) NN_NOEXCEPT;

/**
 * @brief       FATAL 表示向けダーティーフラグを取得します。
 *
 * @details     ダーティーフラグは設定項目に対応する変更 API の内部処理が
 *              完了した際に true となります。 本 API でその状態を取得すると、
 *              入れ替わる形で全てのダーティーフラグは false となります。
 *
 * @param[out]  pOutValue                   ダーティーフラグを読み出すバッファ
 *
 * @pre
 *              - pOutValue != nullptr
 */
void GetFatalDirtyFlags(FatalDirtyFlagSet* pOutValue) NN_NOEXCEPT;

}}} // namespace nn::settings::system
