﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       ブート設定に関する設定取得 API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/settings/system/settings_Common.h>

namespace nn { namespace settings { namespace system {

/**
 * @brief       初回ブートするシステムアプレットの ProgramId を返します。
 *
 * @return      初回ブートするシステムアプレットの ProgramId です。
 */
::nn::ncm::ProgramId GetInitialSystemAppletProgramId() NN_NOEXCEPT;

/**
 * @brief       初回ブートするオーバーレイ表示の ProgramId を返します。
 *
 * @return      初回ブートするオーバーレイ表示の ProgramId です。
 */
::nn::ncm::ProgramId GetOverlayDispProgramId() NN_NOEXCEPT;

/**
 * @brief       修理中か否かを表す値を返します。
 *
 * @return      修理中か否かを表す値です。
 */
bool IsInRepairProcess() NN_NOEXCEPT;

/**
 * @brief       修理中か否かを表す値を設定します。
 *
 * @param[in]   value 修理中か否かを表す値
 */
void SetInRepairProcessEnabled(bool value) NN_NOEXCEPT;

/**
 * @brief       時計補正ツールの実行が必要か否かを表す値を返します。
 *
 * @return      時計補正ツールの実行が必要か否かを表す値です。
 */
bool RequiresRunRepairTimeReviser() NN_NOEXCEPT;

/**
 * @brief        時計補正ツールの実行が必要か否かを表す値を設定します。
 *
 * @param[in]   value 時計補正ツールの実行が必要か否かを表す値
 */
void SetRequiresRunRepairTimeReviser(bool value) NN_NOEXCEPT;

}}} // namespace nn::settings::system
