﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// このファイルは自動生成ファイルです。
// 手動で変更しないでください。

// NOLINT(build/header_guard)

// package 'private'
//! @defresult{settings,内部エラーです,105,100,149,ResultInternalError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultInternalError, 105, 100, 150);
    //! @defresult{settings,設定項目のキーをアロケートできません,105,101,101,ResultSettingsItemKeyAllocationFailed\, ResultInternalError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultSettingsItemKeyAllocationFailed, 105, 101, 102);
    //! @defresult{settings,設定項目の値をアロケートできません,105,102,102,ResultSettingsItemValueAllocationFailed\, ResultInternalError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultSettingsItemValueAllocationFailed, 105, 102, 103);
    //! @defresult{settings,設定項目のキーのイテレータをアロケートできません,105,111,111,ResultSettingsItemKeyIteratorAllocationFailed\, ResultInternalError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultSettingsItemKeyIteratorAllocationFailed, 105, 111, 112);
    //! @defresult{settings,設定の読み出し先が NULL 値です,105,121,121,ResultNullSettingsBuffer\, ResultInternalError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullSettingsBuffer, 105, 121, 122);
    //! @defresult{settings,設定のバイト数の読み出し先が NULL 値です,105,122,122,ResultNullSettingsCountBuffer\, ResultInternalError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullSettingsCountBuffer, 105, 122, 123);
    //! @defresult{settings,サポートされていない操作が行われました,105,131,131,ResultUnsupportedOperation\, ResultInternalError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultUnsupportedOperation, 105, 131, 132);
//! @defresulta{settings,Win32 API に関するエラーです,105,150,199,ResultWin32ApiError}
NN_DEFINE_ABSTRACT_ERROR_RANGE_RESULT(ResultWin32ApiError, 105, 150, 200);
    //! @defresult{settings,Win32 API によるミューテックスの作成に失敗しました,105,151,151,ResultWin32ApiFailedToCreateMutex\, ResultWin32ApiError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultWin32ApiFailedToCreateMutex, 105, 151, 152);
//! @defresult{settings,引数の値が無効です,105,200,399,ResultInvalidArgument}
NN_DEFINE_ERROR_RANGE_RESULT(ResultInvalidArgument, 105, 200, 400);
    //! @defresult{settings,設定の名前が NULL 値です,105,201,201,ResultNullSettingsName\, ResultInvalidArgument}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullSettingsName, 105, 201, 202);
    //! @defresult{settings,設定項目のキーが NULL 値です,105,202,202,ResultNullSettingsItemKey\, ResultInvalidArgument}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullSettingsItemKey, 105, 202, 203);
    //! @defresult{settings,設定項目の値が NULL 値です,105,203,203,ResultNullSettingsItemValue\, ResultInvalidArgument}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullSettingsItemValue, 105, 203, 204);
    //! @defresult{settings,設定項目のキーの読み出し先が NULL 値です,105,204,204,ResultNullSettingsItemKeyBuffer\, ResultInvalidArgument}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullSettingsItemKeyBuffer, 105, 204, 205);
    //! @defresult{settings,設定項目の値の読み出し先が NULL 値です,105,205,205,ResultNullSettingsItemValueBuffer\, ResultInvalidArgument}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullSettingsItemValueBuffer, 105, 205, 206);
    //! @defresult{settings,設定項目のキーのイテレータが NULL 値です,105,206,206,ResultNullSettingsItemKeyIterator\, ResultInvalidArgument}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullSettingsItemKeyIterator, 105, 206, 207);
    //! @defresult{settings,設定項目のキーについてバイト数の読み出し先が NULL 値です,105,207,207,ResultNullSettingsItemKeySizeBuffer\, ResultInvalidArgument}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullSettingsItemKeySizeBuffer, 105, 207, 208);
    //! @defresult{settings,設定項目の値についてバイト数の読み出し先が NULL 値です,105,208,208,ResultNullSettingsItemValueSizeBuffer\, ResultInvalidArgument}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullSettingsItemValueSizeBuffer, 105, 208, 209);
    //! @defresult{settings,デバッグモードが有効か否かを表す値の読み出し先が NULL 値です,105,209,209,ResultNullDebugModeFlagBuffer\, ResultInvalidArgument}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullDebugModeFlagBuffer, 105, 209, 210);
    //! @defresult{settings,設定の名前が空文字列です,105,221,221,ResultEmptySettingsName\, ResultInvalidArgument}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultEmptySettingsName, 105, 221, 222);
    //! @defresult{settings,設定項目のキーが空文字列です,105,222,222,ResultEmptySettingsItemKey\, ResultInvalidArgument}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultEmptySettingsItemKey, 105, 222, 223);
    //! @defresult{settings,設定の名前が長過ぎます,105,241,241,ResultTooLongSettingsName\, ResultInvalidArgument}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultTooLongSettingsName, 105, 241, 242);
    //! @defresult{settings,設定項目のキーが長過ぎます,105,242,242,ResultTooLongSettingsItemKey\, ResultInvalidArgument}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultTooLongSettingsItemKey, 105, 242, 243);
    //! @defresult{settings,設定の名前が不正な書式です,105,261,261,ResultInvalidFormatSettingsName\, ResultInvalidArgument}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultInvalidFormatSettingsName, 105, 261, 262);
    //! @defresult{settings,設定項目のキーが不正な書式です,105,262,262,ResultInvalidFormatSettingsItemKey\, ResultInvalidArgument}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultInvalidFormatSettingsItemKey, 105, 262, 263);
    //! @defresult{settings,設定項目のキーのイテレータが不正です,105,281,281,ResultInvalidSettingsItemKeyIterator\, ResultInvalidArgument}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultInvalidSettingsItemKeyIterator, 105, 281, 282);
//! @defresulta{settings,キャリブレーション値の内部エラーです,105,400,579,ResultCalibrationDataInternalError}
NN_DEFINE_ABSTRACT_ERROR_RANGE_RESULT(ResultCalibrationDataInternalError, 105, 400, 580);
    //! @defresult{settings,構成識別子1 の値が CRC と一致しません,105,422,422,ResultConfigurationId1CrcError\, ResultCalibrationDataInternalError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultConfigurationId1CrcError, 105, 422, 423);
    //! @defresult{settings,製品リージョンコードの値が CRC と一致しません,105,431,431,ResultRegionCodeCrcError\, ResultCalibrationDataInternalError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultRegionCodeCrcError, 105, 431, 432);
//! @defresult{settings,リージョンのエラーです,105,600,609,ResultRegionError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultRegionError, 105, 600, 610);
    //! @defresult{settings,リージョンコードを読み出すバッファが NULL 値です,105,601,601,ResultNullRegionCodeBuffer\, ResultRegionError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullRegionCodeBuffer, 105, 601, 602);
//! @defresult{settings,言語設定のエラーです,105,620,629,ResultLanguageError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultLanguageError, 105, 620, 630);
    //! @defresult{settings,言語コードを読み出すバッファが NULL 値です,105,621,621,ResultNullLanguageCodeBuffer\, ResultLanguageError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullLanguageCodeBuffer, 105, 621, 622);
    //! @defresult{settings,言語コードの数を読み出すバッファが NULL 値です,105,622,622,ResultNullLanguageCodeCountBuffer\, ResultLanguageError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullLanguageCodeCountBuffer, 105, 622, 623);
    //! @defresult{settings,言語の値が不正です,105,625,625,ResultInvalidLanguage\, ResultLanguageError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultInvalidLanguage, 105, 625, 626);
//! @defresult{settings,ネットワーク設定のエラーです,105,630,639,ResultNetworkError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultNetworkError, 105, 630, 640);
    //! @defresult{settings,ネットワーク設定を読み出すバッファが NULL 値です,105,631,631,ResultNullNetworkSettingsBuffer\, ResultNetworkError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullNetworkSettingsBuffer, 105, 631, 632);
    //! @defresult{settings,ネットワーク設定の数を読み出すバッファが NULL 値です,105,632,632,ResultNullNetworkSettingsCountBuffer\, ResultNetworkError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullNetworkSettingsCountBuffer, 105, 632, 633);
//! @defresult{settings,画面の明るさの設定のエラーです,105,640,649,ResultBacklightError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultBacklightError, 105, 640, 650);
    //! @defresult{settings,画面の明るさの設定を読み出すバッファが NULL 値です,105,641,641,ResultNullBacklightSettingsBuffer\, ResultBacklightError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullBacklightSettingsBuffer, 105, 641, 642);
//! @defresult{settings,Bluetoothの設定のエラーです,105,650,659,ResultBluetoothDevicesError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultBluetoothDevicesError, 105, 650, 660);
    //! @defresult{settings,Bluetooth 設定を読み出すバッファが NULL 値です,105,651,651,ResultNullBluetoothDevicesSettingsBuffer\, ResultBluetoothDevicesError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullBluetoothDevicesSettingsBuffer, 105, 651, 652);
    //! @defresult{settings,Bluetooth 設定の数を読み出すバッファが NULL 値です,105,652,652,ResultNullBluetoothDevicesSettingsCountBuffer\, ResultBluetoothDevicesError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullBluetoothDevicesSettingsCountBuffer, 105, 652, 653);
    //! @defresult{settings,Bluetooth が有効か否かを表す値を読み出すバッファが NULL 値です,105,653,653,ResultNullBluetoothEnableFlagBuffer\, ResultBluetoothDevicesError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullBluetoothEnableFlagBuffer, 105, 653, 654);
    //! @defresult{settings,Bluetooth の AFH が有効か否かを表す値を読み出すバッファが NULL 値です,105,654,654,ResultNullBluetoothAfhEnableFlagBuffer\, ResultBluetoothDevicesError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullBluetoothAfhEnableFlagBuffer, 105, 654, 655);
    //! @defresult{settings,Bluetooth の Boost が有効か否かを表す値を読み出すバッファが NULL 値です,105,655,655,ResultNullBluetoothBoostEnableFlagBuffer\, ResultBluetoothDevicesError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullBluetoothBoostEnableFlagBuffer, 105, 655, 656);
    //! @defresult{settings,BLE ペアリング設定を読み出すバッファが NULL 値です,105,656,656,ResultNullBlePairingSettingsBuffer\, ResultBluetoothDevicesError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullBlePairingSettingsBuffer, 105, 656, 657);
    //! @defresult{settings,BLE ペアリング設定の数を読み出すバッファが NULL 値です,105,657,657,ResultNullBlePairingSettingsCountBuffer\, ResultBluetoothDevicesError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullBlePairingSettingsCountBuffer, 105, 657, 658);
//! @defresult{settings,クロック設定のエラーです,105,660,669,ResultClockError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultClockError, 105, 660, 670);
    //! @defresult{settings,ExternalSteadyClock のソース ID を読み出すバッファが NULL 値です,105,661,661,ResultNullExternalSteadyClockSourceIdBuffer\, ResultClockError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullExternalSteadyClockSourceIdBuffer, 105, 661, 662);
    //! @defresult{settings,UserSystemClock のコンテキストを読み出すバッファが NULL 値です,105,662,662,ResultNullUserSystemClockContextBuffer\, ResultClockError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullUserSystemClockContextBuffer, 105, 662, 663);
    //! @defresult{settings,NetworkSystemClock のコンテキストを読み出すバッファが NULL 値です,105,663,663,ResultNullNetworkSystemClockContextBuffer\, ResultClockError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullNetworkSystemClockContextBuffer, 105, 663, 664);
    //! @defresult{settings,UserSystemClock の自動補正フラグを読み出すバッファが NULL 値です,105,664,664,ResultNullUserSystemClockAutomaticCorrectionEnabledBuffer\, ResultClockError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullUserSystemClockAutomaticCorrectionEnabledBuffer, 105, 664, 665);
    //! @defresult{settings,シャットダウン時の RTC 値を読み出すバッファが NULL 値です,105,665,665,ResultNullShutdownRtcValueBuffer\, ResultClockError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullShutdownRtcValueBuffer, 105, 665, 666);
    //! @defresult{settings,ExternalSteadyClock の内部オフセットを読み出すバッファが NULL 値です,105,666,666,ResultNullExternalSteadyClockInternalOffsetBuffer\, ResultClockError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullExternalSteadyClockInternalOffsetBuffer, 105, 666, 667);
    //! @defresult{settings,UserSystemClock の自動補正フラグの更新時間を読み出すバッファが NULL 値です,105,667,667,ResultNullUserSystemClockAutomaticCorrectionUpdatedTimeBuffer\, ResultClockError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullUserSystemClockAutomaticCorrectionUpdatedTimeBuffer, 105, 667, 668);
//! @defresult{settings,アカウント設定のエラーです,105,670,679,ResultAccountError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultAccountError, 105, 670, 680);
    //! @defresult{settings,アカウント設定を読み出すバッファが NULL 値です,105,671,671,ResultNullAccountSettingsBuffer\, ResultAccountError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAccountSettingsBuffer, 105, 671, 672);
//! @defresult{settings,オーディオ設定のエラーです,105,680,689,ResultAudioError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultAudioError, 105, 680, 690);
    //! @defresult{settings,本体音量設定を読み出すバッファが NULL 値です,105,681,681,ResultNullAudioVolumeBuffer\, ResultAudioError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAudioVolumeBuffer, 105, 681, 682);
    //! @defresult{settings,本体オーディオ出力設定を読み出すバッファが NULL 値です,105,682,682,ResultNullAudioOutputModeBuffer\, ResultAudioError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAudioOutputModeBuffer, 105, 682, 683);
    //! @defresult{settings,ヘッドフォン抜け時の強制ミュート設定を読み出すバッファが NULL 値です,105,683,683,ResultNullForceMuteOnHeadphoneRemovedBuffer\, ResultAudioError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullForceMuteOnHeadphoneRemovedBuffer, 105, 683, 684);
    //! @defresult{settings,ヘッドホン音量の警告表示イベントの回数を読み出すバッファが NULL 値です,105,684,684,ResultNullHeadphoneVolumeWarningCountBuffer\, ResultAudioError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullHeadphoneVolumeWarningCountBuffer, 105, 684, 685);
    //! @defresult{settings,本体音量設定の操作対象が不正です,105,685,685,ResultInvalidAudioVolumeTarget\, ResultAudioError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultInvalidAudioVolumeTarget, 105, 685, 686);
    //! @defresult{settings,本体オーディオ出力設定が不正です,105,686,686,ResultInvalidAudioOutputMode\, ResultAudioError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultInvalidAudioOutputMode, 105, 686, 687);
    //! @defresult{settings,本体オーディオ出力設定の操作対象が不正です,105,687,687,ResultInvalidAudioOutputModeTarget\, ResultAudioError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultInvalidAudioOutputModeTarget, 105, 687, 688);
    //! @defresult{settings,本体ヘッドホン音量が更新済みか否かを表す値を読み出すバッファが NULL 値です,105,688,688,ResultNullHeadphoneVolumeUpdateFlagBuffer\, ResultAudioError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullHeadphoneVolumeUpdateFlagBuffer, 105, 688, 689);
    //! @defresult{settings,出力レベルアップが利用可能か否かを表す値を読み出すバッファが NULL 値です,105,689,689,ResultNullHighPowerAvailableFlagBuffer\, ResultAudioError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullHighPowerAvailableFlagBuffer, 105, 689, 690);
//! @defresult{settings,ネットワークサービス設定のエラーです,105,690,699,ResultNetworkServiceError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultNetworkServiceError, 105, 690, 700);
    //! @defresult{settings,本体情報アップロードが有効か否かを表す値を読み出すバッファが NULL 値です,105,691,691,ResultNullConsoleInformationUploadFlagBuffer\, ResultNetworkServiceError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullConsoleInformationUploadFlagBuffer, 105, 691, 692);
//! @defresult{settings,お知らせ設定のエラーです,105,700,709,ResultNewsError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultNewsError, 105, 700, 710);
    //! @defresult{settings,アプリケーション自動配信が有効か否かを表す値を読み出すバッファが NULL 値です,105,701,701,ResultNullAutomaticApplicationDownloadFlagBuffer\, ResultNewsError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAutomaticApplicationDownloadFlagBuffer, 105, 701, 702);
    //! @defresult{settings,通知設定を読み出すバッファが NULL 値です,105,702,702,ResultNullNotificationSettingsBuffer\, ResultNewsError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullNotificationSettingsBuffer, 105, 702, 703);
    //! @defresult{settings,アカウント毎の通知設定の数を読み出すバッファが NULL 値です,105,703,703,ResultNullAccountNotificationSettingsCountBuffer\, ResultNewsError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAccountNotificationSettingsCountBuffer, 105, 703, 704);
    //! @defresult{settings,アカウント毎の通知設定を読み出すバッファが NULL 値です,105,704,704,ResultNullAccountNotificationSettingsBuffer\, ResultNewsError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAccountNotificationSettingsBuffer, 105, 704, 705);
    //! @defresult{settings,アカウント毎の通知設定が NULL 値です,105,705,705,ResultNullAccountNotificationSettings\, ResultNewsError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAccountNotificationSettings, 105, 705, 706);
//! @defresult{settings,HID 設定のエラーです,105,710,719,ResultHidError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultHidError, 105, 710, 720);
    //! @defresult{settings,振動のマスターボリュームを読み出すバッファが NULL 値です,105,711,711,ResultNullVibrationMasterVolumeBuffer\, ResultHidError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullVibrationMasterVolumeBuffer, 105, 711, 712);
    //! @defresult{settings,コントローラ情報を読み出すバッファが NULL 値です,105,712,712,ResultNullNxControllerSettingsBuffer\, ResultHidError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullNxControllerSettingsBuffer, 105, 712, 713);
    //! @defresult{settings,コントローラ情報の数を読み出すバッファが NULL 値です,105,713,713,ResultNullNxControllerSettingsCountBuffer\, ResultHidError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullNxControllerSettingsCountBuffer, 105, 713, 714);
    //! @defresult{settings,Pro Controller 有線 USB 通信機能が有効か否かを表す値を読み出すバッファが NULL 値です,105,714,714,ResultNullUsbFullKeyEnableFlagBuffer\, ResultHidError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullUsbFullKeyEnableFlagBuffer, 105, 714, 715);
//! @defresult{settings,TV 設定のエラーです,105,720,729,ResultTvError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultTvError, 105, 720, 730);
    //! @defresult{settings,TV 設定を読み出すバッファが NULL 値です,105,721,721,ResultNullTvSettingsBuffer\, ResultTvError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullTvSettingsBuffer, 105, 721, 722);
    //! @defresult{settings,EDID を読み出すバッファが NULL 値です,105,722,722,ResultNullEdidBuffer\, ResultTvError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullEdidBuffer, 105, 722, 723);
//! @defresult{settings,おすすめ削除設定のエラーです,105,730,739,ResultDataDeletionError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultDataDeletionError, 105, 730, 740);
    //! @defresult{settings,おすすめ削除設定を読み出すバッファが NULL 値です,105,731,731,ResultNullDataDeletionSettingsBuffer\, ResultDataDeletionError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullDataDeletionSettingsBuffer, 105, 731, 732);
//! @defresult{settings,ブート設定のエラーです,105,740,749,ResultBootError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultBootError, 105, 740, 750);
    //! @defresult{settings,初回ブートするシステムアプレットの ProgramId を読み出すバッファが NULL 値です,105,741,741,ResultNullInitialSystemAppletProgramIdBuffer\, ResultBootError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullInitialSystemAppletProgramIdBuffer, 105, 741, 742);
    //! @defresult{settings,初回ブートするオーバーレイ表示の ProgramId を読み出すバッファが NULL 値です,105,742,742,ResultNullOverlayDispProgramIdBuffer\, ResultBootError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullOverlayDispProgramIdBuffer, 105, 742, 743);
    //! @defresult{settings,修理中か否かを表す値を読み出すバッファが NULL 値です,105,743,743,ResultNullIsInRepairBuffer\, ResultBootError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullIsInRepairBuffer, 105, 743, 744);
    //! @defresult{settings,時計補正ツールの実行が必要か否かを表す値を読み出すバッファが NULL 値です,105,744,744,ResultNullRequiresRunRepairTimeReviser\, ResultBootError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullRequiresRunRepairTimeReviser, 105, 744, 745);
//! @defresult{settings,タイムゾーン設定のエラーです,105,750,759,ResultTimeZoneError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultTimeZoneError, 105, 750, 760);
    //! @defresult{settings,デバイスの地域名を読み出すバッファが NULL 値です,105,751,751,ResultNullDeviceTimeZoneLocationNameBuffer\, ResultTimeZoneError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullDeviceTimeZoneLocationNameBuffer, 105, 751, 752);
    //! @defresult{settings,デバイスの地域更新時間を読み出すバッファが NULL 値です,105,752,752,ResultNullDeviceTimeZoneLocationUpdatedTimeBuffer\, ResultTimeZoneError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullDeviceTimeZoneLocationUpdatedTimeBuffer, 105, 752, 753);
//! @defresult{settings,キャプチャ設定のエラーです,105,760,769,ResultCaptureError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultCaptureError, 105, 760, 770);
    //! @defresult{settings,撮影した画面写真を保存するストレージを読み出すバッファが NULL 値です,105,761,761,ResultNullPrimaryAlbumStorageBuffer\, ResultCaptureError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullPrimaryAlbumStorageBuffer, 105, 761, 762);
//! @defresult{settings,USB 設定のエラーです,105,770,779,ResultUsbError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultUsbError, 105, 770, 780);
    //! @defresult{settings,USB 3.0 が有効か否かを表す値を読み出すバッファが NULL 値です,105,771,771,ResultNullUsb30EnableFlagBuffer\, ResultUsbError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullUsb30EnableFlagBuffer, 105, 771, 772);
    //! @defresult{settings,USB Type-C Power Source 回路バージョンを読み出すバッファが NULL 値です,105,772,772,ResultNullUsbTypeCPowerSourceCircuitVersionBuffer\, ResultUsbError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullUsbTypeCPowerSourceCircuitVersionBuffer, 105, 772, 773);
//! @defresult{settings,電池 LOT のエラーです,105,780,789,ResultBatteryLotError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultBatteryLotError, 105, 780, 790);
    //! @defresult{settings,電池 LOT を読み出すバッファが NULL 値です,105,781,781,ResultNullBatteryLotBuffer\, ResultBatteryLotError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullBatteryLotBuffer, 105, 781, 782);
//! @defresult{settings,製品シリアル番号のエラーです,105,790,799,ResultSerialNumberError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultSerialNumberError, 105, 790, 800);
    //! @defresult{settings,製品シリアル番号を読み出すバッファが NULL 値です,105,791,791,ResultNullSerialNumberBuffer\, ResultSerialNumberError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullSerialNumberBuffer, 105, 791, 792);
//! @defresult{settings,システムアプリケーション設定のエラーです,105,800,999,ResultSystemApplicationError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultSystemApplicationError, 105, 800, 1000);
    //! @defresult{settings,携帯モード時誤操作防止画面の有無を読み出すバッファが NULL 値です,105,801,801,ResultNullLockScreenFlagBuffer\, ResultSystemApplicationError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullLockScreenFlagBuffer, 105, 801, 802);
    //! @defresult{settings,カラーセット ID を読み出すバッファが NULL 値です,105,803,803,ResultNullColorSetIdBuffer\, ResultSystemApplicationError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullColorSetIdBuffer, 105, 803, 804);
    //! @defresult{settings,Quest メニューを起動するか否かを表す値を読み出すバッファが NULL 値です,105,804,804,ResultNullQuestFlagBuffer\, ResultSystemApplicationError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullQuestFlagBuffer, 105, 804, 805);
    //! @defresult{settings,無線認証画像のファイルサイズを読み出すバッファが NULL 値です,105,805,805,ResultNullWirelessCertificationFileSizeBuffer\, ResultSystemApplicationError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullWirelessCertificationFileSizeBuffer, 105, 805, 806);
    //! @defresult{settings,無線認証画像を読み出すバッファが NULL 値です,105,806,806,ResultNullWirelessCertificationFileBuffer\, ResultSystemApplicationError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullWirelessCertificationFileBuffer, 105, 806, 807);
    //! @defresult{settings,初回起動設定を読み出すバッファが NULL 値です,105,807,807,ResultNullInitialLaunchSettingsBuffer\, ResultSystemApplicationError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullInitialLaunchSettingsBuffer, 105, 807, 808);
    //! @defresult{settings,本体の識別名を読み出すバッファが NULL 値です,105,808,808,ResultNullDeviceNickNameBuffer\, ResultSystemApplicationError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullDeviceNickNameBuffer, 105, 808, 809);
    //! @defresult{settings,バッテリー残量のパーセンテージ表示を行うか否か表す値を読み出すバッファが NULL 値です,105,809,809,ResultNullBatteryPercentageFlagBuffer\, ResultSystemApplicationError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullBatteryPercentageFlagBuffer, 105, 809, 810);
    //! @defresult{settings,アプレット起動の制御フラグを読み出すバッファが NULL 値です,105,810,810,ResultNullAppletLaunchFlagsBuffer\, ResultSystemApplicationError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAppletLaunchFlagsBuffer, 105, 810, 811);
//! @defresult{settings,無線 LAN の値のエラーです,105,1010,1019,ResultWirelessLanError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultWirelessLanError, 105, 1010, 1020);
    //! @defresult{settings,無線 LAN に対して設定された国名コードの数を読み出すバッファが NULL 値です,105,1011,1011,ResultNullWirelessLanCountryCodeCountBuffer\, ResultWirelessLanError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullWirelessLanCountryCodeCountBuffer, 105, 1011, 1012);
    //! @defresult{settings,無線 LAN が有効か否かを表す値を読み出すバッファが NULL 値です,105,1012,1012,ResultNullWirelessLanEnableFlagBuffer\, ResultWirelessLanError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullWirelessLanEnableFlagBuffer, 105, 1012, 1013);
//! @defresult{settings,製品モデルのエラーです,105,1020,1029,ResultProductModelError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultProductModelError, 105, 1020, 1030);
    //! @defresult{settings,製品モデルを読み出すバッファが NULL 値です,105,1021,1021,ResultNullProductModelBuffer\, ResultProductModelError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullProductModelBuffer, 105, 1021, 1022);
//! @defresult{settings,NFC 設定のエラーです,105,1030,1039,ResultNfcError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultNfcError, 105, 1030, 1040);
    //! @defresult{settings,NFC が有効か否かを表す値を読み出すバッファが NULL 値です,105,1031,1031,ResultNullNfcEnableFlagBuffer\, ResultNfcError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullNfcEnableFlagBuffer, 105, 1031, 1032);
//! @defresult{settings,デバイス証明書のエラーです,105,1040,1049,ResultDeviceCertificateError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultDeviceCertificateError, 105, 1040, 1050);
    //! @defresult{settings,デバイス登録用のデバイス証明書を読み出すバッファが NULL 値です,105,1041,1041,ResultNullEciDeviceCertificateBuffer\, ResultDeviceCertificateError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullEciDeviceCertificateBuffer, 105, 1041, 1042);
    //! @defresult{settings,eTicket 発行用のデバイス証明書を読み出すバッファが NULL 値です,105,1042,1042,ResultNullEticketDeviceCertificateBuffer\, ResultDeviceCertificateError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullEticketDeviceCertificateBuffer, 105, 1042, 1043);
//! @defresult{settings,スリープ設定のエラーです,105,1050,1059,ResultSleepError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultSleepError, 105, 1050, 1060);
    //! @defresult{settings,スリープ設定を読み出すバッファが NULL 値です,105,1051,1051,ResultNullSleepSettingsBuffer\, ResultSleepError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullSleepSettingsBuffer, 105, 1051, 1052);
    //! @defresult{settings,携帯モード時の自動スリープまでの時間が不正です,105,1055,1055,ResultInvalidHandheldSleepPlan\, ResultSleepError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultInvalidHandheldSleepPlan, 105, 1055, 1056);
    //! @defresult{settings,据置モード時の自動スリープまでの時間が不正です,105,1056,1056,ResultInvalidConsoleSleepPlan\, ResultSleepError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultInvalidConsoleSleepPlan, 105, 1056, 1057);
//! @defresult{settings,EULA のエラーです,105,1060,1069,ResultEulaError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultEulaError, 105, 1060, 1070);
    //! @defresult{settings,本体 EULA の同意バージョンを読み出すバッファが NULL 値です,105,1061,1061,ResultNullEulaVersionBuffer\, ResultEulaError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullEulaVersionBuffer, 105, 1061, 1062);
    //! @defresult{settings,本体 EULA の同意バージョンの数を読み出すバッファが NULL 値です,105,1062,1062,ResultNullEulaVersionCountBuffer\, ResultEulaError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullEulaVersionCountBuffer, 105, 1062, 1063);
//! @defresult{settings,ローカル通信設定のエラーです,105,1070,1079,ResultLdnError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultLdnError, 105, 1070, 1080);
    //! @defresult{settings,ローカル通信のチャンネルを読み出すバッファが NULL 値です,105,1071,1071,ResultNullLdnChannelBuffer\, ResultLdnError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullLdnChannelBuffer, 105, 1071, 1072);
//! @defresult{settings,SSL クライアント認証のエラーです,105,1080,1089,ResultSslError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultSslError, 105, 1080, 1090);
    //! @defresult{settings,SSL クライアント秘密鍵を読み出すバッファが NULL 値です,105,1081,1081,ResultNullSslKeyBuffer\, ResultSslError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullSslKeyBuffer, 105, 1081, 1082);
    //! @defresult{settings,SSL クライアント証明書を読み出すバッファが NULL 値です,105,1082,1082,ResultNullSslCertificateBuffer\, ResultSslError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullSslCertificateBuffer, 105, 1082, 1083);
//! @defresult{settings,障害情報収集のエラーです,105,1090,1099,ResultTelemetryError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultTelemetryError, 105, 1090, 1100);
    //! @defresult{settings,障害情報収集向けダーティーフラグを読み出すバッファが NULL 値です,105,1091,1091,ResultNullTelemetryDirtyFlagsBuffer\, ResultTelemetryError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullTelemetryDirtyFlagsBuffer, 105, 1091, 1092);
//! @defresult{settings,ゲームカード相互認証のエラーです,105,1100,1109,ResultGameCardError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultGameCardError, 105, 1100, 1110);
    //! @defresult{settings,ゲームカード相互認証秘密鍵を読み出すバッファが NULL 値です,105,1101,1101,ResultNullGameCardKeyBuffer\, ResultGameCardError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullGameCardKeyBuffer, 105, 1101, 1102);
    //! @defresult{settings,ゲームカード相互認証証明書を読み出すバッファが NULL 値です,105,1102,1102,ResultNullGameCardCertificateBuffer\, ResultGameCardError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullGameCardCertificateBuffer, 105, 1102, 1103);
//! @defresult{settings,PTM 設定のエラーです,105,1110,1119,ResultPtmError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultPtmError, 105, 1110, 1120);
    //! @defresult{settings,PTM の電池 LOT を読み出すバッファが NULL 値です,105,1111,1111,ResultNullPtmBatteryLotBuffer\, ResultPtmError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullPtmBatteryLotBuffer, 105, 1111, 1112);
    //! @defresult{settings,PTM の電池残量パラメータを読み出すバッファが NULL 値です,105,1112,1112,ResultNullPtmFuelGaugeParameterBuffer\, ResultPtmError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullPtmFuelGaugeParameterBuffer, 105, 1112, 1113);
//! @defresult{settings,デバイス秘密鍵のエラーです,105,1120,1129,ResultDeviceKeyError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultDeviceKeyError, 105, 1120, 1130);
    //! @defresult{settings,デバイス登録用のデバイス秘密鍵を読み出すバッファが NULL 値です,105,1121,1121,ResultNullEciDeviceKeyBuffer\, ResultDeviceKeyError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullEciDeviceKeyBuffer, 105, 1121, 1122);
    //! @defresult{settings,eTicket 発行用のデバイス秘密鍵を読み出すバッファが NULL 値です,105,1122,1122,ResultNullEticketDeviceKeyBuffer\, ResultDeviceKeyError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullEticketDeviceKeyBuffer, 105, 1122, 1123);
//! @defresult{settings,スピーカ設定のエラーです,105,1130,1139,ResultSpeakerError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultSpeakerError, 105, 1130, 1140);
    //! @defresult{settings,スピーカーのパラメータを読み出すバッファが NULL 値です,105,1131,1131,ResultNullSpeakerParameterBuffer\, ResultSpeakerError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullSpeakerParameterBuffer, 105, 1131, 1132);
//! @defresult{settings,ファームウェアバージョンのエラーです,105,1140,1149,ResultFirmwareVersionError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultFirmwareVersionError, 105, 1140, 1150);
    //! @defresult{settings,ファームウェアバージョンを読み出すバッファが NULL 値です,105,1141,1141,ResultNullFirmwareVersionBuffer\, ResultFirmwareVersionError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullFirmwareVersionBuffer, 105, 1141, 1142);
    //! @defresult{settings,ファームウェアバージョンのダイジェストを読み出すバッファが NULL 値です,105,1142,1142,ResultNullFirmwareVersionDigestBuffer\, ResultFirmwareVersionError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullFirmwareVersionDigestBuffer, 105, 1142, 1143);
    //! @defresult{settings,再起動不要 NUP バージョンを読み出すバッファが NULL 値です,105,1143,1143,ResultNullRebootlessSystemUpdateVersionBuffer\, ResultFirmwareVersionError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullRebootlessSystemUpdateVersionBuffer, 105, 1143, 1144);
//! @defresult{settings,Mii 設定のエラーです,105,1150,1159,ResultMiiError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultMiiError, 105, 1150, 1160);
    //! @defresult{settings,Mii 作者 ID を読み出すバッファが NULL 値です,105,1151,1151,ResultNullMiiAuthorIdBuffer\, ResultMiiError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullMiiAuthorIdBuffer, 105, 1151, 1152);
//! @defresult{settings,FATAL 表示のエラーです,105,1160,1169,ResultFatalError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultFatalError, 105, 1160, 1170);
    //! @defresult{settings,FATAL 表示向けダーティーフラグを読み出すバッファが NULL 値です,105,1161,1161,ResultNullFatalDirtyFlagsBuffer\, ResultFatalError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullFatalDirtyFlagsBuffer, 105, 1161, 1162);
//! @defresult{settings,DRM 設定のエラーです,105,1170,1179,ResultDrmError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultDrmError, 105, 1170, 1180);
    //! @defresult{settings,パッチの自動受信が有効か否かを表す値を読み出すバッファが NULL 値です,105,1171,1171,ResultNullAutoUpdateEnableFlagBuffer\, ResultDrmError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAutoUpdateEnableFlagBuffer, 105, 1171, 1172);
//! @defresult{settings,PCV 設定のエラーです,105,1180,1189,ResultPcvError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultPcvError, 105, 1180, 1190);
    //! @defresult{settings,外部 RTC のリセットが発生したか否かを表す値を読み出すバッファが NULL 値です,105,1181,1181,ResultNullExternalRtcResetFlagBuffer\, ResultPcvError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullExternalRtcResetFlagBuffer, 105, 1181, 1182);
//! @defresult{settings,プッシュ通知設定のエラーです,105,1190,1199,ResultPushNotificationError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultPushNotificationError, 105, 1190, 1200);
    //! @defresult{settings,プッシュ通知の動作モードを読み出すバッファが NULL 値です,105,1191,1191,ResultNullPushNotificationActivityModeBuffer\, ResultPushNotificationError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullPushNotificationActivityModeBuffer, 105, 1191, 1192);
//! @defresult{settings,サービスディスカバリ設定のエラーです,105,1200,1209,ResultServiceDiscoveryError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultServiceDiscoveryError, 105, 1200, 1210);
    //! @defresult{settings,サービスディスカバリの制御設定の値を呼び出すバッファが NULL 値です,105,1201,1201,ResultNullServiceDiscoveryControlSettingsBuffer\, ResultServiceDiscoveryError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullServiceDiscoveryControlSettingsBuffer, 105, 1201, 1202);
//! @defresult{settings,エラーレポート設定のエラーです,105,1210,1219,ResultErrorReportError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultErrorReportError, 105, 1210, 1220);
    //! @defresult{settings,エラーレポートを他社に提供してよいかの許可状態を読み出すバッファが NULL 値です,105,1211,1211,ResultNullErrorReportSharePermissionBuffer\, ResultErrorReportError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullErrorReportSharePermissionBuffer, 105, 1211, 1212);
//! @defresult{settings,LCD 設定のエラーです,105,1220,1229,ResultLcdError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultLcdError, 105, 1220, 1230);
    //! @defresult{settings,LCD ベンダ ID を読み出すバッファが NULL 値です,105,1221,1221,ResultNullLcdVendorIdBuffer\, ResultLcdError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullLcdVendorIdBuffer, 105, 1221, 1222);
//! @defresult{settings,SixAxisSensor 設定のエラーです,105,1230,1239,ResultSixAxisSensorError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultSixAxisSensorError, 105, 1230, 1240);
    //! @defresult{settings,本体 6 軸センサーの加速度バイアス設定を読み出すバッファが NULL 値です,105,1231,1231,ResultNullConsoleSixAxisSensorAccelerationBiasBuffer\, ResultSixAxisSensorError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullConsoleSixAxisSensorAccelerationBiasBuffer, 105, 1231, 1232);
    //! @defresult{settings,本体 6 軸センサーの角速度バイアス設定を読み出すバッファが NULL 値です,105,1232,1232,ResultNullConsoleSixAxisSensorAngularVelocityBiasBuffer\, ResultSixAxisSensorError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullConsoleSixAxisSensorAngularVelocityBiasBuffer, 105, 1232, 1233);
    //! @defresult{settings,本体 6 軸センサーの加速度ゲイン設定を読み出すバッファが NULL 値です,105,1233,1233,ResultNullConsoleSixAxisSensorAccelerationGainBuffer\, ResultSixAxisSensorError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullConsoleSixAxisSensorAccelerationGainBuffer, 105, 1233, 1234);
    //! @defresult{settings,本体 6 軸センサーの角速度ゲイン設定を読み出すバッファが NULL 値です,105,1234,1234,ResultNullConsoleSixAxisSensorAngularVelocityGainBuffer\, ResultSixAxisSensorError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullConsoleSixAxisSensorAngularVelocityGainBuffer, 105, 1234, 1235);
    //! @defresult{settings,本体 6 軸センサーの角速度の時間バイアス設定を読み出すバッファが NULL 値です,105,1235,1235,ResultNullConsoleSixAxisSensorAngularVelocityTimeBiasBuffer\, ResultSixAxisSensorError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullConsoleSixAxisSensorAngularVelocityTimeBiasBuffer, 105, 1235, 1236);
    //! @defresult{settings,本体 6 軸センサーの角加速度の係数設定を読み出すバッファが NULL 値です,105,1236,1236,ResultNullConsoleSixAxisSensorAngularAccelerationBuffer\, ResultSixAxisSensorError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullConsoleSixAxisSensorAngularAccelerationBuffer, 105, 1236, 1237);
//! @defresult{settings,キーボード設定のエラーです,105,1240,1249,ResultKeyboardError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultKeyboardError, 105, 1240, 1250);
    //! @defresult{settings,キーボード配列の種類を読み出すバッファが NULL 値です,105,1241,1241,ResultNullKeyboardLayoutBuffer\, ResultKeyboardError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullKeyboardLayoutBuffer, 105, 1241, 1242);
    //! @defresult{settings,キーボード配列の種類が不正です,105,1245,1245,ResultInvalidKeyboardLayout\, ResultKeyboardError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultInvalidKeyboardLayout, 105, 1245, 1246);
//! @defresult{settings,Cruiser 用デバッグ設定のエラーです,105,1250,1259,ResultWebError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultWebError, 105, 1250, 1260);
    //! @defresult{settings,Web インスペクタを使用するか否かを表す値を読み出すバッファが NULL 値です,105,1251,1251,ResultNullWebInspectorFlagBuffer\, ResultWebError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullWebInspectorFlagBuffer, 105, 1251, 1252);
    //! @defresult{settings,SSL チェック無効化ホストを読み出すバッファが NULL 値です,105,1252,1252,ResultNullAllowedSslHostsBuffer\, ResultWebError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAllowedSslHostsBuffer, 105, 1252, 1253);
    //! @defresult{settings,SSL チェック無効化ホストの数を読み出すバッファが NULL 値です,105,1253,1253,ResultNullAllowedSslHostsCountBuffer\, ResultWebError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAllowedSslHostsCountBuffer, 105, 1253, 1254);
    //! @defresult{settings,ホスト FS のマウントポイントを読み出すバッファが NULL 値です,105,1254,1254,ResultNullHostFsMountPointBuffer\, ResultWebError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullHostFsMountPointBuffer, 105, 1254, 1255);
//! @defresult{settings,キー入力の文字コード変換表のエラーです,105,1260,1269,ResultKeyCodeMapError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultKeyCodeMapError, 105, 1260, 1270);
    //! @defresult{settings,キー入力の文字コード変換表を読み出すバッファが NULL 値です,105,1261,1261,ResultNullKeyCodeMapBuffer\, ResultKeyCodeMapError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullKeyCodeMapBuffer, 105, 1261, 1262);
//! @defresult{settings,Amiibo 設定のエラーです,105,1270,1279,ResultAmiiboError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultAmiiboError, 105, 1270, 1280);
    //! @defresult{settings,amiibo 用本体秘密鍵を読み出すバッファが NULL 値です,105,1271,1271,ResultNullAmiiboKeyBuffer\, ResultAmiiboError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAmiiboKeyBuffer, 105, 1271, 1272);
    //! @defresult{settings,amiibo 用 ECQV 証明書を読み出すバッファが NULL 値です,105,1272,1272,ResultNullAmiiboEcqvCertificateBuffer\, ResultAmiiboError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAmiiboEcqvCertificateBuffer, 105, 1272, 1273);
    //! @defresult{settings,amiibo 用 ECDSA 証明書を読み出すバッファが NULL 値です,105,1273,1273,ResultNullAmiiboEcdsaCertificateBuffer\, ResultAmiiboError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAmiiboEcdsaCertificateBuffer, 105, 1273, 1274);
    //! @defresult{settings,amiibo 用本体秘密鍵 (ECQV-BLS 版) を読み出すバッファが NULL 値です,105,1274,1274,ResultNullAmiiboEcqvBlsKeyBuffer\, ResultAmiiboError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAmiiboEcqvBlsKeyBuffer, 105, 1274, 1275);
    //! @defresult{settings,amiibo 用 ECQV-BLS 証明書を読み出すバッファが NULL 値です,105,1275,1275,ResultNullAmiiboEcqvBlsCertificateBuffer\, ResultAmiiboError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAmiiboEcqvBlsCertificateBuffer, 105, 1275, 1276);
    //! @defresult{settings,amiibo 用ルート証明書 (ECQV-BLS 版) を読み出すバッファが NULL 値です,105,1276,1276,ResultNullAmiiboEcqvBlsRootCertificateBuffer\, ResultAmiiboError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAmiiboEcqvBlsRootCertificateBuffer, 105, 1276, 1277);
//! @defresult{settings,オンラインストレージ設定のエラーです,105,1280,1299,ResultOnlineStorageError}
NN_DEFINE_ERROR_RANGE_RESULT(ResultOnlineStorageError, 105, 1280, 1300);
    //! @defresult{settings,アカウント毎のオンラインストレージ設定の数を読み出すバッファが NULL 値です,105,1281,1281,ResultNullAccountOnlineStorageSettingsCountBuffer\, ResultOnlineStorageError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAccountOnlineStorageSettingsCountBuffer, 105, 1281, 1282);
    //! @defresult{settings,アカウント毎のオンラインストレージ設定を読み出すバッファが NULL 値です,105,1282,1282,ResultNullAccountOnlineStorageSettingsBuffer\, ResultOnlineStorageError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAccountOnlineStorageSettingsBuffer, 105, 1282, 1283);
    //! @defresult{settings,アカウント毎のオンラインストレージ設定が NULL 値です,105,1283,1283,ResultNullAccountOnlineStorageSettings\, ResultOnlineStorageError}
    NN_DEFINE_ERROR_RANGE_RESULT(ResultNullAccountOnlineStorageSettings, 105, 1283, 1284);
