﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 *  @file
 *  @brief   構成識別子の製造時設定に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>

namespace nn { namespace settings { namespace factory {

/**
 * @brief       構成識別子 1 を表す構造体です。
 */
struct ConfigurationId1
{
    char string[30];    //!< ハードウェア構成を表す文字列（NULL 終端）
};

/**
 * @brief       構成識別子 1 を取得します。
 *
 * @details     製造時に設定された構成識別子 1 を取得します。
 *
 * @param[out]  outValue                    構成識別子 1 を読み出すバッファ
 *
 * @pre
 *              - outValue != nullptr
 */
void GetConfigurationId1(ConfigurationId1* outValue) NN_NOEXCEPT;

}}} // nn::settings::factory
