﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 *  @file
 *  @brief   Bluetooth の生産時設定に関する API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

namespace nn { namespace settings { namespace factory {

/**
 * @brief       BD アドレスを表す構造体です。
 */
struct BdAddress
{
    Bit8 octets[6];  //!< BD アドレスを構成するオクテット（降順）
};

/**
 * @brief       Bluetooth に対して設定された BD アドレスを取得します。
 *
 * @details     生産時に Bluetooth に対して設定された BD アドレスを取得します。
 *
 * @param[out]  pOutValue                       BD アドレスを読み出すバッファ
 *
 * @retresult
 * @handleresult{nn::settings::factory::ResultCalibrationDataFileSystemCorrupted}
 * @handleresult{nn::settings::factory::ResultCalibrationDataCrcError}
 * @endretresult
 *
 * @pre
 *              - pOutValue != nullptr
 */
::nn::Result GetBluetoothBdAddress(BdAddress* pOutValue) NN_NOEXCEPT;

}}} // nn::settings::factory
