﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   SASBUS ドライバライブラリのサスペンド・レジューム機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace sasbus {
namespace driver {

//! @name サスペンド・レジューム
//! @{

/**
 * @brief   全セッションをサスペンドします。
 *
 * @pre
 *  ライブラリは初期化済の状態である必要があります。
 *
 * @post
 *  全セッションがサスペンド状態になります。
 *
 * @details
 *  全セッションをサスペンドします。@n
 *  サスペンド後もセッションのオープン状態は維持されますが、ハードウェアは省電力状態に移行し、機能が利用できない状態になります。@n
 *  また、サスペンド状態中は新たなセッションのオープンやオープン済チャンネルのクローズはできません。@n
 *  すでにサスペンド状態で本関数を呼び出した場合、何もしません。
 */
void Suspend() NN_NOEXCEPT;

/**
 * @brief   全セッションをレジュームします。
 *
 * @pre
 *  ライブラリは初期化済の状態である必要があります。
 *
 * @post
 *  全セッションがサスペンド前の状態になります。
 *
 * @details
 *  全セッションをレジュームし、サスペンド前の状態に戻します。@n
 *  サスペンド前の状態で本関数を呼び出した場合、何もしません。
 */
void Resume() NN_NOEXCEPT;

//! @}

} // dirver
} // sasbus
} // nn


