﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/lmem/lmem_ExpHeap.h>

#include <nn/pwm/pwm_IManager.sfdl.h>
#include <nn/pwm/pwm_IChannelSession.sfdl.h>
#include <nn/sf/impl/sf_ExpHeapAllocator.h>

namespace nn { namespace pwm { namespace server {

// IManager 実装クラス
class ManagerImpl
    : public nn::sf::ISharedObject
{

public:

    ManagerImpl() NN_NOEXCEPT;
    ~ManagerImpl() NN_NOEXCEPT;
    nn::Result OpenSessionForDev(nn::sf::Out<nn::sf::SharedPointer<nn::pwm::IChannelSession>> outSession, std::int32_t channel) NN_NOEXCEPT;
    nn::Result OpenSession(nn::sf::Out<nn::sf::SharedPointer<nn::pwm::IChannelSession>> outSession, std::int32_t channel) NN_NOEXCEPT;

private:

    // OpenSession / OpenSessionForDev 用アロケータとして、
    // stateful な nn::sf::ExpHeapAllocator を使用する。
    typedef nn::sf::ExpHeapAllocator MyAllocator;
    MyAllocator m_Allocator;
    std::aligned_storage<4 * 1024>::type m_HeapBuffer;

    nn::lmem::HeapHandle m_HeapHandle;
};

}}}
