﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   PWM ライブラリの開発用途限定のチャンネルアクセス機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

#include "pwm_Channel.h"

namespace nn {
namespace pwm {

//! @name チャンネルの初期化と終了
//! @{

/**
 * @brief 開発目的で使用するための特定のチャンネルを直接指定して、チャンネルをオープンします。
 *
 * @param[out]  pOutSession    オープンされたチャンネルセッション
 * @param[in]   channelIndex   チャンネル番号
 *
 * @details
 *  本 API は開発用途限定の API となります。
 *  製品で使用する場合は @ref nn::pwm::OpenSession() を使用してください。@n
 *  チャンネルの指定が識別子でなくチャンネル番号である以外の動作は @ref nn::pwm::OpenSession() と同様です。
 *
 * @see
 *  nn::pwm::OpenSession()
 */
void OpenSessionForDev(ChannelSession* pOutSession, int channelIndex) NN_NOEXCEPT;

//! @}
// ~チャンネルの初期化と終了

} // pwm
} // nn


