﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief PSM ライブラリのエラーレポートのコンテキスト取得用 API 宣言。
 */

#pragma once

#include <nn/os.h>
#include <nn/psm/psm_ErrorReportTypes.h>

namespace nn { namespace psm {

/**
 * @brief      エラーレポートのコンテキストの更新を伝えるシステムイベントを取得します。
 * @param[out] pOutSystemEventPointer エラーレポートのコンテキスト更新を伝えるシステムイベントへのポインタ。
 * @param[in]  eventClearMode システムイベントのクリア方法。
 * @pre
 *  - PSM ドライバが初期化済みの状態である
 * @details    エラーレポートのコンテキストの更新を伝えるシステムイベントを取得します。
 */
void GetBatteryChargeInfoEvent(nn::os::SystemEventType* pOutSystemEvent, nn::os::EventClearMode eventClearMode) NN_NOEXCEPT;

/**
 * @brief      エラーレポートのコンテキストを取得します。
 * @param[out] pOutFields エラーレポートのコンテキストへのポインタ。
 * @pre
 *  - PSM ドライバが初期化済みの状態である
 * @details    エラーレポートのコンテキストを取得します。
 */
void GetBatteryChargeInfoFields(BatteryChargeInfoFields* pOutFields) NN_NOEXCEPT;

/**
 * @brief      電池の残量ずれを検出して補正を行ったことを伝えるシステムイベントを取得します。
 * @param[out] pOutSystemEventPointer 電池の残量ずれを検出して補正を行ったことを伝えるシステムイベントへのポインタ。
 * @param[in]  eventClearMode システムイベントのクリア方法。
 * @pre
 *  - PSM ドライバが初期化済みの状態である
 * @details    電池の残量ずれを検出して補正を行ったことを伝えるシステムイベントを取得します。
 */
void GetBatteryChargeCalibratedEvent(nn::os::SystemEventType* pOutSystemEvent, nn::os::EventClearMode eventClearMode) NN_NOEXCEPT;

}} // namespace nn::psm
