﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief psm ドライバの生産工程用の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

#include <nn/psm/psm_ManufactureTypes.h>

namespace nn { namespace psm { namespace driver {

/**
 * @brief      給電経路制御機能を有効にします。
 * @pre
 *  - psm ドライバが初期化済の状態である
 * @details    psm ドライバの給電経路制御機能を有効にします。@n
 *             この機能は psm ドライバの生産工程用ビルドでのみ使用可能です。
 */
void EnableSupplyRouteControl() NN_NOEXCEPT;

/**
 * @brief      給電経路制御機能を無効にします。
 * @pre
 *  - psm ドライバが初期化済の状態である
 * @details    psm ドライバの給電経路制御機能を無効にします。@n
 *             この機能は psm ドライバの生産工程用ビルドでのみ使用可能です。
 */
void DisableSupplyRouteControl() NN_NOEXCEPT;

/**
 * @brief      給電経路を設定します。
 * @pre
 *  - psm ドライバが初期化済の状態である
 * @details    psm ドライバの給電経路を設定します。
 *             この機能は psm ドライバの生産工程用ビルドでのみ使用可能です。@n
 *             設定した給電経路が意図せず切り替わることを避けるために、
 *             この機能を使用する前に @ref nn::psm::driver::DisableSupplyRouteControl を使用して
 *             psm ドライバの給電経路制御機能を無効にすることを推奨します。@n
 *             この機能を使用した後は @ref nn::psm::driver::EnableSupplyRouteControl を使用して
 *             psm ドライバの給電経路制御機能を有効に戻すことを推奨します。
 */
void SetSupplyRoute(SupplyRoute supplyRoute) NN_NOEXCEPT;

}}} // namespace nn::psm::driver
