﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief PSM ドライバの定数宣言。
 */

#pragma once

namespace nn { namespace psm { namespace driver { namespace detail {

// 充電を禁止する低温閾値
const auto BatteryTemperatureCelsiusThresholdTooLow  = 4;
// 充電電流を制限する低温閾値
const auto BatteryTemperatureCelsiusThresholdLow     = 17;
// 充電電圧を制限する高温閾値
const auto BatteryTemperatureCelsiusThresholdHigh    = 51;
// 充電を禁止する高温閾値
const auto BatteryTemperatureCelsiusThresholdTooHigh = 60;

// アウェイク時に高速充電時かつ電池電圧十分時の最大充電電流
const auto FastChargeCurrentLimitMilliAmpereAwakeStateDefault = 2048;
// アウェイク時に非高速充電時または電池電圧不足時の最大充電電流
const auto FastChargeCurrentLimitMilliAmpereAwakeStateLow     = 512;
// スリープ時の最大充電電流
const auto FastChargeCurrentLimitMilliAmpereSleepState        = 2048;
// シャットダウン時の最大充電電流
const auto FastChargeCurrentLimitMilliAmpereShutdownState     = 2048;
// 低温時の最大充電電流
const auto FastChargeCurrentLimitMilliAmpereLowTemperature    = 768;

// 通常時の充電電圧
const auto ChargeVoltageLimitMilliVoltDefault         = 4208;
// 高温時の充電電圧
const auto ChargeVoltageLimitMilliVoltHighTemperature = 3952;

// 高速な充電を許可する電池電圧
const auto DisallowFastSpeedChargeThresholdMilliVoltage = 3320;
// 高温時に充電を許可する電池電圧
const auto AllowChargeOnHighTemperatureThresholdMilliVoltage = 4050;

}}}} // namespace nn::psm::driver::detail
