﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      psm モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_PSM_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(psm, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_PSM_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psm, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_PSM_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psm, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_PSM_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psm, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_PSM_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(psm, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_PSM_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(psm, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_PSM_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(psm, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_PSM_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(psm, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_PSM_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(psm, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_PSM_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(psm, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_PSM_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(psm, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_PSM_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(psm, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_PSM_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(psm, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_PSM_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psm, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_PSM_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psm, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_PSM_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psm, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_PSM_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(psm, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_PSM_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psm, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_PSM_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psm, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_PSM_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psm, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_PSM_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Trace, 0, format, args)
#define NN_DETAIL_PSM_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Trace, 1, format, args)
#define NN_DETAIL_PSM_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Trace, 2, format, args)
#define NN_DETAIL_PSM_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Trace, 3, format, args)

#define NN_DETAIL_PSM_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Info, 0, format, args)
#define NN_DETAIL_PSM_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Info, 1, format, args)
#define NN_DETAIL_PSM_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Info, 2, format, args)
#define NN_DETAIL_PSM_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Info, 3, format, args)

#define NN_DETAIL_PSM_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Warn, 0, format, args)
#define NN_DETAIL_PSM_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Warn, 1, format, args)
#define NN_DETAIL_PSM_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Warn, 2, format, args)
#define NN_DETAIL_PSM_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Warn, 3, format, args)

#define NN_DETAIL_PSM_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Error, 0, format, args)
#define NN_DETAIL_PSM_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Error, 1, format, args)
#define NN_DETAIL_PSM_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Error, 2, format, args)
#define NN_DETAIL_PSM_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Error, 3, format, args)

#define NN_DETAIL_PSM_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Fatal, 0, format, args)
#define NN_DETAIL_PSM_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Fatal, 1, format, args)
#define NN_DETAIL_PSM_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Fatal, 2, format, args)
#define NN_DETAIL_PSM_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psm, Fatal, 3, format, args)

#define NN_DETAIL_PSM_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(psm, Trace, 0, text, length)
#define NN_DETAIL_PSM_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psm, Trace, 1, text, length)
#define NN_DETAIL_PSM_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psm, Trace, 2, text, length)
#define NN_DETAIL_PSM_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psm, Trace, 3, text, length)

#define NN_DETAIL_PSM_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(psm, Info, 0, text, length)
#define NN_DETAIL_PSM_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(psm, Info, 1, text, length)
#define NN_DETAIL_PSM_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(psm, Info, 2, text, length)
#define NN_DETAIL_PSM_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(psm, Info, 3, text, length)

#define NN_DETAIL_PSM_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(psm, Warn, 0, text, length)
#define NN_DETAIL_PSM_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(psm, Warn, 1, text, length)
#define NN_DETAIL_PSM_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(psm, Warn, 2, text, length)
#define NN_DETAIL_PSM_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(psm, Warn, 3, text, length)

#define NN_DETAIL_PSM_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(psm, Error, 0, text, length)
#define NN_DETAIL_PSM_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psm, Error, 1, text, length)
#define NN_DETAIL_PSM_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psm, Error, 2, text, length)
#define NN_DETAIL_PSM_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psm, Error, 3, text, length)

#define NN_DETAIL_PSM_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(psm, Fatal, 0, text, length)
#define NN_DETAIL_PSM_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psm, Fatal, 1, text, length)
#define NN_DETAIL_PSM_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psm, Fatal, 2, text, length)
#define NN_DETAIL_PSM_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psm, Fatal, 3, text, length)

#define NN_DETAIL_PSM_WARN_UNLESS_RESULT_SUCCESS(expression) \
    do \
    { \
        auto result = (expression); \
        if ( result.IsFailure() ) \
        { \
            NN_DETAIL_PSM_WARN("Failed: %s\n  Module: %d\n  Description: %d\n  InnerValue: 0x%08x\n", \
                NN_MACRO_STRINGIZE(expression), result.GetModule(), result.GetDescription(), result.GetInnerValueForDebug()); \
        } \
    } while ( NN_STATIC_CONDITION(false) )

#define NN_DETAIL_PSM_ERROR_UNLESS_RESULT_SUCCESS(expression) \
    do \
    { \
        auto result = (expression); \
        if ( result.IsFailure() ) \
        { \
            NN_DETAIL_PSM_ERROR("Failed: %s\n  Module: %d\n  Description: %d\n  InnerValue: 0x%08x\n", \
                NN_MACRO_STRINGIZE(expression), result.GetModule(), result.GetDescription(), result.GetInnerValueForDebug()); \
        } \
    } while ( NN_STATIC_CONDITION(false) )
