﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/psc/psc_PmControlTypes.h>
#include <nn/psc/psc_PmModuleId.h>
#include <nn/psc/psc_Types.h>
#include <nn/psc/util/psc_Util.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace psc { namespace sf { // NOLINT(whitespace/braces)

class IPmControl;

class IPmModule;

class IPmService;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IPmControl, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IPmControl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::sf::Out<::nn::sf::NativeHandle> handleOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DispatchRequest, (::nn::psc::PmState state, ::nn::psc::PmFlagSet flags, ::nn::psc::PmTransitionOrder order))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::nn::psc::PmControlState> state))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(PrintModuleInformation)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetModuleInformation, (::nn::sf::Out<::nn::psc::util::TransitionInformation> transitionInfo, ::nn::sf::Out<::std::int32_t> moduleCount, const ::nn::sf::OutBuffer& moduleInfo, ::nn::sf::Out<::std::int32_t> dependencyCount, const ::nn::sf::OutBuffer& dependencyInfo))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IPmControl)

        ::nn::Result Initialize(::nn::sf::Out<::nn::sf::NativeHandle> handleOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Initialize, (handleOut));
        }

        ::nn::Result DispatchRequest(::nn::psc::PmState state, ::nn::psc::PmFlagSet flags, ::nn::psc::PmTransitionOrder order) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DispatchRequest, (state, flags, order));
        }

        ::nn::Result GetResult() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(GetResult);
        }

        ::nn::Result GetState(::nn::sf::Out<::nn::psc::PmControlState> state) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetState, (state));
        }

        ::nn::Result Cancel() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Cancel);
        }

        ::nn::Result PrintModuleInformation() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(PrintModuleInformation);
        }

        ::nn::Result GetModuleInformation(::nn::sf::Out<::nn::psc::util::TransitionInformation> transitionInfo, ::nn::sf::Out<::std::int32_t> moduleCount, const ::nn::sf::OutBuffer& moduleInfo, ::nn::sf::Out<::std::int32_t> dependencyCount, const ::nn::sf::OutBuffer& dependencyInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetModuleInformation, (transitionInfo, moduleCount, moduleInfo, dependencyCount, dependencyInfo));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IPmControl
    {
    public:
        nn::Result Initialize(nn::sf::Out<nn::sf::NativeHandle> handleOut) NN_NOEXCEPT;
        nn::Result DispatchRequest(nn::psc::PmState state, nn::psc::PmFlagSet flags, nn::psc::PmTransitionOrder order) NN_NOEXCEPT;
        nn::Result GetResult() NN_NOEXCEPT;
        nn::Result GetState(nn::sf::Out<nn::psc::PmControlState> state) NN_NOEXCEPT;
        nn::Result Cancel() NN_NOEXCEPT;
        nn::Result PrintModuleInformation() NN_NOEXCEPT;
        nn::Result GetModuleInformation(nn::sf::Out<nn::psc::util::TransitionInformation> transitionInfo, nn::sf::Out<std::int32_t> moduleCount, const nn::sf::OutBuffer& moduleInfo, nn::sf::Out<std::int32_t> dependencyCount, const nn::sf::OutBuffer& dependencyInfo) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result Initialize(nn::sf::Out<nn::sf::NativeHandle> handleOut) NN_NOEXCEPT;
    nn::Result DispatchRequest(nn::psc::PmState state, nn::psc::PmFlagSet flags, nn::psc::PmTransitionOrder order) NN_NOEXCEPT;
    nn::Result GetResult() NN_NOEXCEPT;
    nn::Result GetState(nn::sf::Out<nn::psc::PmControlState> state) NN_NOEXCEPT;
    nn::Result Cancel() NN_NOEXCEPT;
    nn::Result PrintModuleInformation() NN_NOEXCEPT;
    nn::Result GetModuleInformation(nn::sf::Out<nn::psc::util::TransitionInformation> transitionInfo, nn::sf::Out<std::int32_t> moduleCount, const nn::sf::OutBuffer& moduleInfo, nn::sf::Out<std::int32_t> dependencyCount, const nn::sf::OutBuffer& dependencyInfo) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::psc::sf::IPmControl))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::sf::Out<::nn::sf::NativeHandle> handleOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Initialize, (handleOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DispatchRequest, (::nn::psc::PmState state, ::nn::psc::PmFlagSet flags, ::nn::psc::PmTransitionOrder order))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DispatchRequest, (state, flags, order));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(GetResult);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::nn::psc::PmControlState> state))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetState, (state));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Cancel);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(PrintModuleInformation)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(PrintModuleInformation);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetModuleInformation, (::nn::sf::Out<::nn::psc::util::TransitionInformation> transitionInfo, ::nn::sf::Out<::std::int32_t> moduleCount, const ::nn::sf::OutBuffer& moduleInfo, ::nn::sf::Out<::std::int32_t> dependencyCount, const ::nn::sf::OutBuffer& dependencyInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetModuleInformation, (transitionInfo, moduleCount, moduleInfo, dependencyCount, dependencyInfo));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::psc::sf::IPmControl>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::psc::sf::IPmControl))

    // nn::Result Initialize(nn::sf::Out<nn::sf::NativeHandle> handleOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Initialize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handleOut, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handleOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handleOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Initialize)

    // nn::Result DispatchRequest(nn::psc::PmState state, nn::psc::PmFlagSet flags, nn::psc::PmTransitionOrder order) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DispatchRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(state, (::nn::psc::PmState), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::nn::psc::PmFlagSet), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(order, (::nn::psc::PmTransitionOrder), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (state, flags, order))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(state), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(order)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DispatchRequest)

    // nn::Result GetResult() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetResult)

    // nn::Result GetState(nn::sf::Out<nn::psc::PmControlState> state) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(state, (::nn::psc::PmControlState), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (state))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(state)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetState)

    // nn::Result Cancel() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Cancel)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Cancel)

    // nn::Result PrintModuleInformation() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PrintModuleInformation)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PrintModuleInformation)

    // nn::Result GetModuleInformation(nn::sf::Out<nn::psc::util::TransitionInformation> transitionInfo, nn::sf::Out<std::int32_t> moduleCount, const nn::sf::OutBuffer& moduleInfo, nn::sf::Out<std::int32_t> dependencyCount, const nn::sf::OutBuffer& dependencyInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetModuleInformation)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(moduleInfo, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(dependencyInfo, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (moduleInfo, dependencyInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(moduleCount, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(dependencyCount, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(transitionInfo, (::nn::psc::util::TransitionInformation), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (moduleCount, dependencyCount, transitionInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transitionInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(moduleCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(moduleInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dependencyCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dependencyInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetModuleInformation)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::psc::PmState), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::psc::PmFlagSet), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::psc::PmTransitionOrder), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::psc::PmControlState), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::psc::util::TransitionInformation), 32, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::psc::sf::IPmControl, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::psc::sf::IPmControl))

    // nn::Result Initialize(nn::sf::Out<nn::sf::NativeHandle> handleOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::sf::Out<::nn::sf::NativeHandle> handleOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Initialize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handleOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Initialize)
    }

    // nn::Result DispatchRequest(nn::psc::PmState state, nn::psc::PmFlagSet flags, nn::psc::PmTransitionOrder order) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DispatchRequest, (::nn::psc::PmState state, ::nn::psc::PmFlagSet flags, ::nn::psc::PmTransitionOrder order))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DispatchRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(state)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(order)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DispatchRequest)
    }

    // nn::Result GetResult() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetResult)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetResult)
    }

    // nn::Result GetState(nn::sf::Out<nn::psc::PmControlState> state) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::nn::psc::PmControlState> state))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(state)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetState)
    }

    // nn::Result Cancel() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Cancel)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Cancel)
    }

    // nn::Result PrintModuleInformation() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(PrintModuleInformation)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PrintModuleInformation)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PrintModuleInformation)
    }

    // nn::Result GetModuleInformation(nn::sf::Out<nn::psc::util::TransitionInformation> transitionInfo, nn::sf::Out<std::int32_t> moduleCount, const nn::sf::OutBuffer& moduleInfo, nn::sf::Out<std::int32_t> dependencyCount, const nn::sf::OutBuffer& dependencyInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetModuleInformation, (::nn::sf::Out<::nn::psc::util::TransitionInformation> transitionInfo, ::nn::sf::Out<::std::int32_t> moduleCount, const ::nn::sf::OutBuffer& moduleInfo, ::nn::sf::Out<::std::int32_t> dependencyCount, const ::nn::sf::OutBuffer& dependencyInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetModuleInformation)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transitionInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(moduleCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(moduleInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dependencyCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dependencyInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetModuleInformation)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::psc::sf::IPmControl>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::psc::sf::IPmControl))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handleOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Initialize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handleOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DispatchRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DispatchRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(state),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(order)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(state)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PrintModuleInformation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PrintModuleInformation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetModuleInformation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(moduleInfo)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(dependencyInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetModuleInformation)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(transitionInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(moduleCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(moduleInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(dependencyCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(dependencyInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DispatchRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PrintModuleInformation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetModuleInformation)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::psc::sf::IPmControl))

namespace nn { namespace psc { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IPmModule, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IPmModule)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::sf::Out<::nn::sf::NativeHandle> handleOut, ::nn::psc::PmModuleId moduleId, const ::nn::sf::InBuffer& childListForSf))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRequest, (::nn::sf::Out<::nn::psc::PmState> state, ::nn::sf::Out<::nn::psc::PmFlagSet> flags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Acknowledge)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AcknowledgeEx, (::nn::psc::PmState state))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IPmModule)

        ::nn::Result Initialize(::nn::sf::Out<::nn::sf::NativeHandle> handleOut, ::nn::psc::PmModuleId moduleId, const ::nn::sf::InBuffer& childListForSf) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Initialize, (handleOut, moduleId, childListForSf));
        }

        ::nn::Result GetRequest(::nn::sf::Out<::nn::psc::PmState> state, ::nn::sf::Out<::nn::psc::PmFlagSet> flags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRequest, (state, flags));
        }

        ::nn::Result Acknowledge() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Acknowledge);
        }

        ::nn::Result Finalize() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Finalize);
        }

        ::nn::Result AcknowledgeEx(::nn::psc::PmState state) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AcknowledgeEx, (state));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IPmModule
    {
    public:
        nn::Result Initialize(nn::sf::Out<nn::sf::NativeHandle> handleOut, nn::psc::PmModuleId moduleId, const nn::sf::InBuffer& childListForSf) NN_NOEXCEPT;
        nn::Result GetRequest(nn::sf::Out<nn::psc::PmState> state, nn::sf::Out<nn::psc::PmFlagSet> flags) NN_NOEXCEPT;
        nn::Result Acknowledge() NN_NOEXCEPT;
        nn::Result Finalize() NN_NOEXCEPT;
        nn::Result AcknowledgeEx(nn::psc::PmState state) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result Initialize(nn::sf::Out<nn::sf::NativeHandle> handleOut, nn::psc::PmModuleId moduleId, const nn::sf::InBuffer& childListForSf) NN_NOEXCEPT;
    nn::Result GetRequest(nn::sf::Out<nn::psc::PmState> state, nn::sf::Out<nn::psc::PmFlagSet> flags) NN_NOEXCEPT;
    nn::Result Acknowledge() NN_NOEXCEPT;
    nn::Result Finalize() NN_NOEXCEPT;
    nn::Result AcknowledgeEx(nn::psc::PmState state) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::psc::sf::IPmModule))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::sf::Out<::nn::sf::NativeHandle> handleOut, ::nn::psc::PmModuleId moduleId, const ::nn::sf::InBuffer& childListForSf))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Initialize, (handleOut, moduleId, childListForSf));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequest, (::nn::sf::Out<::nn::psc::PmState> state, ::nn::sf::Out<::nn::psc::PmFlagSet> flags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRequest, (state, flags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Acknowledge)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Acknowledge);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Finalize);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcknowledgeEx, (::nn::psc::PmState state))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AcknowledgeEx, (state));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::psc::sf::IPmModule>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::psc::sf::IPmModule))

    // nn::Result Initialize(nn::sf::Out<nn::sf::NativeHandle> handleOut, nn::psc::PmModuleId moduleId, const nn::sf::InBuffer& childListForSf) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Initialize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(childListForSf, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (childListForSf))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handleOut, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handleOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(moduleId, (::nn::psc::PmModuleId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (moduleId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handleOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(moduleId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(childListForSf)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Initialize)

    // nn::Result GetRequest(nn::sf::Out<nn::psc::PmState> state, nn::sf::Out<nn::psc::PmFlagSet> flags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(state, (::nn::psc::PmState), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(flags, (::nn::psc::PmFlagSet), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (state, flags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(state), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRequest)

    // nn::Result Acknowledge() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Acknowledge)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Acknowledge)

    // nn::Result Finalize() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Finalize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Finalize)

    // nn::Result AcknowledgeEx(nn::psc::PmState state) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcknowledgeEx)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(state, (::nn::psc::PmState), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (state))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(state)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcknowledgeEx)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::psc::PmModuleId), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::psc::PmState), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::psc::PmFlagSet), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::psc::sf::IPmModule, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::psc::sf::IPmModule))

    // nn::Result Initialize(nn::sf::Out<nn::sf::NativeHandle> handleOut, nn::psc::PmModuleId moduleId, const nn::sf::InBuffer& childListForSf) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::sf::Out<::nn::sf::NativeHandle> handleOut, ::nn::psc::PmModuleId moduleId, const ::nn::sf::InBuffer& childListForSf))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Initialize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handleOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(moduleId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(childListForSf)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Initialize)
    }

    // nn::Result GetRequest(nn::sf::Out<nn::psc::PmState> state, nn::sf::Out<nn::psc::PmFlagSet> flags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequest, (::nn::sf::Out<::nn::psc::PmState> state, ::nn::sf::Out<::nn::psc::PmFlagSet> flags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(state)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRequest)
    }

    // nn::Result Acknowledge() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Acknowledge)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Acknowledge)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Acknowledge)
    }

    // nn::Result Finalize() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Finalize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Finalize)
    }

    // nn::Result AcknowledgeEx(nn::psc::PmState state) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcknowledgeEx, (::nn::psc::PmState state))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcknowledgeEx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(state)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcknowledgeEx)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::psc::sf::IPmModule>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::psc::sf::IPmModule))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(childListForSf)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handleOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Initialize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handleOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(moduleId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(childListForSf)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(state),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(flags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Acknowledge)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Acknowledge)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcknowledgeEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcknowledgeEx)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(state)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Acknowledge)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcknowledgeEx)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::psc::sf::IPmModule))

namespace nn { namespace psc { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IPmService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IPmService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::psc::sf::IPmModule>> pModuleOut))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IPmService)

        ::nn::Result Initialize(::nn::sf::Out<::nn::sf::SharedPointer<::nn::psc::sf::IPmModule>> pModuleOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Initialize, (pModuleOut));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IPmService
    {
    public:
        nn::Result Initialize(nn::sf::Out<nn::sf::SharedPointer<nn::psc::sf::IPmModule>> pModuleOut) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result Initialize(nn::sf::Out<nn::sf::SharedPointer<nn::psc::sf::IPmModule>> pModuleOut) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::psc::sf::IPmService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::psc::sf::IPmModule>> pModuleOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Initialize, (pModuleOut));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::psc::sf::IPmService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::psc::sf::IPmService))

    // nn::Result Initialize(nn::sf::Out<nn::sf::SharedPointer<nn::psc::sf::IPmModule>> pModuleOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Initialize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pModuleOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pModuleOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pModuleOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Initialize)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::psc::sf::IPmService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::psc::sf::IPmService))

    // nn::Result Initialize(nn::sf::Out<nn::sf::SharedPointer<nn::psc::sf::IPmModule>> pModuleOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::psc::sf::IPmModule>> pModuleOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Initialize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pModuleOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Initialize)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::psc::sf::IPmService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::psc::sf::IPmService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::psc::sf::IPmModule>), pModuleOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Initialize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pModuleOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pModuleOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Initialize)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::psc::sf::IPmService))
