﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/prepo/prepo_Types.h>
#include <nn/prepo/prepo_TypesCategory.h>

namespace nn { namespace prepo {

/*!
    @name   デバッグ
    @{
*/

/*!
    @brief      統計情報です。
*/
struct Statistics
{
    struct Record
    {
        int64_t size;
        int64_t count;
    };

    struct RecordGroup
    {
        Record uploaded;                //!< アップロードした通常のレポートの合計サイズと個数。
        Record lostByBufferShortage;    //!< バッファの空きが足りずに失われた通常のレポートの合計サイズと個数。
        Record lostByStorageShortage;   //!< ストレージの空きが足りずに失われた通常のレポートの合計サイズと個数。
        Record lostByDisagree;          //!< ユーザー同意がないため失われたレポートの合計サイズと個数。
    };

    RecordGroup groups[ReportCategory_Count];

    Bit8 reserved[128];
};

/*!
    @brief      1 分あたりの Save API の呼び出し回数です。
*/
struct ThroughputRecord
{
    uint16_t app;   //<! 1 分あたりのアプリの Save API の呼び出し回数
    uint16_t sys;   //<! 1 分あたりのシステムの Save API の呼び出し回数
};

/*!
    @}
*/

}}
