﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/prepo/prepo_Types.h>

namespace nn { namespace prepo {

/*!
    @name   設定
    @{
*/

/*!
    @brief      レポートデータの保存および送信時に、ユーザー同意フラグをチェックするかどうかを取得します。

    @param[out] outIsEnabled    チェックするかどうか。

    @return     処理結果。

    @pre
                - outIsEnabled != nullptr

    @details
                既定でチェックは有効です。@n
                チェックを無効化することで、ユーザー同意の有無に関わらず、常にレポートデータが保存および送信されます。
*/
nn::Result IsUserAgreementCheckEnabled(bool* outIsEnabled) NN_NOEXCEPT;

/*!
    @brief      レポートデータの保存および送信時に、ユーザー同意フラグをチェックするかどうかを設定します。

    @param[in]  isEnabled       チェックするかどうか。

    @return     処理結果。

    @details
                既定でチェックは有効です。@n
                チェックを無効化することで、ユーザー同意の有無に関わらず、常にレポートデータが保存および送信されます。
*/
nn::Result SetUserAgreementCheckEnabled(bool isEnabled) NN_NOEXCEPT;

/*!
    @}
*/

}}
