﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/prepo/detail/ipc/prepo_IPrepoService.sfdl.h>
#include <nn/prepo/detail/ipc/prepo_ServiceConfig.h>
#include <nn/prepo/detail/service/prepo_Capability.h>

namespace nn { namespace prepo { namespace detail { namespace service {

/*!
    @brief      プレイレポートサービスです。
*/
class PrepoService
{
public:
    /*!
        @brief      コンストラクタです。

        @param[in]  serviceName サービス名。
        @param[in]  capability  ケイパビリティ。
    */
    PrepoService(const char* serviceName, const Capability& capability) NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~PrepoService() NN_NOEXCEPT;

public:
    // IPrepoService
    nn::Result SaveReport(const nn::sf::InArray<char>& eventId, const nn::sf::InBuffer& data, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result SaveReportWithUser(const nn::account::Uid& uid, const nn::sf::InArray<char>& eventId, const nn::sf::InBuffer& data, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result RequestImmediateTransmission() NN_NOEXCEPT;
    nn::Result GetTransmissionStatus(nn::sf::Out<std::int32_t> outStatus) NN_NOEXCEPT;
    nn::Result SaveSystemReport(const nn::sf::InArray<char>& eventId, nn::ApplicationId appId, const nn::sf::InBuffer& data) NN_NOEXCEPT;
    nn::Result SaveSystemReportWithUser(const nn::account::Uid& uid, const nn::sf::InArray<char>& eventId, nn::ApplicationId appId, const nn::sf::InBuffer& data) NN_NOEXCEPT;
    nn::Result SetOperationMode(std::int64_t mode) NN_NOEXCEPT;
    nn::Result ClearStorage() NN_NOEXCEPT;
    nn::Result ClearStatistics() NN_NOEXCEPT;
    nn::Result IsUserAgreementCheckEnabled(nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT;
    nn::Result SetUserAgreementCheckEnabled(bool isEnabled) NN_NOEXCEPT;
    nn::Result GetStorageUsage(nn::sf::Out<std::int64_t> outUsed, nn::sf::Out<std::int64_t> outCapacity) NN_NOEXCEPT;
    nn::Result GetStatistics(nn::sf::Out<nn::prepo::Statistics> outStatistics) NN_NOEXCEPT;
    nn::Result GetThroughputHistory(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<ThroughputRecord>& outArray) NN_NOEXCEPT;
    nn::Result GetLastUploadError() NN_NOEXCEPT;

private:
    //
    const char* m_ServiceName;
    //
    Capability m_Capability;

private:
    //
    nn::Result GetApplicationId(nn::ApplicationId* out, nn::Bit64 processId) NN_NOEXCEPT;
    //
    void OutputSaveLog(nn::ApplicationId appId, const char* eventId) NN_NOEXCEPT;
};

}}}}
