﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/prepo/detail/ipc/prepo_IpcService.h>
#include <nn/os.h>
#include <nn/os/os_SdkMutex.h>

namespace nn { namespace prepo { namespace detail {

/*!
    @brief      シムライブラリのグローバルインスタンスです。

    @details
                シムライブラリのファイル間共通データを管理します。
*/
class ShimLibraryGlobal
{
private:
    /*!
        @brief      コンストラクタです。
    */
    ShimLibraryGlobal() NN_NOEXCEPT;

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static ShimLibraryGlobal& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(ShimLibraryGlobal, s_Instance);
        return s_Instance;
    }

public:
    /*!
        @brief      インスタンスを初期化します。
    */
    void Initialize() NN_NOEXCEPT;

    /*!
        @brief      API 呼び出し用のセッションを取得します。

        @return     セッション。
    */
    detail::ipc::IPrepoService* GetSession() NN_NOEXCEPT;

private:
    //
    nn::os::SdkMutex m_Mutex;
    //
    detail::ipc::IPrepoService* m_Session;

private:
    //
    void GetIpcSession() NN_NOEXCEPT;
};

}}}
