﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/prepo/detail/ipc/prepo_IPrepoService.sfdl.h>

namespace nn { namespace prepo { namespace detail { namespace ipc {

/*!
    @brief      IPC サービスの初期化を行います。
*/
void Initialize() NN_NOEXCEPT;

/*!
    @brief      IPC サービスの終了処理を行います。
*/
void Finalize() NN_NOEXCEPT;

/*!
    @brief      PrepoService を取得します。

    @return     PrepoService。
*/
IPrepoService* GetPrepoService() NN_NOEXCEPT;

}}}}
