﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/*!
    @namespace  nn::prepo

    @brief      プレイレポートライブラリの名前空間です。

    @details
                プレイレポートは、「イベント」単位で任意のレポートデータ（キーバリュー形式）をシステムに保存する機能を提供します。@n
                例えば、アクションゲームでヒートマップを作成したい場合、以下のようにしてレポートデータを作成します。

                @code
                // 敵に倒されたイベントを記録します
                nn::prepo::PlayReport report("killed_event");
                report.SetBuffer(buffer, sizeof (buffer));
                report.Add("map", map.id);
                report.Add("position:x", me.position.x);
                report.Add("position:y", me.position.y);
                report.Add("position:z", me.position.z);
                report.Add("enemy:id", enemy.id);
                report.Add("enemy:position:x", enemy.position.x);
                report.Add("enemy:position:y", enemy.position.y);
                report.Add("enemy:position:z", enemy.position.z);
                report.Save();
                @endcode

                @code
                // 落下イベントを記録します
                nn::prepo::PlayReport report("fallen_event");
                report.SetBuffer(buffer, sizeof (buffer));
                report.Add("map", map.id);
                report.Add("position:x", me.position.x);
                report.Add("position:y", me.position.y);
                report.Add("position:z", me.position.z);
                report.Save();
                @endcode

                通常、レポートデータはインターネット通信可能なタイミングで自動送信されます。@n
                ただし、P2P 中や動画ストリーミング再生中等、帯域保証が必要な通信が行われている間、自動送信は行われません。

                任意のタイミングでレポートデータを送信したい場合、 @ref RequestImmediateTransmission を使用してください。

                送信が完了したレポートデータは、保存ストレージ上から削除されます。

                インターネット通信ができない環境下でレポートデータが貯まりつづけた場合、保存ストレージの空き容量不足が発生します。@n
                この場合、システムは古いレポートデータを削除して空き容量を確保します。@n
                そのため、保存したレポートデータが必ずサーバーに送信される保証はないことに注意してください。

                1 イベントあたりの、キーバリューの最大保持数は、@ref KeyValueCountMax です。@n
                0 個は許可しません。

                アプリが指定するイベント ID／キー／バリューには、以下の制限があります。

                - イベント ID
                    - 使用可能な文字：[0-9a-z_]
                    - 最大 @ref EventIdLengthMax バイト
                - キー
                    - 使用可能な文字：[0-9a-zA-Z:_]
                    - 最大 @ref KeyLengthMax バイト
                - バリュー
                    - 符号付き 64 ビット整数値
                    - 任意の 64 ビット長の ID
                    - 倍精度浮動小数点数
                    - UTF-8 文字列 (最大 @ref StringValueLengthMax バイト)
*/

#include <nn/prepo/prepo_Api.h>
#include <nn/prepo/prepo_PlayReport.h>
