﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief PCV ドライバライブラリのエラーレポート用 API 宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>

#include "pcv_ErrorReportTypes.h"
#include "pcv_Modules.h"

namespace nn {
namespace pcv {

/**
 * @brief       エラーレポート用のシステムイベントを取得します。
 */
Result GetPowerClockInfoEvent(nn::os::SystemEventType* pOutSystemEvent, nn::os::EventClearMode) NN_NOEXCEPT;

/**
 * @brief       OSC のクロックを取得します。
 */
Result GetOscillatorClock(uint32_t* pClockRateHz) NN_NOEXCEPT;

/**
 * @brief       DVFS テーブルを取得します。
 */
Result GetDvfsTable(uint32_t* pOutClocks, int32_t* pOutVoltages, int32_t* pOutCount, Module moduleId, int32_t maxCount) NN_NOEXCEPT;

/**
 * @brief       モジュールごとの情報を取得します。
 */
Result GetModuleStateTable(ModuleState* pOutModuleStates, int32_t* pOutCount, int32_t maxCount) NN_NOEXCEPT;

/**
 * @brief       電源ドメインごとの情報を取得します。
 */
Result GetPowerDomainStateTable(PowerDomainState* pOutPowerDomainStates, int32_t* pOutCount, int32_t maxCount) NN_NOEXCEPT;

/**
 * @brief       チップ情報を取得します。
 */
Result GetFuseInfo(uint32_t* pOutValues, int32_t* pOutCount, int32_t maxCount) NN_NOEXCEPT;

/**
 * @brief       Dram情報を取得します。
 */
Result GetDramId(uint32_t* pOutDramId) NN_NOEXCEPT;

} // pcv
} // nn
