﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief PCV ドライバライブラリの API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {

namespace pcv {
namespace driver {

/**
 * @brief       Initializes the pcv library.
 *
 * @post        PCV library is initialized.
 *
 * @details     PCV initializes itself and any libraries it depends on.
 *
 */
void Initialize() NN_NOEXCEPT;

/**
 * @brief       Is the PCV library initialized?
 *
 * @post        Returns true if PCV library is initialized
 *
 * @details     Returns true if PCV library is initialized
 *
 */
bool IsInitialized() NN_NOEXCEPT;


/**
 * @brief       Shuts down the the PCV library.
 *
 * @post        The PCV library is shut down.
 *
 * @details     Shuts down PCV and any libraries it depends on.
 *
 */
void Finalize() NN_NOEXCEPT;

} // driver
} // pcv
} // nn
