﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      pcv モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_PCV_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCV_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCV_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCV_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCV_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCV_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCV_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCV_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCV_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCV_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCV_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCV_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCV_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCV_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCV_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCV_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCV_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCV_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCV_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCV_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcv, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCV_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Trace, 0, format, args)
#define NN_DETAIL_PCV_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Trace, 1, format, args)
#define NN_DETAIL_PCV_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Trace, 2, format, args)
#define NN_DETAIL_PCV_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Trace, 3, format, args)

#define NN_DETAIL_PCV_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Info, 0, format, args)
#define NN_DETAIL_PCV_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Info, 1, format, args)
#define NN_DETAIL_PCV_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Info, 2, format, args)
#define NN_DETAIL_PCV_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Info, 3, format, args)

#define NN_DETAIL_PCV_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Warn, 0, format, args)
#define NN_DETAIL_PCV_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Warn, 1, format, args)
#define NN_DETAIL_PCV_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Warn, 2, format, args)
#define NN_DETAIL_PCV_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Warn, 3, format, args)

#define NN_DETAIL_PCV_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Error, 0, format, args)
#define NN_DETAIL_PCV_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Error, 1, format, args)
#define NN_DETAIL_PCV_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Error, 2, format, args)
#define NN_DETAIL_PCV_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Error, 3, format, args)

#define NN_DETAIL_PCV_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Fatal, 0, format, args)
#define NN_DETAIL_PCV_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Fatal, 1, format, args)
#define NN_DETAIL_PCV_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Fatal, 2, format, args)
#define NN_DETAIL_PCV_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcv, Fatal, 3, format, args)

#define NN_DETAIL_PCV_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Trace, 0, text, length)
#define NN_DETAIL_PCV_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Trace, 1, text, length)
#define NN_DETAIL_PCV_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Trace, 2, text, length)
#define NN_DETAIL_PCV_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Trace, 3, text, length)

#define NN_DETAIL_PCV_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Info, 0, text, length)
#define NN_DETAIL_PCV_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Info, 1, text, length)
#define NN_DETAIL_PCV_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Info, 2, text, length)
#define NN_DETAIL_PCV_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Info, 3, text, length)

#define NN_DETAIL_PCV_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Warn, 0, text, length)
#define NN_DETAIL_PCV_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Warn, 1, text, length)
#define NN_DETAIL_PCV_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Warn, 2, text, length)
#define NN_DETAIL_PCV_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Warn, 3, text, length)

#define NN_DETAIL_PCV_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Error, 0, text, length)
#define NN_DETAIL_PCV_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Error, 1, text, length)
#define NN_DETAIL_PCV_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Error, 2, text, length)
#define NN_DETAIL_PCV_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Error, 3, text, length)

#define NN_DETAIL_PCV_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Fatal, 0, text, length)
#define NN_DETAIL_PCV_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Fatal, 1, text, length)
#define NN_DETAIL_PCV_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Fatal, 2, text, length)
#define NN_DETAIL_PCV_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcv, Fatal, 3, text, length)
