﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_StaticAssert.h>

#include <nn/pctl/detail/service/common/pctl_AsyncContext.h>
#include <nn/pctl/detail/service/common/pctl_Cancelable.h>
#include <nn/pctl/detail/service/watcher/pctl_ServerResource.h>
#include <nn/pctl/detail/service/watcher/pctl_WatcherData.h>

#include <nn/account/account_TypesForSystemServices.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

static const int MaxUserCount = 8;
NN_STATIC_ASSERT(MaxUserCount == nn::account::UserCountMax); // 変わった際に対応が必要になることを検知するためのチェック

struct DeviceUserData
{
    struct User
    {
        nn::account::Uid uid;
        nn::account::ProfileDigest digest;
    };

    User users[MaxUserCount];
};
NN_STATIC_ASSERT(std::is_pod<DeviceUserData>::value);

/**
 * @brief サーバーに送信するデバイスごとのユーザー情報の更新処理を行います。
 */
class UpdateDeviceUserExecutor
{
public:
    /**
     * @brief ユーザー情報を更新し、差分をサーバーに送信します。
     */
    static nn::Result UpdateDeviceUsers(common::NetworkBuffer& bufferInfo, common::Cancelable* pCancelable,
        const char* token, ServerDeviceId deviceId) NN_NOEXCEPT;

    /**
     * @brief ユーザー情報データを初期化し、前回チェック時のユーザー情報を読み込みます。
     */
    static void InitializeAndLoadDeviceUserData() NN_NOEXCEPT;
    /**
     * @brief 前回チェック時のユーザー情報をファイルに保存し、次回起動時にその状態からの差分チェックを行えるようにします。
     */
    static void SaveDeviceUserData() NN_NOEXCEPT;
    /**
     * @brief 前回チェック時のユーザー情報を削除してファイルに反映させます。
     */
    static void ClearDeviceUserData() NN_NOEXCEPT;
};

}}}}}
