﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/pctl/detail/service/common/pctl_AsyncContext.h>
#include <nn/pctl/detail/service/common/pctl_Cancelable.h>
#include <nn/pctl/detail/service/watcher/pctl_WatcherData.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

class Authentication
{
private:
    // Authentication のインスタンスは1つのみ
    Authentication() NN_NOEXCEPT {}

public:
    static Authentication& GetInstance() NN_NOEXCEPT
    {
        // データとしてはグローバルに配置する
        static Authentication instance;
        return instance;
    }

    nn::Result RetrieveDeviceAuthenticationToken(common::NetworkBuffer& bufferInfo, common::Cancelable* pCancelable) NN_NOEXCEPT;

private:
    nn::TimeSpan m_Expiration;
    int m_AcquiredTokenSize;
    AuthenticationTokenData m_TokenData;
};

}}}}}
