﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/pctl/detail/ipc/pctl_IParentalControlServiceFactory.sfdl.h>
#include <nn/pctl/detail/ipc/pctl_IpcConfig.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

namespace nn { namespace pctl { namespace detail { namespace service {

/**
 * @brief IParentalControlService インスタンス生成インターフェイス(IParentalControlServiceFactory)の実装
 */
class ParentalControlServiceFactoryImpl
{
public:
    static const size_t SessionSize = 1024;

#if NN_DETAIL_PCTL_CONFIG_SERVER_PROCESS == NN_DETAIL_PCTL_CONFIG_SERVER_PROCESS_HIPC
    /**
     * @brief コンストラクターです。
     * @param[in] capability 利用可能な機能を示す値(@ref ipc::Capability の各値の組み合わせ)
     */
    explicit ParentalControlServiceFactoryImpl(nn::sf::ExpHeapAllocator* allocator, int capability) NN_NOEXCEPT;
#else
    /**
     * @brief コンストラクターです。
     * @details
     * テスト用/単体利用のため capability 指定はありません。
     */
    explicit ParentalControlServiceFactoryImpl(nn::sf::ExpHeapAllocator* allocator) NN_NOEXCEPT;
#endif
    ~ParentalControlServiceFactoryImpl() NN_NOEXCEPT;

    nn::Result CreateService(nn::sf::Out<nn::sf::SharedPointer<nn::pctl::detail::ipc::IParentalControlService>> outService, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result CreateServiceWithoutInitialize(nn::sf::Out<nn::sf::SharedPointer<nn::pctl::detail::ipc::IParentalControlService>> outService, nn::Bit64 processId) NN_NOEXCEPT;

private:
    nn::Result CreateServiceImpl(nn::sf::SharedPointer<nn::pctl::detail::ipc::IParentalControlService>* outService, nn::Bit64 processId) NN_NOEXCEPT;

private:
#if NN_DETAIL_PCTL_CONFIG_SERVER_PROCESS == NN_DETAIL_PCTL_CONFIG_SERVER_PROCESS_HIPC
    int m_capability;
#endif
    nn::sf::ExpHeapAllocator* m_Allocator;
};

}}}}
