﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/nn_TimeSpan.h>
#include <nn/time/time_CalendarTime.h>
#include <nn/time/time_PosixTime.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace common {

// @brief 次の指定ローカル時刻になる絶対時刻を返します。
// @details outCalTime は nullptr を指定することができます。
nn::Result GetTimeOfNextClockPoint(nn::time::PosixTime* outTime, nn::time::CalendarTime* outCalTime,
    const nn::time::PosixTime& currentTime, int hourNext, int minuteNext) NN_NOEXCEPT;

// @brief 手前の指定ローカル時刻になる絶対時刻を返します。
// @details outCalTime は nullptr を指定することができます。
nn::Result GetTimeOfPreviousClockPoint(nn::time::PosixTime* outTime, nn::time::CalendarTime* outCalTime,
    const nn::time::PosixTime& currentTime, int hourPrevious, int minutePrevious) NN_NOEXCEPT;

// @brief 次の指定ローカル時刻になる絶対時刻を返します。
inline nn::Result GetTimeOfNextClockPoint(nn::time::PosixTime* outTime, const nn::time::PosixTime& currentTime,
    int hourNext, int minuteNext) NN_NOEXCEPT
{
    return GetTimeOfNextClockPoint(outTime, nullptr, currentTime, hourNext, minuteNext);
}

// @brief 直前の指定ローカル時刻になる絶対時刻を返します。
inline nn::Result GetTimeOfPreviousClockPoint(nn::time::PosixTime* outTime, const nn::time::PosixTime& currentTime,
    int hourPrevious, int minutePrevious) NN_NOEXCEPT
{
    return GetTimeOfPreviousClockPoint(outTime, nullptr, currentTime, hourPrevious, minutePrevious);
}

// @brief 次の日の最初の時刻を返します。
inline nn::Result GetStartTimeOfNextDate(nn::time::PosixTime* outTime, const nn::time::PosixTime& currentTime) NN_NOEXCEPT
{
    return GetTimeOfNextClockPoint(outTime, currentTime, 0, 0);
}

}}}}}
