﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/pctl/detail/pctl_AsyncData.h>
#include <nn/pctl/detail/pctl_PairingInfoBase.h>
#include <nn/pctl/detail/service/watcher/pctl_EventLog.h>
#include <nn/pctl/pctl_TypesForAuthentication.h>
#include <nn/pctl/pctl_TypesSystem.h>
#include <nn/pctl/pctl_TypesWatcher.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/time/time_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace pctl { namespace detail { namespace ipc { // NOLINT(whitespace/braces)

class IParentalControlService;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IParentalControlService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IParentalControlService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Initialize)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CheckFreeCommunicationPermission)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ConfirmLaunchApplicationPermission, (::nn::ncm::ApplicationId applicationId, const ::nn::sf::InArray<::std::int8_t>& ratingAge, bool freeCommunicationFlag))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ConfirmResumeApplicationPermission, (::nn::ncm::ApplicationId applicationId, const ::nn::sf::InArray<::std::int8_t>& ratingAge, bool freeCommunicationFlag))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ConfirmSnsPostPermission)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ConfirmSystemSettingsPermission)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsRestrictionTemporaryUnlocked, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RevertRestrictionTemporaryUnlocked)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(EnterRestrictedSystemSettings)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(LeaveRestrictedSystemSettings)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsRestrictedSystemSettingsEntered, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RevertRestrictedSystemSettingsEntered)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRestrictedFeatures, (::nn::sf::Out<int> outFeatures))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ConfirmStereoVisionPermission)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ConfirmPlayableApplicationVideoOld, (const ::nn::sf::InArray<::std::int8_t>& ratingAge))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ConfirmPlayableApplicationVideo, (::nn::ncm::ApplicationId applicationId, const ::nn::sf::InArray<::std::int8_t>& ratingAge))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsRestrictionEnabled, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSafetyLevel, (::nn::sf::Out<int> outSafetyLevel))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSafetyLevel, (int level))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSafetyLevelSettings, (::nn::sf::Out<::nn::pctl::SafetyLevelSettings> pSettings, int level))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentSettings, (::nn::sf::Out<::nn::pctl::SafetyLevelSettings> pSettings))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetCustomSafetyLevelSettings, (::nn::pctl::SafetyLevelSettings pSettings))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDefaultRatingOrganization, (::nn::sf::Out<int> outOrganization))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDefaultRatingOrganization, (int organization))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeCommunicationApplicationListCount, (::nn::sf::Out<int> outCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddToFreeCommunicationApplicationList, (::nn::ncm::ApplicationId applicationId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeleteSettings)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeCommunicationApplicationList, (::nn::sf::Out<int> outCount, const ::nn::sf::OutArray<::nn::pctl::FreeCommunicationApplicationInfo>& pOutTitleInfoArray, int offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UpdateFreeCommunicationApplicationList, (const ::nn::sf::InArray<::nn::pctl::FreeCommunicationApplicationInfo>& pTitleInfoArray))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DisableFeaturesForReset)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(NotifyApplicationDownloadStarted, (::nn::ncm::ApplicationId applicationId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ConfirmStereoVisionRestrictionConfigurable)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetStereoVisionRestriction, (::nn::sf::Out<bool> outRestricted))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetStereoVisionRestriction, (bool restricted))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ResetConfirmedStereoVisionPermission)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsStereoVisionPermitted, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnlockRestrictionTemporarily, (const ::nn::sf::InArray<char>& code))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnlockSystemSettingsRestriction, (const ::nn::sf::InArray<char>& code))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetPinCode, (const ::nn::sf::InArray<char>& code))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GenerateInquiryCode, (::nn::sf::Out<::nn::pctl::InquiryCode> pOutCodeData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CheckMasterKey, (::nn::sf::Out<bool> outValue, const ::nn::pctl::InquiryCode& codeData, const ::nn::sf::InArray<char>& masterKey))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPinCodeLength, (::nn::sf::Out<int> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPinCodeChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPinCode, (::nn::sf::Out<int> outLength, const ::nn::sf::OutArray<char>& outCode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsPairingActive, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSettingsLastUpdated, (::nn::sf::Out<::nn::time::PosixTime> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPairingAccountInfo, (::nn::sf::Out<::nn::pctl::detail::PairingAccountInfoBase> pAccountInfo, const ::nn::pctl::detail::PairingInfoBase& pairingInfo))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountNickname, (::nn::sf::Out<::std::uint32_t> pActualSize, const ::nn::sf::OutArray<char>& pNickname, const ::nn::pctl::detail::PairingAccountInfoBase& accountInfo))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountState, (::nn::sf::Out<int> outState, const ::nn::pctl::detail::PairingAccountInfoBase& accountInfo))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestPostEvents, (::nn::sf::Out<int> outCount, const ::nn::sf::OutArray<::nn::pctl::detail::service::watcher::EventData>& outEventDataArray))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSynchronizationEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StartPlayTimer)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StopPlayTimer)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsPlayTimerEnabled, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayTimerRemainingTime, (::nn::sf::Out<::nn::TimeSpanType> outTime))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsRestrictedByPlayTimer, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayTimerSettings, (::nn::sf::Out<::nn::pctl::PlayTimerSettings> pSettings))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayTimerEventToRequestSuspension, (::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsPlayTimerAlarmDisabled, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(NotifyWrongPinCodeInputManyTimes)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CancelNetworkRequest)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetUnlinkedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ClearUnlinkedEvent)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DisableAllFeatures, (::nn::sf::Out<bool> outIsAlreadyDisabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PostEnableAllFeatures, (::nn::sf::Out<bool> outIsAlreadyEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsAllFeaturesDisabled, (::nn::sf::Out<bool> outValue, ::nn::sf::Out<bool> outIsEnabledOnNextBoot))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteFromFreeCommunicationApplicationListForDebug, (::nn::ncm::ApplicationId applicationId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ClearFreeCommunicationApplicationListForDebug)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetExemptApplicationListCountForDebug, (::nn::sf::Out<int> outCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetExemptApplicationListForDebug, (::nn::sf::Out<int> outCount, const ::nn::sf::OutArray<::nn::pctl::ExemptApplicationInfo>& pOutTitleInfoArray, int offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UpdateExemptApplicationListForDebug, (const ::nn::sf::InArray<::nn::pctl::ExemptApplicationInfo>& pTitleInfoArray))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddToExemptApplicationListForDebug, (::nn::ncm::ApplicationId applicationId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteFromExemptApplicationListForDebug, (::nn::ncm::ApplicationId applicationId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ClearExemptApplicationListForDebug)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeletePairing)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetPlayTimerSettingsForDebug, (const ::nn::pctl::PlayTimerSettings& settings))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayTimerSpentTimeForTest, (::nn::sf::Out<::nn::TimeSpanType> outTime))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetPlayTimerAlarmDisabledForDebug, (bool isDisabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestPairingAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, const ::nn::sf::InArray<char>& code))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FinishRequestPairing, (::nn::sf::Out<::nn::pctl::detail::PairingInfoBase> pInfo, ::nn::pctl::detail::AsyncData asyncData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AuthorizePairingAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, const ::nn::pctl::detail::PairingInfoBase& pairingInfo))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FinishAuthorizePairing, (::nn::sf::Out<::nn::pctl::detail::PairingInfoBase> pUpdatedInfo, ::nn::pctl::detail::AsyncData asyncData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RetrievePairingInfoAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FinishRetrievePairingInfo, (::nn::sf::Out<::nn::pctl::detail::PairingInfoBase> pInfo, ::nn::pctl::detail::AsyncData asyncData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnlinkPairingAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, bool force))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FinishUnlinkPairing, (::nn::pctl::detail::AsyncData asyncData, bool force))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountMiiImageAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, ::nn::sf::Out<::std::uint32_t> pActualSize, const ::nn::sf::OutBuffer& pImage, const ::nn::pctl::detail::PairingAccountInfoBase& accountInfo))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FinishGetAccountMiiImage, (::nn::sf::Out<::std::uint32_t> pActualSize, const ::nn::sf::OutBuffer& pImage, ::nn::pctl::detail::AsyncData asyncData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountMiiImageContentTypeAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, ::nn::sf::Out<::std::uint32_t> pActualLength, const ::nn::sf::OutArray<char>& pContentType, const ::nn::pctl::detail::PairingAccountInfoBase& accountInfo))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FinishGetAccountMiiImageContentType, (::nn::sf::Out<::std::uint32_t> pActualLength, const ::nn::sf::OutArray<char>& pContentType, ::nn::pctl::detail::AsyncData asyncData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SynchronizeParentalControlSettingsAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FinishSynchronizeParentalControlSettings, (::nn::pctl::detail::AsyncData asyncData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FinishSynchronizeParentalControlSettingsWithLastUpdated, (::nn::sf::Out<::nn::time::PosixTime> outLastUpdated, ::nn::pctl::detail::AsyncData asyncData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestUpdateExemptionListAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, ::nn::ncm::ApplicationId applicationId, bool isExempt))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IParentalControlService)

        ::nn::Result Initialize() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Initialize);
        }

        ::nn::Result CheckFreeCommunicationPermission() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CheckFreeCommunicationPermission);
        }

        ::nn::Result ConfirmLaunchApplicationPermission(::nn::ncm::ApplicationId applicationId, const ::nn::sf::InArray<::std::int8_t>& ratingAge, bool freeCommunicationFlag) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), applicationId)), "_ != nn::ncm::ApplicationId::GetInvalidId() (where _ = applicationId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ConfirmLaunchApplicationPermission, (applicationId, ratingAge, freeCommunicationFlag));
        }

        ::nn::Result ConfirmResumeApplicationPermission(::nn::ncm::ApplicationId applicationId, const ::nn::sf::InArray<::std::int8_t>& ratingAge, bool freeCommunicationFlag) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), applicationId)), "_ != nn::ncm::ApplicationId::GetInvalidId() (where _ = applicationId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ConfirmResumeApplicationPermission, (applicationId, ratingAge, freeCommunicationFlag));
        }

        ::nn::Result ConfirmSnsPostPermission() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ConfirmSnsPostPermission);
        }

        ::nn::Result ConfirmSystemSettingsPermission() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ConfirmSystemSettingsPermission);
        }

        ::nn::Result IsRestrictionTemporaryUnlocked(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsRestrictionTemporaryUnlocked, (outValue));
        }

        ::nn::Result RevertRestrictionTemporaryUnlocked() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RevertRestrictionTemporaryUnlocked);
        }

        ::nn::Result EnterRestrictedSystemSettings() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(EnterRestrictedSystemSettings);
        }

        ::nn::Result LeaveRestrictedSystemSettings() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(LeaveRestrictedSystemSettings);
        }

        ::nn::Result IsRestrictedSystemSettingsEntered(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsRestrictedSystemSettingsEntered, (outValue));
        }

        ::nn::Result RevertRestrictedSystemSettingsEntered() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RevertRestrictedSystemSettingsEntered);
        }

        ::nn::Result GetRestrictedFeatures(::nn::sf::Out<int> outFeatures) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRestrictedFeatures, (outFeatures));
        }

        ::nn::Result ConfirmStereoVisionPermission() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ConfirmStereoVisionPermission);
        }

        ::nn::Result ConfirmPlayableApplicationVideoOld(const ::nn::sf::InArray<::std::int8_t>& ratingAge) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ConfirmPlayableApplicationVideoOld, (ratingAge));
        }

        ::nn::Result ConfirmPlayableApplicationVideo(::nn::ncm::ApplicationId applicationId, const ::nn::sf::InArray<::std::int8_t>& ratingAge) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), applicationId)), "_ != nn::ncm::ApplicationId::GetInvalidId() (where _ = applicationId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ConfirmPlayableApplicationVideo, (applicationId, ratingAge));
        }

        ::nn::Result IsRestrictionEnabled(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsRestrictionEnabled, (outValue));
        }

        ::nn::Result GetSafetyLevel(::nn::sf::Out<int> outSafetyLevel) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSafetyLevel, (outSafetyLevel));
        }

        ::nn::Result SetSafetyLevel(int level) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0 && _ < 5), level)), "_ >= 0 && _ < 5 (where _ = level)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSafetyLevel, (level));
        }

        ::nn::Result GetSafetyLevelSettings(::nn::sf::Out<::nn::pctl::SafetyLevelSettings> pSettings, int level) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0 && _ < 5), level)), "_ >= 0 && _ < 5 (where _ = level)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSafetyLevelSettings, (pSettings, level));
        }

        ::nn::Result GetCurrentSettings(::nn::sf::Out<::nn::pctl::SafetyLevelSettings> pSettings) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCurrentSettings, (pSettings));
        }

        ::nn::Result SetCustomSafetyLevelSettings(::nn::pctl::SafetyLevelSettings pSettings) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetCustomSafetyLevelSettings, (pSettings));
        }

        ::nn::Result GetDefaultRatingOrganization(::nn::sf::Out<int> outOrganization) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDefaultRatingOrganization, (outOrganization));
        }

        ::nn::Result SetDefaultRatingOrganization(int organization) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), organization)), "_ >= 0 (where _ = organization)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDefaultRatingOrganization, (organization));
        }

        ::nn::Result GetFreeCommunicationApplicationListCount(::nn::sf::Out<int> outCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFreeCommunicationApplicationListCount, (outCount));
        }

        ::nn::Result AddToFreeCommunicationApplicationList(::nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), applicationId)), "_ != nn::ncm::ApplicationId::GetInvalidId() (where _ = applicationId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddToFreeCommunicationApplicationList, (applicationId));
        }

        ::nn::Result DeleteSettings() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeleteSettings);
        }

        ::nn::Result GetFreeCommunicationApplicationList(::nn::sf::Out<int> outCount, const ::nn::sf::OutArray<::nn::pctl::FreeCommunicationApplicationInfo>& pOutTitleInfoArray, int offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), offset)), "_ >= 0 (where _ = offset)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFreeCommunicationApplicationList, (outCount, pOutTitleInfoArray, offset));
        }

        ::nn::Result UpdateFreeCommunicationApplicationList(const ::nn::sf::InArray<::nn::pctl::FreeCommunicationApplicationInfo>& pTitleInfoArray) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UpdateFreeCommunicationApplicationList, (pTitleInfoArray));
        }

        ::nn::Result DisableFeaturesForReset() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DisableFeaturesForReset);
        }

        ::nn::Result NotifyApplicationDownloadStarted(::nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), applicationId)), "_ != nn::ncm::ApplicationId::GetInvalidId() (where _ = applicationId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(NotifyApplicationDownloadStarted, (applicationId));
        }

        ::nn::Result ConfirmStereoVisionRestrictionConfigurable() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ConfirmStereoVisionRestrictionConfigurable);
        }

        ::nn::Result GetStereoVisionRestriction(::nn::sf::Out<bool> outRestricted) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetStereoVisionRestriction, (outRestricted));
        }

        ::nn::Result SetStereoVisionRestriction(bool restricted) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetStereoVisionRestriction, (restricted));
        }

        ::nn::Result ResetConfirmedStereoVisionPermission() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ResetConfirmedStereoVisionPermission);
        }

        ::nn::Result IsStereoVisionPermitted(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsStereoVisionPermitted, (outValue));
        }

        ::nn::Result UnlockRestrictionTemporarily(const ::nn::sf::InArray<char>& code) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnlockRestrictionTemporarily, (code));
        }

        ::nn::Result UnlockSystemSettingsRestriction(const ::nn::sf::InArray<char>& code) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnlockSystemSettingsRestriction, (code));
        }

        ::nn::Result SetPinCode(const ::nn::sf::InArray<char>& code) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetPinCode, (code));
        }

        ::nn::Result GenerateInquiryCode(::nn::sf::Out<::nn::pctl::InquiryCode> pOutCodeData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GenerateInquiryCode, (pOutCodeData));
        }

        ::nn::Result CheckMasterKey(::nn::sf::Out<bool> outValue, const ::nn::pctl::InquiryCode& codeData, const ::nn::sf::InArray<char>& masterKey) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CheckMasterKey, (outValue, codeData, masterKey));
        }

        ::nn::Result GetPinCodeLength(::nn::sf::Out<int> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPinCodeLength, (outValue));
        }

        ::nn::Result GetPinCodeChangedEvent(::nn::sf::Out<::nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPinCodeChangedEvent, (pEvent));
        }

        ::nn::Result GetPinCode(::nn::sf::Out<int> outLength, const ::nn::sf::OutArray<char>& outCode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPinCode, (outLength, outCode));
        }

        ::nn::Result IsPairingActive(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsPairingActive, (outValue));
        }

        ::nn::Result GetSettingsLastUpdated(::nn::sf::Out<::nn::time::PosixTime> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSettingsLastUpdated, (outValue));
        }

        ::nn::Result GetPairingAccountInfo(::nn::sf::Out<::nn::pctl::detail::PairingAccountInfoBase> pAccountInfo, const ::nn::pctl::detail::PairingInfoBase& pairingInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPairingAccountInfo, (pAccountInfo, pairingInfo));
        }

        ::nn::Result GetAccountNickname(::nn::sf::Out<::std::uint32_t> pActualSize, const ::nn::sf::OutArray<char>& pNickname, const ::nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAccountNickname, (pActualSize, pNickname, accountInfo));
        }

        ::nn::Result GetAccountState(::nn::sf::Out<int> outState, const ::nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAccountState, (outState, accountInfo));
        }

        ::nn::Result RequestPostEvents(::nn::sf::Out<int> outCount, const ::nn::sf::OutArray<::nn::pctl::detail::service::watcher::EventData>& outEventDataArray) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestPostEvents, (outCount, outEventDataArray));
        }

        ::nn::Result GetSynchronizationEvent(::nn::sf::Out<::nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSynchronizationEvent, (pEvent));
        }

        ::nn::Result StartPlayTimer() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StartPlayTimer);
        }

        ::nn::Result StopPlayTimer() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StopPlayTimer);
        }

        ::nn::Result IsPlayTimerEnabled(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsPlayTimerEnabled, (outValue));
        }

        ::nn::Result GetPlayTimerRemainingTime(::nn::sf::Out<::nn::TimeSpanType> outTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPlayTimerRemainingTime, (outTime));
        }

        ::nn::Result IsRestrictedByPlayTimer(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsRestrictedByPlayTimer, (outValue));
        }

        ::nn::Result GetPlayTimerSettings(::nn::sf::Out<::nn::pctl::PlayTimerSettings> pSettings) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPlayTimerSettings, (pSettings));
        }

        ::nn::Result GetPlayTimerEventToRequestSuspension(::nn::sf::Out<::nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPlayTimerEventToRequestSuspension, (pEvent));
        }

        ::nn::Result IsPlayTimerAlarmDisabled(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsPlayTimerAlarmDisabled, (outValue));
        }

        ::nn::Result NotifyWrongPinCodeInputManyTimes() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(NotifyWrongPinCodeInputManyTimes);
        }

        ::nn::Result CancelNetworkRequest() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CancelNetworkRequest);
        }

        ::nn::Result GetUnlinkedEvent(::nn::sf::Out<::nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetUnlinkedEvent, (pEvent));
        }

        ::nn::Result ClearUnlinkedEvent() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ClearUnlinkedEvent);
        }

        ::nn::Result DisableAllFeatures(::nn::sf::Out<bool> outIsAlreadyDisabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DisableAllFeatures, (outIsAlreadyDisabled));
        }

        ::nn::Result PostEnableAllFeatures(::nn::sf::Out<bool> outIsAlreadyEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PostEnableAllFeatures, (outIsAlreadyEnabled));
        }

        ::nn::Result IsAllFeaturesDisabled(::nn::sf::Out<bool> outValue, ::nn::sf::Out<bool> outIsEnabledOnNextBoot) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsAllFeaturesDisabled, (outValue, outIsEnabledOnNextBoot));
        }

        ::nn::Result DeleteFromFreeCommunicationApplicationListForDebug(::nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), applicationId)), "_ != nn::ncm::ApplicationId::GetInvalidId() (where _ = applicationId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteFromFreeCommunicationApplicationListForDebug, (applicationId));
        }

        ::nn::Result ClearFreeCommunicationApplicationListForDebug() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ClearFreeCommunicationApplicationListForDebug);
        }

        ::nn::Result GetExemptApplicationListCountForDebug(::nn::sf::Out<int> outCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetExemptApplicationListCountForDebug, (outCount));
        }

        ::nn::Result GetExemptApplicationListForDebug(::nn::sf::Out<int> outCount, const ::nn::sf::OutArray<::nn::pctl::ExemptApplicationInfo>& pOutTitleInfoArray, int offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), offset)), "_ >= 0 (where _ = offset)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetExemptApplicationListForDebug, (outCount, pOutTitleInfoArray, offset));
        }

        ::nn::Result UpdateExemptApplicationListForDebug(const ::nn::sf::InArray<::nn::pctl::ExemptApplicationInfo>& pTitleInfoArray) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UpdateExemptApplicationListForDebug, (pTitleInfoArray));
        }

        ::nn::Result AddToExemptApplicationListForDebug(::nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), applicationId)), "_ != nn::ncm::ApplicationId::GetInvalidId() (where _ = applicationId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddToExemptApplicationListForDebug, (applicationId));
        }

        ::nn::Result DeleteFromExemptApplicationListForDebug(::nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), applicationId)), "_ != nn::ncm::ApplicationId::GetInvalidId() (where _ = applicationId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteFromExemptApplicationListForDebug, (applicationId));
        }

        ::nn::Result ClearExemptApplicationListForDebug() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ClearExemptApplicationListForDebug);
        }

        ::nn::Result DeletePairing() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeletePairing);
        }

        ::nn::Result SetPlayTimerSettingsForDebug(const ::nn::pctl::PlayTimerSettings& settings) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetPlayTimerSettingsForDebug, (settings));
        }

        ::nn::Result GetPlayTimerSpentTimeForTest(::nn::sf::Out<::nn::TimeSpanType> outTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPlayTimerSpentTimeForTest, (outTime));
        }

        ::nn::Result SetPlayTimerAlarmDisabledForDebug(bool isDisabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetPlayTimerAlarmDisabledForDebug, (isDisabled));
        }

        ::nn::Result RequestPairingAsync(::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, const ::nn::sf::InArray<char>& code) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestPairingAsync, (pAsyncData, pEvent, code));
        }

        ::nn::Result FinishRequestPairing(::nn::sf::Out<::nn::pctl::detail::PairingInfoBase> pInfo, ::nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FinishRequestPairing, (pInfo, asyncData));
        }

        ::nn::Result AuthorizePairingAsync(::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, const ::nn::pctl::detail::PairingInfoBase& pairingInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AuthorizePairingAsync, (pAsyncData, pEvent, pairingInfo));
        }

        ::nn::Result FinishAuthorizePairing(::nn::sf::Out<::nn::pctl::detail::PairingInfoBase> pUpdatedInfo, ::nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FinishAuthorizePairing, (pUpdatedInfo, asyncData));
        }

        ::nn::Result RetrievePairingInfoAsync(::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RetrievePairingInfoAsync, (pAsyncData, pEvent));
        }

        ::nn::Result FinishRetrievePairingInfo(::nn::sf::Out<::nn::pctl::detail::PairingInfoBase> pInfo, ::nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FinishRetrievePairingInfo, (pInfo, asyncData));
        }

        ::nn::Result UnlinkPairingAsync(::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, bool force) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnlinkPairingAsync, (pAsyncData, pEvent, force));
        }

        ::nn::Result FinishUnlinkPairing(::nn::pctl::detail::AsyncData asyncData, bool force) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FinishUnlinkPairing, (asyncData, force));
        }

        ::nn::Result GetAccountMiiImageAsync(::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, ::nn::sf::Out<::std::uint32_t> pActualSize, const ::nn::sf::OutBuffer& pImage, const ::nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAccountMiiImageAsync, (pAsyncData, pEvent, pActualSize, pImage, accountInfo));
        }

        ::nn::Result FinishGetAccountMiiImage(::nn::sf::Out<::std::uint32_t> pActualSize, const ::nn::sf::OutBuffer& pImage, ::nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FinishGetAccountMiiImage, (pActualSize, pImage, asyncData));
        }

        ::nn::Result GetAccountMiiImageContentTypeAsync(::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, ::nn::sf::Out<::std::uint32_t> pActualLength, const ::nn::sf::OutArray<char>& pContentType, const ::nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAccountMiiImageContentTypeAsync, (pAsyncData, pEvent, pActualLength, pContentType, accountInfo));
        }

        ::nn::Result FinishGetAccountMiiImageContentType(::nn::sf::Out<::std::uint32_t> pActualLength, const ::nn::sf::OutArray<char>& pContentType, ::nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FinishGetAccountMiiImageContentType, (pActualLength, pContentType, asyncData));
        }

        ::nn::Result SynchronizeParentalControlSettingsAsync(::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SynchronizeParentalControlSettingsAsync, (pAsyncData, pEvent));
        }

        ::nn::Result FinishSynchronizeParentalControlSettings(::nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FinishSynchronizeParentalControlSettings, (asyncData));
        }

        ::nn::Result FinishSynchronizeParentalControlSettingsWithLastUpdated(::nn::sf::Out<::nn::time::PosixTime> outLastUpdated, ::nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FinishSynchronizeParentalControlSettingsWithLastUpdated, (outLastUpdated, asyncData));
        }

        ::nn::Result RequestUpdateExemptionListAsync(::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, ::nn::ncm::ApplicationId applicationId, bool isExempt) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), applicationId)), "_ != nn::ncm::ApplicationId::GetInvalidId() (where _ = applicationId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestUpdateExemptionListAsync, (pAsyncData, pEvent, applicationId, isExempt));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IParentalControlService
    {
    public:
        nn::Result Initialize() NN_NOEXCEPT;
        nn::Result CheckFreeCommunicationPermission() NN_NOEXCEPT;
        nn::Result ConfirmLaunchApplicationPermission(nn::ncm::ApplicationId applicationId, const nn::sf::InArray<std::int8_t>& ratingAge, bool freeCommunicationFlag) NN_NOEXCEPT;
        nn::Result ConfirmResumeApplicationPermission(nn::ncm::ApplicationId applicationId, const nn::sf::InArray<std::int8_t>& ratingAge, bool freeCommunicationFlag) NN_NOEXCEPT;
        nn::Result ConfirmSnsPostPermission() NN_NOEXCEPT;
        nn::Result ConfirmSystemSettingsPermission() NN_NOEXCEPT;
        nn::Result IsRestrictionTemporaryUnlocked(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result RevertRestrictionTemporaryUnlocked() NN_NOEXCEPT;
        nn::Result EnterRestrictedSystemSettings() NN_NOEXCEPT;
        nn::Result LeaveRestrictedSystemSettings() NN_NOEXCEPT;
        nn::Result IsRestrictedSystemSettingsEntered(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result RevertRestrictedSystemSettingsEntered() NN_NOEXCEPT;
        nn::Result GetRestrictedFeatures(nn::sf::Out<int> outFeatures) NN_NOEXCEPT;
        nn::Result ConfirmStereoVisionPermission() NN_NOEXCEPT;
        nn::Result ConfirmPlayableApplicationVideoOld(const nn::sf::InArray<std::int8_t>& ratingAge) NN_NOEXCEPT;
        nn::Result ConfirmPlayableApplicationVideo(nn::ncm::ApplicationId applicationId, const nn::sf::InArray<std::int8_t>& ratingAge) NN_NOEXCEPT;
        nn::Result IsRestrictionEnabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result GetSafetyLevel(nn::sf::Out<int> outSafetyLevel) NN_NOEXCEPT;
        nn::Result SetSafetyLevel(int level) NN_NOEXCEPT;
        nn::Result GetSafetyLevelSettings(nn::sf::Out<nn::pctl::SafetyLevelSettings> pSettings, int level) NN_NOEXCEPT;
        nn::Result GetCurrentSettings(nn::sf::Out<nn::pctl::SafetyLevelSettings> pSettings) NN_NOEXCEPT;
        nn::Result SetCustomSafetyLevelSettings(nn::pctl::SafetyLevelSettings pSettings) NN_NOEXCEPT;
        nn::Result GetDefaultRatingOrganization(nn::sf::Out<int> outOrganization) NN_NOEXCEPT;
        nn::Result SetDefaultRatingOrganization(int organization) NN_NOEXCEPT;
        nn::Result GetFreeCommunicationApplicationListCount(nn::sf::Out<int> outCount) NN_NOEXCEPT;
        nn::Result AddToFreeCommunicationApplicationList(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result DeleteSettings() NN_NOEXCEPT;
        nn::Result GetFreeCommunicationApplicationList(nn::sf::Out<int> outCount, const nn::sf::OutArray<nn::pctl::FreeCommunicationApplicationInfo>& pOutTitleInfoArray, int offset) NN_NOEXCEPT;
        nn::Result UpdateFreeCommunicationApplicationList(const nn::sf::InArray<nn::pctl::FreeCommunicationApplicationInfo>& pTitleInfoArray) NN_NOEXCEPT;
        nn::Result DisableFeaturesForReset() NN_NOEXCEPT;
        nn::Result NotifyApplicationDownloadStarted(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result ConfirmStereoVisionRestrictionConfigurable() NN_NOEXCEPT;
        nn::Result GetStereoVisionRestriction(nn::sf::Out<bool> outRestricted) NN_NOEXCEPT;
        nn::Result SetStereoVisionRestriction(bool restricted) NN_NOEXCEPT;
        nn::Result ResetConfirmedStereoVisionPermission() NN_NOEXCEPT;
        nn::Result IsStereoVisionPermitted(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result UnlockRestrictionTemporarily(const nn::sf::InArray<char>& code) NN_NOEXCEPT;
        nn::Result UnlockSystemSettingsRestriction(const nn::sf::InArray<char>& code) NN_NOEXCEPT;
        nn::Result SetPinCode(const nn::sf::InArray<char>& code) NN_NOEXCEPT;
        nn::Result GenerateInquiryCode(nn::sf::Out<nn::pctl::InquiryCode> pOutCodeData) NN_NOEXCEPT;
        nn::Result CheckMasterKey(nn::sf::Out<bool> outValue, const nn::pctl::InquiryCode& codeData, const nn::sf::InArray<char>& masterKey) NN_NOEXCEPT;
        nn::Result GetPinCodeLength(nn::sf::Out<int> outValue) NN_NOEXCEPT;
        nn::Result GetPinCodeChangedEvent(nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT;
        nn::Result GetPinCode(nn::sf::Out<int> outLength, const nn::sf::OutArray<char>& outCode) NN_NOEXCEPT;
        nn::Result IsPairingActive(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result GetSettingsLastUpdated(nn::sf::Out<nn::time::PosixTime> outValue) NN_NOEXCEPT;
        nn::Result GetPairingAccountInfo(nn::sf::Out<nn::pctl::detail::PairingAccountInfoBase> pAccountInfo, const nn::pctl::detail::PairingInfoBase& pairingInfo) NN_NOEXCEPT;
        nn::Result GetAccountNickname(nn::sf::Out<std::uint32_t> pActualSize, const nn::sf::OutArray<char>& pNickname, const nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT;
        nn::Result GetAccountState(nn::sf::Out<int> outState, const nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT;
        nn::Result RequestPostEvents(nn::sf::Out<int> outCount, const nn::sf::OutArray<nn::pctl::detail::service::watcher::EventData>& outEventDataArray) NN_NOEXCEPT;
        nn::Result GetSynchronizationEvent(nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT;
        nn::Result StartPlayTimer() NN_NOEXCEPT;
        nn::Result StopPlayTimer() NN_NOEXCEPT;
        nn::Result IsPlayTimerEnabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result GetPlayTimerRemainingTime(nn::sf::Out<nn::TimeSpanType> outTime) NN_NOEXCEPT;
        nn::Result IsRestrictedByPlayTimer(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result GetPlayTimerSettings(nn::sf::Out<nn::pctl::PlayTimerSettings> pSettings) NN_NOEXCEPT;
        nn::Result GetPlayTimerEventToRequestSuspension(nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT;
        nn::Result IsPlayTimerAlarmDisabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result NotifyWrongPinCodeInputManyTimes() NN_NOEXCEPT;
        nn::Result CancelNetworkRequest() NN_NOEXCEPT;
        nn::Result GetUnlinkedEvent(nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT;
        nn::Result ClearUnlinkedEvent() NN_NOEXCEPT;
        nn::Result DisableAllFeatures(nn::sf::Out<bool> outIsAlreadyDisabled) NN_NOEXCEPT;
        nn::Result PostEnableAllFeatures(nn::sf::Out<bool> outIsAlreadyEnabled) NN_NOEXCEPT;
        nn::Result IsAllFeaturesDisabled(nn::sf::Out<bool> outValue, nn::sf::Out<bool> outIsEnabledOnNextBoot) NN_NOEXCEPT;
        nn::Result DeleteFromFreeCommunicationApplicationListForDebug(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result ClearFreeCommunicationApplicationListForDebug() NN_NOEXCEPT;
        nn::Result GetExemptApplicationListCountForDebug(nn::sf::Out<int> outCount) NN_NOEXCEPT;
        nn::Result GetExemptApplicationListForDebug(nn::sf::Out<int> outCount, const nn::sf::OutArray<nn::pctl::ExemptApplicationInfo>& pOutTitleInfoArray, int offset) NN_NOEXCEPT;
        nn::Result UpdateExemptApplicationListForDebug(const nn::sf::InArray<nn::pctl::ExemptApplicationInfo>& pTitleInfoArray) NN_NOEXCEPT;
        nn::Result AddToExemptApplicationListForDebug(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result DeleteFromExemptApplicationListForDebug(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result ClearExemptApplicationListForDebug() NN_NOEXCEPT;
        nn::Result DeletePairing() NN_NOEXCEPT;
        nn::Result SetPlayTimerSettingsForDebug(const nn::pctl::PlayTimerSettings& settings) NN_NOEXCEPT;
        nn::Result GetPlayTimerSpentTimeForTest(nn::sf::Out<nn::TimeSpanType> outTime) NN_NOEXCEPT;
        nn::Result SetPlayTimerAlarmDisabledForDebug(bool isDisabled) NN_NOEXCEPT;
        nn::Result RequestPairingAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, const nn::sf::InArray<char>& code) NN_NOEXCEPT;
        nn::Result FinishRequestPairing(nn::sf::Out<nn::pctl::detail::PairingInfoBase> pInfo, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT;
        nn::Result AuthorizePairingAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, const nn::pctl::detail::PairingInfoBase& pairingInfo) NN_NOEXCEPT;
        nn::Result FinishAuthorizePairing(nn::sf::Out<nn::pctl::detail::PairingInfoBase> pUpdatedInfo, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT;
        nn::Result RetrievePairingInfoAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT;
        nn::Result FinishRetrievePairingInfo(nn::sf::Out<nn::pctl::detail::PairingInfoBase> pInfo, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT;
        nn::Result UnlinkPairingAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, bool force) NN_NOEXCEPT;
        nn::Result FinishUnlinkPairing(nn::pctl::detail::AsyncData asyncData, bool force) NN_NOEXCEPT;
        nn::Result GetAccountMiiImageAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, nn::sf::Out<std::uint32_t> pActualSize, const nn::sf::OutBuffer& pImage, const nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT;
        nn::Result FinishGetAccountMiiImage(nn::sf::Out<std::uint32_t> pActualSize, const nn::sf::OutBuffer& pImage, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT;
        nn::Result GetAccountMiiImageContentTypeAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, nn::sf::Out<std::uint32_t> pActualLength, const nn::sf::OutArray<char>& pContentType, const nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT;
        nn::Result FinishGetAccountMiiImageContentType(nn::sf::Out<std::uint32_t> pActualLength, const nn::sf::OutArray<char>& pContentType, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT;
        nn::Result SynchronizeParentalControlSettingsAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT;
        nn::Result FinishSynchronizeParentalControlSettings(nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT;
        nn::Result FinishSynchronizeParentalControlSettingsWithLastUpdated(nn::sf::Out<nn::time::PosixTime> outLastUpdated, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT;
        nn::Result RequestUpdateExemptionListAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, nn::ncm::ApplicationId applicationId, bool isExempt) NN_NOEXCEPT;
    };
#endif

}}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result Initialize() NN_NOEXCEPT;
    nn::Result CheckFreeCommunicationPermission() NN_NOEXCEPT;
    nn::Result ConfirmLaunchApplicationPermission(nn::ncm::ApplicationId applicationId, const nn::sf::InArray<std::int8_t>& ratingAge, bool freeCommunicationFlag) NN_NOEXCEPT;
    nn::Result ConfirmResumeApplicationPermission(nn::ncm::ApplicationId applicationId, const nn::sf::InArray<std::int8_t>& ratingAge, bool freeCommunicationFlag) NN_NOEXCEPT;
    nn::Result ConfirmSnsPostPermission() NN_NOEXCEPT;
    nn::Result ConfirmSystemSettingsPermission() NN_NOEXCEPT;
    nn::Result IsRestrictionTemporaryUnlocked(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result RevertRestrictionTemporaryUnlocked() NN_NOEXCEPT;
    nn::Result EnterRestrictedSystemSettings() NN_NOEXCEPT;
    nn::Result LeaveRestrictedSystemSettings() NN_NOEXCEPT;
    nn::Result IsRestrictedSystemSettingsEntered(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result RevertRestrictedSystemSettingsEntered() NN_NOEXCEPT;
    nn::Result GetRestrictedFeatures(nn::sf::Out<int> outFeatures) NN_NOEXCEPT;
    nn::Result ConfirmStereoVisionPermission() NN_NOEXCEPT;
    nn::Result ConfirmPlayableApplicationVideoOld(const nn::sf::InArray<std::int8_t>& ratingAge) NN_NOEXCEPT;
    nn::Result ConfirmPlayableApplicationVideo(nn::ncm::ApplicationId applicationId, const nn::sf::InArray<std::int8_t>& ratingAge) NN_NOEXCEPT;
    nn::Result IsRestrictionEnabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result GetSafetyLevel(nn::sf::Out<int> outSafetyLevel) NN_NOEXCEPT;
    nn::Result SetSafetyLevel(int level) NN_NOEXCEPT;
    nn::Result GetSafetyLevelSettings(nn::sf::Out<nn::pctl::SafetyLevelSettings> pSettings, int level) NN_NOEXCEPT;
    nn::Result GetCurrentSettings(nn::sf::Out<nn::pctl::SafetyLevelSettings> pSettings) NN_NOEXCEPT;
    nn::Result SetCustomSafetyLevelSettings(nn::pctl::SafetyLevelSettings pSettings) NN_NOEXCEPT;
    nn::Result GetDefaultRatingOrganization(nn::sf::Out<int> outOrganization) NN_NOEXCEPT;
    nn::Result SetDefaultRatingOrganization(int organization) NN_NOEXCEPT;
    nn::Result GetFreeCommunicationApplicationListCount(nn::sf::Out<int> outCount) NN_NOEXCEPT;
    nn::Result AddToFreeCommunicationApplicationList(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result DeleteSettings() NN_NOEXCEPT;
    nn::Result GetFreeCommunicationApplicationList(nn::sf::Out<int> outCount, const nn::sf::OutArray<nn::pctl::FreeCommunicationApplicationInfo>& pOutTitleInfoArray, int offset) NN_NOEXCEPT;
    nn::Result UpdateFreeCommunicationApplicationList(const nn::sf::InArray<nn::pctl::FreeCommunicationApplicationInfo>& pTitleInfoArray) NN_NOEXCEPT;
    nn::Result DisableFeaturesForReset() NN_NOEXCEPT;
    nn::Result NotifyApplicationDownloadStarted(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result ConfirmStereoVisionRestrictionConfigurable() NN_NOEXCEPT;
    nn::Result GetStereoVisionRestriction(nn::sf::Out<bool> outRestricted) NN_NOEXCEPT;
    nn::Result SetStereoVisionRestriction(bool restricted) NN_NOEXCEPT;
    nn::Result ResetConfirmedStereoVisionPermission() NN_NOEXCEPT;
    nn::Result IsStereoVisionPermitted(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result UnlockRestrictionTemporarily(const nn::sf::InArray<char>& code) NN_NOEXCEPT;
    nn::Result UnlockSystemSettingsRestriction(const nn::sf::InArray<char>& code) NN_NOEXCEPT;
    nn::Result SetPinCode(const nn::sf::InArray<char>& code) NN_NOEXCEPT;
    nn::Result GenerateInquiryCode(nn::sf::Out<nn::pctl::InquiryCode> pOutCodeData) NN_NOEXCEPT;
    nn::Result CheckMasterKey(nn::sf::Out<bool> outValue, const nn::pctl::InquiryCode& codeData, const nn::sf::InArray<char>& masterKey) NN_NOEXCEPT;
    nn::Result GetPinCodeLength(nn::sf::Out<int> outValue) NN_NOEXCEPT;
    nn::Result GetPinCodeChangedEvent(nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT;
    nn::Result GetPinCode(nn::sf::Out<int> outLength, const nn::sf::OutArray<char>& outCode) NN_NOEXCEPT;
    nn::Result IsPairingActive(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result GetSettingsLastUpdated(nn::sf::Out<nn::time::PosixTime> outValue) NN_NOEXCEPT;
    nn::Result GetPairingAccountInfo(nn::sf::Out<nn::pctl::detail::PairingAccountInfoBase> pAccountInfo, const nn::pctl::detail::PairingInfoBase& pairingInfo) NN_NOEXCEPT;
    nn::Result GetAccountNickname(nn::sf::Out<std::uint32_t> pActualSize, const nn::sf::OutArray<char>& pNickname, const nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT;
    nn::Result GetAccountState(nn::sf::Out<int> outState, const nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT;
    nn::Result RequestPostEvents(nn::sf::Out<int> outCount, const nn::sf::OutArray<nn::pctl::detail::service::watcher::EventData>& outEventDataArray) NN_NOEXCEPT;
    nn::Result GetSynchronizationEvent(nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT;
    nn::Result StartPlayTimer() NN_NOEXCEPT;
    nn::Result StopPlayTimer() NN_NOEXCEPT;
    nn::Result IsPlayTimerEnabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result GetPlayTimerRemainingTime(nn::sf::Out<nn::TimeSpanType> outTime) NN_NOEXCEPT;
    nn::Result IsRestrictedByPlayTimer(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result GetPlayTimerSettings(nn::sf::Out<nn::pctl::PlayTimerSettings> pSettings) NN_NOEXCEPT;
    nn::Result GetPlayTimerEventToRequestSuspension(nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT;
    nn::Result IsPlayTimerAlarmDisabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result NotifyWrongPinCodeInputManyTimes() NN_NOEXCEPT;
    nn::Result CancelNetworkRequest() NN_NOEXCEPT;
    nn::Result GetUnlinkedEvent(nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT;
    nn::Result ClearUnlinkedEvent() NN_NOEXCEPT;
    nn::Result DisableAllFeatures(nn::sf::Out<bool> outIsAlreadyDisabled) NN_NOEXCEPT;
    nn::Result PostEnableAllFeatures(nn::sf::Out<bool> outIsAlreadyEnabled) NN_NOEXCEPT;
    nn::Result IsAllFeaturesDisabled(nn::sf::Out<bool> outValue, nn::sf::Out<bool> outIsEnabledOnNextBoot) NN_NOEXCEPT;
    nn::Result DeleteFromFreeCommunicationApplicationListForDebug(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result ClearFreeCommunicationApplicationListForDebug() NN_NOEXCEPT;
    nn::Result GetExemptApplicationListCountForDebug(nn::sf::Out<int> outCount) NN_NOEXCEPT;
    nn::Result GetExemptApplicationListForDebug(nn::sf::Out<int> outCount, const nn::sf::OutArray<nn::pctl::ExemptApplicationInfo>& pOutTitleInfoArray, int offset) NN_NOEXCEPT;
    nn::Result UpdateExemptApplicationListForDebug(const nn::sf::InArray<nn::pctl::ExemptApplicationInfo>& pTitleInfoArray) NN_NOEXCEPT;
    nn::Result AddToExemptApplicationListForDebug(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result DeleteFromExemptApplicationListForDebug(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result ClearExemptApplicationListForDebug() NN_NOEXCEPT;
    nn::Result DeletePairing() NN_NOEXCEPT;
    nn::Result SetPlayTimerSettingsForDebug(const nn::pctl::PlayTimerSettings& settings) NN_NOEXCEPT;
    nn::Result GetPlayTimerSpentTimeForTest(nn::sf::Out<nn::TimeSpanType> outTime) NN_NOEXCEPT;
    nn::Result SetPlayTimerAlarmDisabledForDebug(bool isDisabled) NN_NOEXCEPT;
    nn::Result RequestPairingAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, const nn::sf::InArray<char>& code) NN_NOEXCEPT;
    nn::Result FinishRequestPairing(nn::sf::Out<nn::pctl::detail::PairingInfoBase> pInfo, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT;
    nn::Result AuthorizePairingAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, const nn::pctl::detail::PairingInfoBase& pairingInfo) NN_NOEXCEPT;
    nn::Result FinishAuthorizePairing(nn::sf::Out<nn::pctl::detail::PairingInfoBase> pUpdatedInfo, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT;
    nn::Result RetrievePairingInfoAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT;
    nn::Result FinishRetrievePairingInfo(nn::sf::Out<nn::pctl::detail::PairingInfoBase> pInfo, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT;
    nn::Result UnlinkPairingAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, bool force) NN_NOEXCEPT;
    nn::Result FinishUnlinkPairing(nn::pctl::detail::AsyncData asyncData, bool force) NN_NOEXCEPT;
    nn::Result GetAccountMiiImageAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, nn::sf::Out<std::uint32_t> pActualSize, const nn::sf::OutBuffer& pImage, const nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT;
    nn::Result FinishGetAccountMiiImage(nn::sf::Out<std::uint32_t> pActualSize, const nn::sf::OutBuffer& pImage, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT;
    nn::Result GetAccountMiiImageContentTypeAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, nn::sf::Out<std::uint32_t> pActualLength, const nn::sf::OutArray<char>& pContentType, const nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT;
    nn::Result FinishGetAccountMiiImageContentType(nn::sf::Out<std::uint32_t> pActualLength, const nn::sf::OutArray<char>& pContentType, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT;
    nn::Result SynchronizeParentalControlSettingsAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT;
    nn::Result FinishSynchronizeParentalControlSettings(nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT;
    nn::Result FinishSynchronizeParentalControlSettingsWithLastUpdated(nn::sf::Out<nn::time::PosixTime> outLastUpdated, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT;
    nn::Result RequestUpdateExemptionListAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, nn::ncm::ApplicationId applicationId, bool isExempt) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::pctl::detail::ipc::IParentalControlService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Initialize)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Initialize);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CheckFreeCommunicationPermission)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CheckFreeCommunicationPermission);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConfirmLaunchApplicationPermission, (::nn::ncm::ApplicationId applicationId, const ::nn::sf::InArray<::std::int8_t>& ratingAge, bool freeCommunicationFlag))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ConfirmLaunchApplicationPermission, (applicationId, ratingAge, freeCommunicationFlag));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConfirmResumeApplicationPermission, (::nn::ncm::ApplicationId applicationId, const ::nn::sf::InArray<::std::int8_t>& ratingAge, bool freeCommunicationFlag))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ConfirmResumeApplicationPermission, (applicationId, ratingAge, freeCommunicationFlag));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ConfirmSnsPostPermission)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ConfirmSnsPostPermission);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ConfirmSystemSettingsPermission)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ConfirmSystemSettingsPermission);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsRestrictionTemporaryUnlocked, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsRestrictionTemporaryUnlocked, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RevertRestrictionTemporaryUnlocked)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RevertRestrictionTemporaryUnlocked);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnterRestrictedSystemSettings)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(EnterRestrictedSystemSettings);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(LeaveRestrictedSystemSettings)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(LeaveRestrictedSystemSettings);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsRestrictedSystemSettingsEntered, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsRestrictedSystemSettingsEntered, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RevertRestrictedSystemSettingsEntered)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RevertRestrictedSystemSettingsEntered);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRestrictedFeatures, (::nn::sf::Out<int> outFeatures))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRestrictedFeatures, (outFeatures));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ConfirmStereoVisionPermission)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ConfirmStereoVisionPermission);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConfirmPlayableApplicationVideoOld, (const ::nn::sf::InArray<::std::int8_t>& ratingAge))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ConfirmPlayableApplicationVideoOld, (ratingAge));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConfirmPlayableApplicationVideo, (::nn::ncm::ApplicationId applicationId, const ::nn::sf::InArray<::std::int8_t>& ratingAge))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ConfirmPlayableApplicationVideo, (applicationId, ratingAge));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsRestrictionEnabled, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsRestrictionEnabled, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSafetyLevel, (::nn::sf::Out<int> outSafetyLevel))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSafetyLevel, (outSafetyLevel));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSafetyLevel, (int level))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSafetyLevel, (level));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSafetyLevelSettings, (::nn::sf::Out<::nn::pctl::SafetyLevelSettings> pSettings, int level))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSafetyLevelSettings, (pSettings, level));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentSettings, (::nn::sf::Out<::nn::pctl::SafetyLevelSettings> pSettings))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCurrentSettings, (pSettings));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetCustomSafetyLevelSettings, (::nn::pctl::SafetyLevelSettings pSettings))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetCustomSafetyLevelSettings, (pSettings));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDefaultRatingOrganization, (::nn::sf::Out<int> outOrganization))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDefaultRatingOrganization, (outOrganization));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDefaultRatingOrganization, (int organization))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDefaultRatingOrganization, (organization));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeCommunicationApplicationListCount, (::nn::sf::Out<int> outCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFreeCommunicationApplicationListCount, (outCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddToFreeCommunicationApplicationList, (::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddToFreeCommunicationApplicationList, (applicationId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteSettings)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeleteSettings);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeCommunicationApplicationList, (::nn::sf::Out<int> outCount, const ::nn::sf::OutArray<::nn::pctl::FreeCommunicationApplicationInfo>& pOutTitleInfoArray, int offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFreeCommunicationApplicationList, (outCount, pOutTitleInfoArray, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateFreeCommunicationApplicationList, (const ::nn::sf::InArray<::nn::pctl::FreeCommunicationApplicationInfo>& pTitleInfoArray))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UpdateFreeCommunicationApplicationList, (pTitleInfoArray));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableFeaturesForReset)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DisableFeaturesForReset);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyApplicationDownloadStarted, (::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(NotifyApplicationDownloadStarted, (applicationId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ConfirmStereoVisionRestrictionConfigurable)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ConfirmStereoVisionRestrictionConfigurable);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStereoVisionRestriction, (::nn::sf::Out<bool> outRestricted))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetStereoVisionRestriction, (outRestricted));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetStereoVisionRestriction, (bool restricted))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetStereoVisionRestriction, (restricted));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetConfirmedStereoVisionPermission)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ResetConfirmedStereoVisionPermission);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsStereoVisionPermitted, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsStereoVisionPermitted, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnlockRestrictionTemporarily, (const ::nn::sf::InArray<char>& code))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnlockRestrictionTemporarily, (code));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnlockSystemSettingsRestriction, (const ::nn::sf::InArray<char>& code))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnlockSystemSettingsRestriction, (code));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPinCode, (const ::nn::sf::InArray<char>& code))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetPinCode, (code));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateInquiryCode, (::nn::sf::Out<::nn::pctl::InquiryCode> pOutCodeData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GenerateInquiryCode, (pOutCodeData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckMasterKey, (::nn::sf::Out<bool> outValue, const ::nn::pctl::InquiryCode& codeData, const ::nn::sf::InArray<char>& masterKey))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CheckMasterKey, (outValue, codeData, masterKey));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPinCodeLength, (::nn::sf::Out<int> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPinCodeLength, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPinCodeChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPinCodeChangedEvent, (pEvent));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPinCode, (::nn::sf::Out<int> outLength, const ::nn::sf::OutArray<char>& outCode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPinCode, (outLength, outCode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsPairingActive, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsPairingActive, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSettingsLastUpdated, (::nn::sf::Out<::nn::time::PosixTime> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSettingsLastUpdated, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPairingAccountInfo, (::nn::sf::Out<::nn::pctl::detail::PairingAccountInfoBase> pAccountInfo, const ::nn::pctl::detail::PairingInfoBase& pairingInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPairingAccountInfo, (pAccountInfo, pairingInfo));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountNickname, (::nn::sf::Out<::std::uint32_t> pActualSize, const ::nn::sf::OutArray<char>& pNickname, const ::nn::pctl::detail::PairingAccountInfoBase& accountInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAccountNickname, (pActualSize, pNickname, accountInfo));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountState, (::nn::sf::Out<int> outState, const ::nn::pctl::detail::PairingAccountInfoBase& accountInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAccountState, (outState, accountInfo));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestPostEvents, (::nn::sf::Out<int> outCount, const ::nn::sf::OutArray<::nn::pctl::detail::service::watcher::EventData>& outEventDataArray))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestPostEvents, (outCount, outEventDataArray));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSynchronizationEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSynchronizationEvent, (pEvent));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StartPlayTimer)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StartPlayTimer);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopPlayTimer)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StopPlayTimer);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsPlayTimerEnabled, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsPlayTimerEnabled, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayTimerRemainingTime, (::nn::sf::Out<::nn::TimeSpanType> outTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPlayTimerRemainingTime, (outTime));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsRestrictedByPlayTimer, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsRestrictedByPlayTimer, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayTimerSettings, (::nn::sf::Out<::nn::pctl::PlayTimerSettings> pSettings))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPlayTimerSettings, (pSettings));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayTimerEventToRequestSuspension, (::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPlayTimerEventToRequestSuspension, (pEvent));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsPlayTimerAlarmDisabled, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsPlayTimerAlarmDisabled, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifyWrongPinCodeInputManyTimes)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(NotifyWrongPinCodeInputManyTimes);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelNetworkRequest)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CancelNetworkRequest);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUnlinkedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetUnlinkedEvent, (pEvent));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearUnlinkedEvent)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ClearUnlinkedEvent);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DisableAllFeatures, (::nn::sf::Out<bool> outIsAlreadyDisabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DisableAllFeatures, (outIsAlreadyDisabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PostEnableAllFeatures, (::nn::sf::Out<bool> outIsAlreadyEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PostEnableAllFeatures, (outIsAlreadyEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAllFeaturesDisabled, (::nn::sf::Out<bool> outValue, ::nn::sf::Out<bool> outIsEnabledOnNextBoot))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsAllFeaturesDisabled, (outValue, outIsEnabledOnNextBoot));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteFromFreeCommunicationApplicationListForDebug, (::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteFromFreeCommunicationApplicationListForDebug, (applicationId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearFreeCommunicationApplicationListForDebug)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ClearFreeCommunicationApplicationListForDebug);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetExemptApplicationListCountForDebug, (::nn::sf::Out<int> outCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetExemptApplicationListCountForDebug, (outCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetExemptApplicationListForDebug, (::nn::sf::Out<int> outCount, const ::nn::sf::OutArray<::nn::pctl::ExemptApplicationInfo>& pOutTitleInfoArray, int offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetExemptApplicationListForDebug, (outCount, pOutTitleInfoArray, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateExemptApplicationListForDebug, (const ::nn::sf::InArray<::nn::pctl::ExemptApplicationInfo>& pTitleInfoArray))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UpdateExemptApplicationListForDebug, (pTitleInfoArray));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddToExemptApplicationListForDebug, (::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddToExemptApplicationListForDebug, (applicationId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteFromExemptApplicationListForDebug, (::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteFromExemptApplicationListForDebug, (applicationId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearExemptApplicationListForDebug)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ClearExemptApplicationListForDebug);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeletePairing)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeletePairing);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPlayTimerSettingsForDebug, (const ::nn::pctl::PlayTimerSettings& settings))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetPlayTimerSettingsForDebug, (settings));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayTimerSpentTimeForTest, (::nn::sf::Out<::nn::TimeSpanType> outTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPlayTimerSpentTimeForTest, (outTime));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPlayTimerAlarmDisabledForDebug, (bool isDisabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetPlayTimerAlarmDisabledForDebug, (isDisabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestPairingAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, const ::nn::sf::InArray<char>& code))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestPairingAsync, (pAsyncData, pEvent, code));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishRequestPairing, (::nn::sf::Out<::nn::pctl::detail::PairingInfoBase> pInfo, ::nn::pctl::detail::AsyncData asyncData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FinishRequestPairing, (pInfo, asyncData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AuthorizePairingAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, const ::nn::pctl::detail::PairingInfoBase& pairingInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AuthorizePairingAsync, (pAsyncData, pEvent, pairingInfo));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishAuthorizePairing, (::nn::sf::Out<::nn::pctl::detail::PairingInfoBase> pUpdatedInfo, ::nn::pctl::detail::AsyncData asyncData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FinishAuthorizePairing, (pUpdatedInfo, asyncData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RetrievePairingInfoAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RetrievePairingInfoAsync, (pAsyncData, pEvent));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishRetrievePairingInfo, (::nn::sf::Out<::nn::pctl::detail::PairingInfoBase> pInfo, ::nn::pctl::detail::AsyncData asyncData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FinishRetrievePairingInfo, (pInfo, asyncData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnlinkPairingAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, bool force))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnlinkPairingAsync, (pAsyncData, pEvent, force));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishUnlinkPairing, (::nn::pctl::detail::AsyncData asyncData, bool force))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FinishUnlinkPairing, (asyncData, force));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountMiiImageAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, ::nn::sf::Out<::std::uint32_t> pActualSize, const ::nn::sf::OutBuffer& pImage, const ::nn::pctl::detail::PairingAccountInfoBase& accountInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAccountMiiImageAsync, (pAsyncData, pEvent, pActualSize, pImage, accountInfo));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishGetAccountMiiImage, (::nn::sf::Out<::std::uint32_t> pActualSize, const ::nn::sf::OutBuffer& pImage, ::nn::pctl::detail::AsyncData asyncData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FinishGetAccountMiiImage, (pActualSize, pImage, asyncData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountMiiImageContentTypeAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, ::nn::sf::Out<::std::uint32_t> pActualLength, const ::nn::sf::OutArray<char>& pContentType, const ::nn::pctl::detail::PairingAccountInfoBase& accountInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAccountMiiImageContentTypeAsync, (pAsyncData, pEvent, pActualLength, pContentType, accountInfo));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishGetAccountMiiImageContentType, (::nn::sf::Out<::std::uint32_t> pActualLength, const ::nn::sf::OutArray<char>& pContentType, ::nn::pctl::detail::AsyncData asyncData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FinishGetAccountMiiImageContentType, (pActualLength, pContentType, asyncData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SynchronizeParentalControlSettingsAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SynchronizeParentalControlSettingsAsync, (pAsyncData, pEvent));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishSynchronizeParentalControlSettings, (::nn::pctl::detail::AsyncData asyncData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FinishSynchronizeParentalControlSettings, (asyncData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishSynchronizeParentalControlSettingsWithLastUpdated, (::nn::sf::Out<::nn::time::PosixTime> outLastUpdated, ::nn::pctl::detail::AsyncData asyncData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FinishSynchronizeParentalControlSettingsWithLastUpdated, (outLastUpdated, asyncData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestUpdateExemptionListAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, ::nn::ncm::ApplicationId applicationId, bool isExempt))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestUpdateExemptionListAsync, (pAsyncData, pEvent, applicationId, isExempt));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::pctl::detail::ipc::IParentalControlService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::pctl::detail::ipc::IParentalControlService))

    // nn::Result Initialize() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Initialize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Initialize)

    // nn::Result CheckFreeCommunicationPermission() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckFreeCommunicationPermission)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckFreeCommunicationPermission)

    // nn::Result ConfirmLaunchApplicationPermission(nn::ncm::ApplicationId applicationId, const nn::sf::InArray<std::int8_t>& ratingAge, bool freeCommunicationFlag) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConfirmLaunchApplicationPermission)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1002)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(ratingAge, 0, (const ::nn::sf::InArray<::std::int8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (ratingAge))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(freeCommunicationFlag, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (freeCommunicationFlag, applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ratingAge), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(freeCommunicationFlag)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConfirmLaunchApplicationPermission)

    // nn::Result ConfirmResumeApplicationPermission(nn::ncm::ApplicationId applicationId, const nn::sf::InArray<std::int8_t>& ratingAge, bool freeCommunicationFlag) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConfirmResumeApplicationPermission)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1003)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(ratingAge, 0, (const ::nn::sf::InArray<::std::int8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (ratingAge))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(freeCommunicationFlag, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (freeCommunicationFlag, applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ratingAge), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(freeCommunicationFlag)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConfirmResumeApplicationPermission)

    // nn::Result ConfirmSnsPostPermission() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConfirmSnsPostPermission)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1004)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConfirmSnsPostPermission)

    // nn::Result ConfirmSystemSettingsPermission() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConfirmSystemSettingsPermission)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1005)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConfirmSystemSettingsPermission)

    // nn::Result IsRestrictionTemporaryUnlocked(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsRestrictionTemporaryUnlocked)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1006)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsRestrictionTemporaryUnlocked)

    // nn::Result RevertRestrictionTemporaryUnlocked() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RevertRestrictionTemporaryUnlocked)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1007)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RevertRestrictionTemporaryUnlocked)

    // nn::Result EnterRestrictedSystemSettings() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnterRestrictedSystemSettings)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1008)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnterRestrictedSystemSettings)

    // nn::Result LeaveRestrictedSystemSettings() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeaveRestrictedSystemSettings)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1009)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeaveRestrictedSystemSettings)

    // nn::Result IsRestrictedSystemSettingsEntered(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsRestrictedSystemSettingsEntered)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1010)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsRestrictedSystemSettingsEntered)

    // nn::Result RevertRestrictedSystemSettingsEntered() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RevertRestrictedSystemSettingsEntered)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1011)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RevertRestrictedSystemSettingsEntered)

    // nn::Result GetRestrictedFeatures(nn::sf::Out<int> outFeatures) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRestrictedFeatures)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1012)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outFeatures, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outFeatures))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFeatures)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRestrictedFeatures)

    // nn::Result ConfirmStereoVisionPermission() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConfirmStereoVisionPermission)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1013)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConfirmStereoVisionPermission)

    // nn::Result ConfirmPlayableApplicationVideoOld(const nn::sf::InArray<std::int8_t>& ratingAge) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConfirmPlayableApplicationVideoOld)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1014)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(ratingAge, 0, (const ::nn::sf::InArray<::std::int8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (ratingAge))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ratingAge)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConfirmPlayableApplicationVideoOld)

    // nn::Result ConfirmPlayableApplicationVideo(nn::ncm::ApplicationId applicationId, const nn::sf::InArray<std::int8_t>& ratingAge) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConfirmPlayableApplicationVideo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1015)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(ratingAge, 0, (const ::nn::sf::InArray<::std::int8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (ratingAge))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ratingAge)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConfirmPlayableApplicationVideo)

    // nn::Result IsRestrictionEnabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsRestrictionEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1031)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsRestrictionEnabled)

    // nn::Result GetSafetyLevel(nn::sf::Out<int> outSafetyLevel) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSafetyLevel)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1032)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSafetyLevel, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSafetyLevel))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSafetyLevel)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSafetyLevel)

    // nn::Result SetSafetyLevel(int level) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSafetyLevel)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1033)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(level, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (level))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(level)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSafetyLevel)

    // nn::Result GetSafetyLevelSettings(nn::sf::Out<nn::pctl::SafetyLevelSettings> pSettings, int level) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSafetyLevelSettings)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1034)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(level, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (level))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pSettings, (::nn::pctl::SafetyLevelSettings), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pSettings))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(3)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pSettings), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(level)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSafetyLevelSettings)

    // nn::Result GetCurrentSettings(nn::sf::Out<nn::pctl::SafetyLevelSettings> pSettings) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCurrentSettings)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1035)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pSettings, (::nn::pctl::SafetyLevelSettings), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pSettings))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(3)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pSettings)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCurrentSettings)

    // nn::Result SetCustomSafetyLevelSettings(nn::pctl::SafetyLevelSettings pSettings) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetCustomSafetyLevelSettings)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1036)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pSettings, (::nn::pctl::SafetyLevelSettings), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pSettings))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(3)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pSettings)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetCustomSafetyLevelSettings)

    // nn::Result GetDefaultRatingOrganization(nn::sf::Out<int> outOrganization) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDefaultRatingOrganization)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1037)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outOrganization, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outOrganization))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outOrganization)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDefaultRatingOrganization)

    // nn::Result SetDefaultRatingOrganization(int organization) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDefaultRatingOrganization)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1038)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(organization, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (organization))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(organization)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDefaultRatingOrganization)

    // nn::Result GetFreeCommunicationApplicationListCount(nn::sf::Out<int> outCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFreeCommunicationApplicationListCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1039)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFreeCommunicationApplicationListCount)

    // nn::Result AddToFreeCommunicationApplicationList(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddToFreeCommunicationApplicationList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1042)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddToFreeCommunicationApplicationList)

    // nn::Result DeleteSettings() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteSettings)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1043)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteSettings)

    // nn::Result GetFreeCommunicationApplicationList(nn::sf::Out<int> outCount, const nn::sf::OutArray<nn::pctl::FreeCommunicationApplicationInfo>& pOutTitleInfoArray, int offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFreeCommunicationApplicationList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1044)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutTitleInfoArray, 0, (const ::nn::sf::OutArray<::nn::pctl::FreeCommunicationApplicationInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutTitleInfoArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutTitleInfoArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFreeCommunicationApplicationList)

    // nn::Result UpdateFreeCommunicationApplicationList(const nn::sf::InArray<nn::pctl::FreeCommunicationApplicationInfo>& pTitleInfoArray) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UpdateFreeCommunicationApplicationList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1045)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pTitleInfoArray, 0, (const ::nn::sf::InArray<::nn::pctl::FreeCommunicationApplicationInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pTitleInfoArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pTitleInfoArray)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UpdateFreeCommunicationApplicationList)

    // nn::Result DisableFeaturesForReset() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableFeaturesForReset)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1046)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableFeaturesForReset)

    // nn::Result NotifyApplicationDownloadStarted(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyApplicationDownloadStarted)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1047)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyApplicationDownloadStarted)

    // nn::Result ConfirmStereoVisionRestrictionConfigurable() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConfirmStereoVisionRestrictionConfigurable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1061)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConfirmStereoVisionRestrictionConfigurable)

    // nn::Result GetStereoVisionRestriction(nn::sf::Out<bool> outRestricted) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStereoVisionRestriction)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1062)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outRestricted, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outRestricted))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRestricted)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStereoVisionRestriction)

    // nn::Result SetStereoVisionRestriction(bool restricted) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetStereoVisionRestriction)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1063)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(restricted, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (restricted))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(restricted)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetStereoVisionRestriction)

    // nn::Result ResetConfirmedStereoVisionPermission() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetConfirmedStereoVisionPermission)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1064)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetConfirmedStereoVisionPermission)

    // nn::Result IsStereoVisionPermitted(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsStereoVisionPermitted)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1065)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsStereoVisionPermitted)

    // nn::Result UnlockRestrictionTemporarily(const nn::sf::InArray<char>& code) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnlockRestrictionTemporarily)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(code, 0, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (code))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(code)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnlockRestrictionTemporarily)

    // nn::Result UnlockSystemSettingsRestriction(const nn::sf::InArray<char>& code) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnlockSystemSettingsRestriction)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(code, 0, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (code))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(code)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnlockSystemSettingsRestriction)

    // nn::Result SetPinCode(const nn::sf::InArray<char>& code) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetPinCode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(code, 0, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (code))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(code)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetPinCode)

    // nn::Result GenerateInquiryCode(nn::sf::Out<nn::pctl::InquiryCode> pOutCodeData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GenerateInquiryCode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1204)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCodeData, (::nn::pctl::InquiryCode), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCodeData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCodeData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GenerateInquiryCode)

    // nn::Result CheckMasterKey(nn::sf::Out<bool> outValue, const nn::pctl::InquiryCode& codeData, const nn::sf::InArray<char>& masterKey) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckMasterKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1205)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(masterKey, 0, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (masterKey))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(codeData, (::nn::pctl::InquiryCode), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (codeData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(codeData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(masterKey)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckMasterKey)

    // nn::Result GetPinCodeLength(nn::sf::Out<int> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPinCodeLength)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1206)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPinCodeLength)

    // nn::Result GetPinCodeChangedEvent(nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPinCodeChangedEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1207)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pEvent, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pEvent))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEvent)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPinCodeChangedEvent)

    // nn::Result GetPinCode(nn::sf::Out<int> outLength, const nn::sf::OutArray<char>& outCode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPinCode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1208)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outCode, 0, (const ::nn::sf::OutArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outCode))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outLength, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outLength))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLength), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPinCode)

    // nn::Result IsPairingActive(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsPairingActive)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1403)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsPairingActive)

    // nn::Result GetSettingsLastUpdated(nn::sf::Out<nn::time::PosixTime> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSettingsLastUpdated)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1406)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::time::PosixTime), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSettingsLastUpdated)

    // nn::Result GetPairingAccountInfo(nn::sf::Out<nn::pctl::detail::PairingAccountInfoBase> pAccountInfo, const nn::pctl::detail::PairingInfoBase& pairingInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPairingAccountInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1411)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pairingInfo, (::nn::pctl::detail::PairingInfoBase), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pairingInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pAccountInfo, (::nn::pctl::detail::PairingAccountInfoBase), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pAccountInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pAccountInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pairingInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPairingAccountInfo)

    // nn::Result GetAccountNickname(nn::sf::Out<std::uint32_t> pActualSize, const nn::sf::OutArray<char>& pNickname, const nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAccountNickname)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1421)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pNickname, 0, (const ::nn::sf::OutArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pNickname))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountInfo, (::nn::pctl::detail::PairingAccountInfoBase), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (accountInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pActualSize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pActualSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pActualSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pNickname), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAccountNickname)

    // nn::Result GetAccountState(nn::sf::Out<int> outState, const nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAccountState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1424)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountInfo, (::nn::pctl::detail::PairingAccountInfoBase), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (accountInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outState, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outState), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAccountState)

    // nn::Result RequestPostEvents(nn::sf::Out<int> outCount, const nn::sf::OutArray<nn::pctl::detail::service::watcher::EventData>& outEventDataArray) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestPostEvents)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1425)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outEventDataArray, 0, (const ::nn::sf::OutArray<::nn::pctl::detail::service::watcher::EventData>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outEventDataArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outEventDataArray)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestPostEvents)

    // nn::Result GetSynchronizationEvent(nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSynchronizationEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1432)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pEvent, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pEvent))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEvent)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSynchronizationEvent)

    // nn::Result StartPlayTimer() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartPlayTimer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1451)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartPlayTimer)

    // nn::Result StopPlayTimer() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopPlayTimer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1452)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopPlayTimer)

    // nn::Result IsPlayTimerEnabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsPlayTimerEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1453)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsPlayTimerEnabled)

    // nn::Result GetPlayTimerRemainingTime(nn::sf::Out<nn::TimeSpanType> outTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPlayTimerRemainingTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1454)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outTime, (::nn::TimeSpanType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPlayTimerRemainingTime)

    // nn::Result IsRestrictedByPlayTimer(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsRestrictedByPlayTimer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1455)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsRestrictedByPlayTimer)

    // nn::Result GetPlayTimerSettings(nn::sf::Out<nn::pctl::PlayTimerSettings> pSettings) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPlayTimerSettings)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1456)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pSettings, (::nn::pctl::PlayTimerSettings), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pSettings))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(52)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pSettings)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPlayTimerSettings)

    // nn::Result GetPlayTimerEventToRequestSuspension(nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPlayTimerEventToRequestSuspension)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1457)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pEvent, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pEvent))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEvent)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPlayTimerEventToRequestSuspension)

    // nn::Result IsPlayTimerAlarmDisabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsPlayTimerAlarmDisabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1458)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsPlayTimerAlarmDisabled)

    // nn::Result NotifyWrongPinCodeInputManyTimes() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyWrongPinCodeInputManyTimes)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1471)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyWrongPinCodeInputManyTimes)

    // nn::Result CancelNetworkRequest() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelNetworkRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1472)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelNetworkRequest)

    // nn::Result GetUnlinkedEvent(nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetUnlinkedEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1473)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pEvent, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pEvent))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEvent)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetUnlinkedEvent)

    // nn::Result ClearUnlinkedEvent() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearUnlinkedEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1474)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearUnlinkedEvent)

    // nn::Result DisableAllFeatures(nn::sf::Out<bool> outIsAlreadyDisabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableAllFeatures)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1601)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsAlreadyDisabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIsAlreadyDisabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsAlreadyDisabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableAllFeatures)

    // nn::Result PostEnableAllFeatures(nn::sf::Out<bool> outIsAlreadyEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PostEnableAllFeatures)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1602)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsAlreadyEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIsAlreadyEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsAlreadyEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PostEnableAllFeatures)

    // nn::Result IsAllFeaturesDisabled(nn::sf::Out<bool> outValue, nn::sf::Out<bool> outIsEnabledOnNextBoot) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsAllFeaturesDisabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1603)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsEnabledOnNextBoot, (bool), 1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outValue, outIsEnabledOnNextBoot))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsEnabledOnNextBoot)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsAllFeaturesDisabled)

    // nn::Result DeleteFromFreeCommunicationApplicationListForDebug(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteFromFreeCommunicationApplicationListForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1901)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteFromFreeCommunicationApplicationListForDebug)

    // nn::Result ClearFreeCommunicationApplicationListForDebug() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearFreeCommunicationApplicationListForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1902)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearFreeCommunicationApplicationListForDebug)

    // nn::Result GetExemptApplicationListCountForDebug(nn::sf::Out<int> outCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetExemptApplicationListCountForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1903)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetExemptApplicationListCountForDebug)

    // nn::Result GetExemptApplicationListForDebug(nn::sf::Out<int> outCount, const nn::sf::OutArray<nn::pctl::ExemptApplicationInfo>& pOutTitleInfoArray, int offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetExemptApplicationListForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1904)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutTitleInfoArray, 0, (const ::nn::sf::OutArray<::nn::pctl::ExemptApplicationInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutTitleInfoArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutTitleInfoArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetExemptApplicationListForDebug)

    // nn::Result UpdateExemptApplicationListForDebug(const nn::sf::InArray<nn::pctl::ExemptApplicationInfo>& pTitleInfoArray) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UpdateExemptApplicationListForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1905)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pTitleInfoArray, 0, (const ::nn::sf::InArray<::nn::pctl::ExemptApplicationInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pTitleInfoArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pTitleInfoArray)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UpdateExemptApplicationListForDebug)

    // nn::Result AddToExemptApplicationListForDebug(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddToExemptApplicationListForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1906)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddToExemptApplicationListForDebug)

    // nn::Result DeleteFromExemptApplicationListForDebug(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteFromExemptApplicationListForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1907)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteFromExemptApplicationListForDebug)

    // nn::Result ClearExemptApplicationListForDebug() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearExemptApplicationListForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1908)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearExemptApplicationListForDebug)

    // nn::Result DeletePairing() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeletePairing)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1941)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeletePairing)

    // nn::Result SetPlayTimerSettingsForDebug(const nn::pctl::PlayTimerSettings& settings) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetPlayTimerSettingsForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1951)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(settings, (::nn::pctl::PlayTimerSettings), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (settings))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(52)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(settings)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetPlayTimerSettingsForDebug)

    // nn::Result GetPlayTimerSpentTimeForTest(nn::sf::Out<nn::TimeSpanType> outTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPlayTimerSpentTimeForTest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1952)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outTime, (::nn::TimeSpanType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPlayTimerSpentTimeForTest)

    // nn::Result SetPlayTimerAlarmDisabledForDebug(bool isDisabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetPlayTimerAlarmDisabledForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1953)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isDisabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isDisabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isDisabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetPlayTimerAlarmDisabledForDebug)

    // nn::Result RequestPairingAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, const nn::sf::InArray<char>& code) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestPairingAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(code, 0, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (code))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pEvent, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pEvent))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pAsyncData, (::nn::pctl::detail::AsyncData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pAsyncData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pAsyncData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEvent), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(code)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestPairingAsync)

    // nn::Result FinishRequestPairing(nn::sf::Out<nn::pctl::detail::PairingInfoBase> pInfo, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FinishRequestPairing)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2002)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(asyncData, (::nn::pctl::detail::AsyncData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (asyncData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pInfo, (::nn::pctl::detail::PairingInfoBase), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(asyncData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FinishRequestPairing)

    // nn::Result AuthorizePairingAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, const nn::pctl::detail::PairingInfoBase& pairingInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AuthorizePairingAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2003)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pEvent, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pEvent))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pairingInfo, (::nn::pctl::detail::PairingInfoBase), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pairingInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pAsyncData, (::nn::pctl::detail::AsyncData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pAsyncData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pAsyncData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEvent), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pairingInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AuthorizePairingAsync)

    // nn::Result FinishAuthorizePairing(nn::sf::Out<nn::pctl::detail::PairingInfoBase> pUpdatedInfo, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FinishAuthorizePairing)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2004)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(asyncData, (::nn::pctl::detail::AsyncData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (asyncData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pUpdatedInfo, (::nn::pctl::detail::PairingInfoBase), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pUpdatedInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pUpdatedInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(asyncData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FinishAuthorizePairing)

    // nn::Result RetrievePairingInfoAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RetrievePairingInfoAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2005)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pEvent, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pEvent))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pAsyncData, (::nn::pctl::detail::AsyncData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pAsyncData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pAsyncData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEvent)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RetrievePairingInfoAsync)

    // nn::Result FinishRetrievePairingInfo(nn::sf::Out<nn::pctl::detail::PairingInfoBase> pInfo, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FinishRetrievePairingInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2006)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(asyncData, (::nn::pctl::detail::AsyncData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (asyncData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pInfo, (::nn::pctl::detail::PairingInfoBase), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(asyncData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FinishRetrievePairingInfo)

    // nn::Result UnlinkPairingAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, bool force) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnlinkPairingAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2007)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pEvent, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pEvent))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(force, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (force))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pAsyncData, (::nn::pctl::detail::AsyncData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pAsyncData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pAsyncData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEvent), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(force)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnlinkPairingAsync)

    // nn::Result FinishUnlinkPairing(nn::pctl::detail::AsyncData asyncData, bool force) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FinishUnlinkPairing)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2008)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(force, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(asyncData, (::nn::pctl::detail::AsyncData), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (force, asyncData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(asyncData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(force)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FinishUnlinkPairing)

    // nn::Result GetAccountMiiImageAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, nn::sf::Out<std::uint32_t> pActualSize, const nn::sf::OutBuffer& pImage, const nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAccountMiiImageAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2009)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pImage, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pImage))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pEvent, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pEvent))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountInfo, (::nn::pctl::detail::PairingAccountInfoBase), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (accountInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pAsyncData, (::nn::pctl::detail::AsyncData), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pActualSize, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pAsyncData, pActualSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pAsyncData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEvent), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pActualSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pImage), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAccountMiiImageAsync)

    // nn::Result FinishGetAccountMiiImage(nn::sf::Out<std::uint32_t> pActualSize, const nn::sf::OutBuffer& pImage, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FinishGetAccountMiiImage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2010)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pImage, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pImage))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(asyncData, (::nn::pctl::detail::AsyncData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (asyncData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pActualSize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pActualSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pActualSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pImage), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(asyncData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FinishGetAccountMiiImage)

    // nn::Result GetAccountMiiImageContentTypeAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, nn::sf::Out<std::uint32_t> pActualLength, const nn::sf::OutArray<char>& pContentType, const nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAccountMiiImageContentTypeAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2011)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pContentType, 0, (const ::nn::sf::OutArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pContentType))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pEvent, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pEvent))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountInfo, (::nn::pctl::detail::PairingAccountInfoBase), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (accountInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pAsyncData, (::nn::pctl::detail::AsyncData), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pActualLength, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pAsyncData, pActualLength))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pAsyncData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEvent), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pActualLength), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pContentType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAccountMiiImageContentTypeAsync)

    // nn::Result FinishGetAccountMiiImageContentType(nn::sf::Out<std::uint32_t> pActualLength, const nn::sf::OutArray<char>& pContentType, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FinishGetAccountMiiImageContentType)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2012)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pContentType, 0, (const ::nn::sf::OutArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pContentType))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(asyncData, (::nn::pctl::detail::AsyncData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (asyncData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pActualLength, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pActualLength))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pActualLength), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pContentType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(asyncData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FinishGetAccountMiiImageContentType)

    // nn::Result SynchronizeParentalControlSettingsAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SynchronizeParentalControlSettingsAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2013)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pEvent, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pEvent))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pAsyncData, (::nn::pctl::detail::AsyncData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pAsyncData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pAsyncData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEvent)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SynchronizeParentalControlSettingsAsync)

    // nn::Result FinishSynchronizeParentalControlSettings(nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FinishSynchronizeParentalControlSettings)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2014)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(asyncData, (::nn::pctl::detail::AsyncData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (asyncData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(asyncData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FinishSynchronizeParentalControlSettings)

    // nn::Result FinishSynchronizeParentalControlSettingsWithLastUpdated(nn::sf::Out<nn::time::PosixTime> outLastUpdated, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FinishSynchronizeParentalControlSettingsWithLastUpdated)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2015)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(asyncData, (::nn::pctl::detail::AsyncData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (asyncData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outLastUpdated, (::nn::time::PosixTime), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outLastUpdated))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLastUpdated), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(asyncData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FinishSynchronizeParentalControlSettingsWithLastUpdated)

    // nn::Result RequestUpdateExemptionListAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, nn::ncm::ApplicationId applicationId, bool isExempt) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestUpdateExemptionListAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2016)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pEvent, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pEvent))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isExempt, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (isExempt, applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pAsyncData, (::nn::pctl::detail::AsyncData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pAsyncData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pAsyncData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEvent), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isExempt)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestUpdateExemptionListAsync)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pctl::SafetyLevelSettings), 3, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pctl::FreeCommunicationApplicationInfo), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pctl::InquiryCode), 32, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::time::PosixTime), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pctl::detail::PairingAccountInfoBase), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pctl::detail::PairingInfoBase), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pctl::detail::service::watcher::EventData), 96, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::TimeSpanType), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pctl::PlayTimerSettings), 52, 2)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pctl::ExemptApplicationInfo), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pctl::detail::AsyncData), 8, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::pctl::detail::ipc::IParentalControlService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::pctl::detail::ipc::IParentalControlService))

    // nn::Result Initialize() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Initialize)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Initialize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Initialize)
    }

    // nn::Result CheckFreeCommunicationPermission() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CheckFreeCommunicationPermission)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckFreeCommunicationPermission)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckFreeCommunicationPermission)
    }

    // nn::Result ConfirmLaunchApplicationPermission(nn::ncm::ApplicationId applicationId, const nn::sf::InArray<std::int8_t>& ratingAge, bool freeCommunicationFlag) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConfirmLaunchApplicationPermission, (::nn::ncm::ApplicationId applicationId, const ::nn::sf::InArray<::std::int8_t>& ratingAge, bool freeCommunicationFlag))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConfirmLaunchApplicationPermission)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ratingAge)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(freeCommunicationFlag)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConfirmLaunchApplicationPermission)
    }

    // nn::Result ConfirmResumeApplicationPermission(nn::ncm::ApplicationId applicationId, const nn::sf::InArray<std::int8_t>& ratingAge, bool freeCommunicationFlag) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConfirmResumeApplicationPermission, (::nn::ncm::ApplicationId applicationId, const ::nn::sf::InArray<::std::int8_t>& ratingAge, bool freeCommunicationFlag))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConfirmResumeApplicationPermission)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ratingAge)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(freeCommunicationFlag)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConfirmResumeApplicationPermission)
    }

    // nn::Result ConfirmSnsPostPermission() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ConfirmSnsPostPermission)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConfirmSnsPostPermission)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConfirmSnsPostPermission)
    }

    // nn::Result ConfirmSystemSettingsPermission() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ConfirmSystemSettingsPermission)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConfirmSystemSettingsPermission)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConfirmSystemSettingsPermission)
    }

    // nn::Result IsRestrictionTemporaryUnlocked(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsRestrictionTemporaryUnlocked, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsRestrictionTemporaryUnlocked)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsRestrictionTemporaryUnlocked)
    }

    // nn::Result RevertRestrictionTemporaryUnlocked() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RevertRestrictionTemporaryUnlocked)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RevertRestrictionTemporaryUnlocked)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RevertRestrictionTemporaryUnlocked)
    }

    // nn::Result EnterRestrictedSystemSettings() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnterRestrictedSystemSettings)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnterRestrictedSystemSettings)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnterRestrictedSystemSettings)
    }

    // nn::Result LeaveRestrictedSystemSettings() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(LeaveRestrictedSystemSettings)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeaveRestrictedSystemSettings)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeaveRestrictedSystemSettings)
    }

    // nn::Result IsRestrictedSystemSettingsEntered(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsRestrictedSystemSettingsEntered, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsRestrictedSystemSettingsEntered)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsRestrictedSystemSettingsEntered)
    }

    // nn::Result RevertRestrictedSystemSettingsEntered() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RevertRestrictedSystemSettingsEntered)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RevertRestrictedSystemSettingsEntered)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RevertRestrictedSystemSettingsEntered)
    }

    // nn::Result GetRestrictedFeatures(nn::sf::Out<int> outFeatures) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRestrictedFeatures, (::nn::sf::Out<int> outFeatures))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRestrictedFeatures)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFeatures)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRestrictedFeatures)
    }

    // nn::Result ConfirmStereoVisionPermission() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ConfirmStereoVisionPermission)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConfirmStereoVisionPermission)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConfirmStereoVisionPermission)
    }

    // nn::Result ConfirmPlayableApplicationVideoOld(const nn::sf::InArray<std::int8_t>& ratingAge) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConfirmPlayableApplicationVideoOld, (const ::nn::sf::InArray<::std::int8_t>& ratingAge))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConfirmPlayableApplicationVideoOld)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ratingAge)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConfirmPlayableApplicationVideoOld)
    }

    // nn::Result ConfirmPlayableApplicationVideo(nn::ncm::ApplicationId applicationId, const nn::sf::InArray<std::int8_t>& ratingAge) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConfirmPlayableApplicationVideo, (::nn::ncm::ApplicationId applicationId, const ::nn::sf::InArray<::std::int8_t>& ratingAge))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConfirmPlayableApplicationVideo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ratingAge)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConfirmPlayableApplicationVideo)
    }

    // nn::Result IsRestrictionEnabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsRestrictionEnabled, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsRestrictionEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsRestrictionEnabled)
    }

    // nn::Result GetSafetyLevel(nn::sf::Out<int> outSafetyLevel) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSafetyLevel, (::nn::sf::Out<int> outSafetyLevel))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSafetyLevel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSafetyLevel)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSafetyLevel)
    }

    // nn::Result SetSafetyLevel(int level) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSafetyLevel, (int level))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSafetyLevel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(level)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSafetyLevel)
    }

    // nn::Result GetSafetyLevelSettings(nn::sf::Out<nn::pctl::SafetyLevelSettings> pSettings, int level) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSafetyLevelSettings, (::nn::sf::Out<::nn::pctl::SafetyLevelSettings> pSettings, int level))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSafetyLevelSettings)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pSettings)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(level)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSafetyLevelSettings)
    }

    // nn::Result GetCurrentSettings(nn::sf::Out<nn::pctl::SafetyLevelSettings> pSettings) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentSettings, (::nn::sf::Out<::nn::pctl::SafetyLevelSettings> pSettings))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCurrentSettings)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pSettings)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCurrentSettings)
    }

    // nn::Result SetCustomSafetyLevelSettings(nn::pctl::SafetyLevelSettings pSettings) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetCustomSafetyLevelSettings, (::nn::pctl::SafetyLevelSettings pSettings))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetCustomSafetyLevelSettings)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pSettings)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetCustomSafetyLevelSettings)
    }

    // nn::Result GetDefaultRatingOrganization(nn::sf::Out<int> outOrganization) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDefaultRatingOrganization, (::nn::sf::Out<int> outOrganization))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDefaultRatingOrganization)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outOrganization)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDefaultRatingOrganization)
    }

    // nn::Result SetDefaultRatingOrganization(int organization) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDefaultRatingOrganization, (int organization))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDefaultRatingOrganization)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(organization)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDefaultRatingOrganization)
    }

    // nn::Result GetFreeCommunicationApplicationListCount(nn::sf::Out<int> outCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeCommunicationApplicationListCount, (::nn::sf::Out<int> outCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFreeCommunicationApplicationListCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFreeCommunicationApplicationListCount)
    }

    // nn::Result AddToFreeCommunicationApplicationList(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddToFreeCommunicationApplicationList, (::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddToFreeCommunicationApplicationList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddToFreeCommunicationApplicationList)
    }

    // nn::Result DeleteSettings() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteSettings)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteSettings)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteSettings)
    }

    // nn::Result GetFreeCommunicationApplicationList(nn::sf::Out<int> outCount, const nn::sf::OutArray<nn::pctl::FreeCommunicationApplicationInfo>& pOutTitleInfoArray, int offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeCommunicationApplicationList, (::nn::sf::Out<int> outCount, const ::nn::sf::OutArray<::nn::pctl::FreeCommunicationApplicationInfo>& pOutTitleInfoArray, int offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFreeCommunicationApplicationList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutTitleInfoArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFreeCommunicationApplicationList)
    }

    // nn::Result UpdateFreeCommunicationApplicationList(const nn::sf::InArray<nn::pctl::FreeCommunicationApplicationInfo>& pTitleInfoArray) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateFreeCommunicationApplicationList, (const ::nn::sf::InArray<::nn::pctl::FreeCommunicationApplicationInfo>& pTitleInfoArray))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UpdateFreeCommunicationApplicationList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pTitleInfoArray)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UpdateFreeCommunicationApplicationList)
    }

    // nn::Result DisableFeaturesForReset() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableFeaturesForReset)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableFeaturesForReset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableFeaturesForReset)
    }

    // nn::Result NotifyApplicationDownloadStarted(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyApplicationDownloadStarted, (::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyApplicationDownloadStarted)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyApplicationDownloadStarted)
    }

    // nn::Result ConfirmStereoVisionRestrictionConfigurable() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ConfirmStereoVisionRestrictionConfigurable)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConfirmStereoVisionRestrictionConfigurable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConfirmStereoVisionRestrictionConfigurable)
    }

    // nn::Result GetStereoVisionRestriction(nn::sf::Out<bool> outRestricted) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStereoVisionRestriction, (::nn::sf::Out<bool> outRestricted))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStereoVisionRestriction)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRestricted)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStereoVisionRestriction)
    }

    // nn::Result SetStereoVisionRestriction(bool restricted) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetStereoVisionRestriction, (bool restricted))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetStereoVisionRestriction)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(restricted)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetStereoVisionRestriction)
    }

    // nn::Result ResetConfirmedStereoVisionPermission() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetConfirmedStereoVisionPermission)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetConfirmedStereoVisionPermission)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetConfirmedStereoVisionPermission)
    }

    // nn::Result IsStereoVisionPermitted(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsStereoVisionPermitted, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsStereoVisionPermitted)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsStereoVisionPermitted)
    }

    // nn::Result UnlockRestrictionTemporarily(const nn::sf::InArray<char>& code) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnlockRestrictionTemporarily, (const ::nn::sf::InArray<char>& code))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnlockRestrictionTemporarily)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(code)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnlockRestrictionTemporarily)
    }

    // nn::Result UnlockSystemSettingsRestriction(const nn::sf::InArray<char>& code) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnlockSystemSettingsRestriction, (const ::nn::sf::InArray<char>& code))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnlockSystemSettingsRestriction)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(code)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnlockSystemSettingsRestriction)
    }

    // nn::Result SetPinCode(const nn::sf::InArray<char>& code) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPinCode, (const ::nn::sf::InArray<char>& code))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetPinCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(code)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetPinCode)
    }

    // nn::Result GenerateInquiryCode(nn::sf::Out<nn::pctl::InquiryCode> pOutCodeData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateInquiryCode, (::nn::sf::Out<::nn::pctl::InquiryCode> pOutCodeData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GenerateInquiryCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCodeData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GenerateInquiryCode)
    }

    // nn::Result CheckMasterKey(nn::sf::Out<bool> outValue, const nn::pctl::InquiryCode& codeData, const nn::sf::InArray<char>& masterKey) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckMasterKey, (::nn::sf::Out<bool> outValue, const ::nn::pctl::InquiryCode& codeData, const ::nn::sf::InArray<char>& masterKey))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckMasterKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(codeData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(masterKey)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckMasterKey)
    }

    // nn::Result GetPinCodeLength(nn::sf::Out<int> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPinCodeLength, (::nn::sf::Out<int> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPinCodeLength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPinCodeLength)
    }

    // nn::Result GetPinCodeChangedEvent(nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPinCodeChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPinCodeChangedEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEvent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPinCodeChangedEvent)
    }

    // nn::Result GetPinCode(nn::sf::Out<int> outLength, const nn::sf::OutArray<char>& outCode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPinCode, (::nn::sf::Out<int> outLength, const ::nn::sf::OutArray<char>& outCode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPinCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPinCode)
    }

    // nn::Result IsPairingActive(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsPairingActive, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsPairingActive)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsPairingActive)
    }

    // nn::Result GetSettingsLastUpdated(nn::sf::Out<nn::time::PosixTime> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSettingsLastUpdated, (::nn::sf::Out<::nn::time::PosixTime> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSettingsLastUpdated)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSettingsLastUpdated)
    }

    // nn::Result GetPairingAccountInfo(nn::sf::Out<nn::pctl::detail::PairingAccountInfoBase> pAccountInfo, const nn::pctl::detail::PairingInfoBase& pairingInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPairingAccountInfo, (::nn::sf::Out<::nn::pctl::detail::PairingAccountInfoBase> pAccountInfo, const ::nn::pctl::detail::PairingInfoBase& pairingInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPairingAccountInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pAccountInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pairingInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPairingAccountInfo)
    }

    // nn::Result GetAccountNickname(nn::sf::Out<std::uint32_t> pActualSize, const nn::sf::OutArray<char>& pNickname, const nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountNickname, (::nn::sf::Out<::std::uint32_t> pActualSize, const ::nn::sf::OutArray<char>& pNickname, const ::nn::pctl::detail::PairingAccountInfoBase& accountInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAccountNickname)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pActualSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pNickname)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAccountNickname)
    }

    // nn::Result GetAccountState(nn::sf::Out<int> outState, const nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountState, (::nn::sf::Out<int> outState, const ::nn::pctl::detail::PairingAccountInfoBase& accountInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAccountState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAccountState)
    }

    // nn::Result RequestPostEvents(nn::sf::Out<int> outCount, const nn::sf::OutArray<nn::pctl::detail::service::watcher::EventData>& outEventDataArray) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestPostEvents, (::nn::sf::Out<int> outCount, const ::nn::sf::OutArray<::nn::pctl::detail::service::watcher::EventData>& outEventDataArray))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestPostEvents)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outEventDataArray)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestPostEvents)
    }

    // nn::Result GetSynchronizationEvent(nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSynchronizationEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSynchronizationEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEvent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSynchronizationEvent)
    }

    // nn::Result StartPlayTimer() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StartPlayTimer)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartPlayTimer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartPlayTimer)
    }

    // nn::Result StopPlayTimer() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopPlayTimer)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopPlayTimer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopPlayTimer)
    }

    // nn::Result IsPlayTimerEnabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsPlayTimerEnabled, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsPlayTimerEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsPlayTimerEnabled)
    }

    // nn::Result GetPlayTimerRemainingTime(nn::sf::Out<nn::TimeSpanType> outTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayTimerRemainingTime, (::nn::sf::Out<::nn::TimeSpanType> outTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPlayTimerRemainingTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPlayTimerRemainingTime)
    }

    // nn::Result IsRestrictedByPlayTimer(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsRestrictedByPlayTimer, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsRestrictedByPlayTimer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsRestrictedByPlayTimer)
    }

    // nn::Result GetPlayTimerSettings(nn::sf::Out<nn::pctl::PlayTimerSettings> pSettings) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayTimerSettings, (::nn::sf::Out<::nn::pctl::PlayTimerSettings> pSettings))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPlayTimerSettings)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pSettings)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPlayTimerSettings)
    }

    // nn::Result GetPlayTimerEventToRequestSuspension(nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayTimerEventToRequestSuspension, (::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPlayTimerEventToRequestSuspension)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEvent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPlayTimerEventToRequestSuspension)
    }

    // nn::Result IsPlayTimerAlarmDisabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsPlayTimerAlarmDisabled, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsPlayTimerAlarmDisabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsPlayTimerAlarmDisabled)
    }

    // nn::Result NotifyWrongPinCodeInputManyTimes() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifyWrongPinCodeInputManyTimes)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyWrongPinCodeInputManyTimes)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyWrongPinCodeInputManyTimes)
    }

    // nn::Result CancelNetworkRequest() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelNetworkRequest)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelNetworkRequest)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelNetworkRequest)
    }

    // nn::Result GetUnlinkedEvent(nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUnlinkedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetUnlinkedEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEvent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetUnlinkedEvent)
    }

    // nn::Result ClearUnlinkedEvent() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearUnlinkedEvent)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearUnlinkedEvent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearUnlinkedEvent)
    }

    // nn::Result DisableAllFeatures(nn::sf::Out<bool> outIsAlreadyDisabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DisableAllFeatures, (::nn::sf::Out<bool> outIsAlreadyDisabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableAllFeatures)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsAlreadyDisabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableAllFeatures)
    }

    // nn::Result PostEnableAllFeatures(nn::sf::Out<bool> outIsAlreadyEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PostEnableAllFeatures, (::nn::sf::Out<bool> outIsAlreadyEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PostEnableAllFeatures)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsAlreadyEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PostEnableAllFeatures)
    }

    // nn::Result IsAllFeaturesDisabled(nn::sf::Out<bool> outValue, nn::sf::Out<bool> outIsEnabledOnNextBoot) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAllFeaturesDisabled, (::nn::sf::Out<bool> outValue, ::nn::sf::Out<bool> outIsEnabledOnNextBoot))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsAllFeaturesDisabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsEnabledOnNextBoot)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsAllFeaturesDisabled)
    }

    // nn::Result DeleteFromFreeCommunicationApplicationListForDebug(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteFromFreeCommunicationApplicationListForDebug, (::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteFromFreeCommunicationApplicationListForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteFromFreeCommunicationApplicationListForDebug)
    }

    // nn::Result ClearFreeCommunicationApplicationListForDebug() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearFreeCommunicationApplicationListForDebug)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearFreeCommunicationApplicationListForDebug)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearFreeCommunicationApplicationListForDebug)
    }

    // nn::Result GetExemptApplicationListCountForDebug(nn::sf::Out<int> outCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetExemptApplicationListCountForDebug, (::nn::sf::Out<int> outCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetExemptApplicationListCountForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetExemptApplicationListCountForDebug)
    }

    // nn::Result GetExemptApplicationListForDebug(nn::sf::Out<int> outCount, const nn::sf::OutArray<nn::pctl::ExemptApplicationInfo>& pOutTitleInfoArray, int offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetExemptApplicationListForDebug, (::nn::sf::Out<int> outCount, const ::nn::sf::OutArray<::nn::pctl::ExemptApplicationInfo>& pOutTitleInfoArray, int offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetExemptApplicationListForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutTitleInfoArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetExemptApplicationListForDebug)
    }

    // nn::Result UpdateExemptApplicationListForDebug(const nn::sf::InArray<nn::pctl::ExemptApplicationInfo>& pTitleInfoArray) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateExemptApplicationListForDebug, (const ::nn::sf::InArray<::nn::pctl::ExemptApplicationInfo>& pTitleInfoArray))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UpdateExemptApplicationListForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pTitleInfoArray)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UpdateExemptApplicationListForDebug)
    }

    // nn::Result AddToExemptApplicationListForDebug(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddToExemptApplicationListForDebug, (::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddToExemptApplicationListForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddToExemptApplicationListForDebug)
    }

    // nn::Result DeleteFromExemptApplicationListForDebug(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteFromExemptApplicationListForDebug, (::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteFromExemptApplicationListForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteFromExemptApplicationListForDebug)
    }

    // nn::Result ClearExemptApplicationListForDebug() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearExemptApplicationListForDebug)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearExemptApplicationListForDebug)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearExemptApplicationListForDebug)
    }

    // nn::Result DeletePairing() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeletePairing)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeletePairing)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeletePairing)
    }

    // nn::Result SetPlayTimerSettingsForDebug(const nn::pctl::PlayTimerSettings& settings) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPlayTimerSettingsForDebug, (const ::nn::pctl::PlayTimerSettings& settings))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetPlayTimerSettingsForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(settings)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetPlayTimerSettingsForDebug)
    }

    // nn::Result GetPlayTimerSpentTimeForTest(nn::sf::Out<nn::TimeSpanType> outTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayTimerSpentTimeForTest, (::nn::sf::Out<::nn::TimeSpanType> outTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPlayTimerSpentTimeForTest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPlayTimerSpentTimeForTest)
    }

    // nn::Result SetPlayTimerAlarmDisabledForDebug(bool isDisabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPlayTimerAlarmDisabledForDebug, (bool isDisabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetPlayTimerAlarmDisabledForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isDisabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetPlayTimerAlarmDisabledForDebug)
    }

    // nn::Result RequestPairingAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, const nn::sf::InArray<char>& code) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestPairingAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, const ::nn::sf::InArray<char>& code))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestPairingAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pAsyncData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(code)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestPairingAsync)
    }

    // nn::Result FinishRequestPairing(nn::sf::Out<nn::pctl::detail::PairingInfoBase> pInfo, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishRequestPairing, (::nn::sf::Out<::nn::pctl::detail::PairingInfoBase> pInfo, ::nn::pctl::detail::AsyncData asyncData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FinishRequestPairing)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(asyncData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FinishRequestPairing)
    }

    // nn::Result AuthorizePairingAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, const nn::pctl::detail::PairingInfoBase& pairingInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AuthorizePairingAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, const ::nn::pctl::detail::PairingInfoBase& pairingInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AuthorizePairingAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pAsyncData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pairingInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AuthorizePairingAsync)
    }

    // nn::Result FinishAuthorizePairing(nn::sf::Out<nn::pctl::detail::PairingInfoBase> pUpdatedInfo, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishAuthorizePairing, (::nn::sf::Out<::nn::pctl::detail::PairingInfoBase> pUpdatedInfo, ::nn::pctl::detail::AsyncData asyncData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FinishAuthorizePairing)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pUpdatedInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(asyncData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FinishAuthorizePairing)
    }

    // nn::Result RetrievePairingInfoAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RetrievePairingInfoAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RetrievePairingInfoAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pAsyncData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEvent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RetrievePairingInfoAsync)
    }

    // nn::Result FinishRetrievePairingInfo(nn::sf::Out<nn::pctl::detail::PairingInfoBase> pInfo, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishRetrievePairingInfo, (::nn::sf::Out<::nn::pctl::detail::PairingInfoBase> pInfo, ::nn::pctl::detail::AsyncData asyncData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FinishRetrievePairingInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(asyncData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FinishRetrievePairingInfo)
    }

    // nn::Result UnlinkPairingAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, bool force) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnlinkPairingAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, bool force))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnlinkPairingAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pAsyncData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(force)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnlinkPairingAsync)
    }

    // nn::Result FinishUnlinkPairing(nn::pctl::detail::AsyncData asyncData, bool force) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishUnlinkPairing, (::nn::pctl::detail::AsyncData asyncData, bool force))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FinishUnlinkPairing)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(asyncData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(force)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FinishUnlinkPairing)
    }

    // nn::Result GetAccountMiiImageAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, nn::sf::Out<std::uint32_t> pActualSize, const nn::sf::OutBuffer& pImage, const nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountMiiImageAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, ::nn::sf::Out<::std::uint32_t> pActualSize, const ::nn::sf::OutBuffer& pImage, const ::nn::pctl::detail::PairingAccountInfoBase& accountInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAccountMiiImageAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pAsyncData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pActualSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pImage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAccountMiiImageAsync)
    }

    // nn::Result FinishGetAccountMiiImage(nn::sf::Out<std::uint32_t> pActualSize, const nn::sf::OutBuffer& pImage, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishGetAccountMiiImage, (::nn::sf::Out<::std::uint32_t> pActualSize, const ::nn::sf::OutBuffer& pImage, ::nn::pctl::detail::AsyncData asyncData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FinishGetAccountMiiImage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pActualSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pImage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(asyncData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FinishGetAccountMiiImage)
    }

    // nn::Result GetAccountMiiImageContentTypeAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, nn::sf::Out<std::uint32_t> pActualLength, const nn::sf::OutArray<char>& pContentType, const nn::pctl::detail::PairingAccountInfoBase& accountInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountMiiImageContentTypeAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, ::nn::sf::Out<::std::uint32_t> pActualLength, const ::nn::sf::OutArray<char>& pContentType, const ::nn::pctl::detail::PairingAccountInfoBase& accountInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAccountMiiImageContentTypeAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pAsyncData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pActualLength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pContentType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAccountMiiImageContentTypeAsync)
    }

    // nn::Result FinishGetAccountMiiImageContentType(nn::sf::Out<std::uint32_t> pActualLength, const nn::sf::OutArray<char>& pContentType, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishGetAccountMiiImageContentType, (::nn::sf::Out<::std::uint32_t> pActualLength, const ::nn::sf::OutArray<char>& pContentType, ::nn::pctl::detail::AsyncData asyncData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FinishGetAccountMiiImageContentType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pActualLength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pContentType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(asyncData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FinishGetAccountMiiImageContentType)
    }

    // nn::Result SynchronizeParentalControlSettingsAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SynchronizeParentalControlSettingsAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SynchronizeParentalControlSettingsAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pAsyncData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEvent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SynchronizeParentalControlSettingsAsync)
    }

    // nn::Result FinishSynchronizeParentalControlSettings(nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishSynchronizeParentalControlSettings, (::nn::pctl::detail::AsyncData asyncData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FinishSynchronizeParentalControlSettings)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(asyncData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FinishSynchronizeParentalControlSettings)
    }

    // nn::Result FinishSynchronizeParentalControlSettingsWithLastUpdated(nn::sf::Out<nn::time::PosixTime> outLastUpdated, nn::pctl::detail::AsyncData asyncData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishSynchronizeParentalControlSettingsWithLastUpdated, (::nn::sf::Out<::nn::time::PosixTime> outLastUpdated, ::nn::pctl::detail::AsyncData asyncData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FinishSynchronizeParentalControlSettingsWithLastUpdated)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLastUpdated)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(asyncData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FinishSynchronizeParentalControlSettingsWithLastUpdated)
    }

    // nn::Result RequestUpdateExemptionListAsync(nn::sf::Out<nn::pctl::detail::AsyncData> pAsyncData, nn::sf::Out<nn::sf::NativeHandle> pEvent, nn::ncm::ApplicationId applicationId, bool isExempt) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestUpdateExemptionListAsync, (::nn::sf::Out<::nn::pctl::detail::AsyncData> pAsyncData, ::nn::sf::Out<::nn::sf::NativeHandle> pEvent, ::nn::ncm::ApplicationId applicationId, bool isExempt))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestUpdateExemptionListAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pAsyncData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isExempt)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestUpdateExemptionListAsync)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::pctl::detail::ipc::IParentalControlService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::pctl::detail::ipc::IParentalControlService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckFreeCommunicationPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckFreeCommunicationPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConfirmLaunchApplicationPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(ratingAge)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConfirmLaunchApplicationPermission)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(ratingAge),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(freeCommunicationFlag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConfirmResumeApplicationPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(ratingAge)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConfirmResumeApplicationPermission)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(ratingAge),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(freeCommunicationFlag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConfirmSnsPostPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConfirmSnsPostPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConfirmSystemSettingsPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConfirmSystemSettingsPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsRestrictionTemporaryUnlocked)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsRestrictionTemporaryUnlocked)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RevertRestrictionTemporaryUnlocked)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RevertRestrictionTemporaryUnlocked)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnterRestrictedSystemSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnterRestrictedSystemSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeaveRestrictedSystemSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeaveRestrictedSystemSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsRestrictedSystemSettingsEntered)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsRestrictedSystemSettingsEntered)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RevertRestrictedSystemSettingsEntered)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RevertRestrictedSystemSettingsEntered)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRestrictedFeatures)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRestrictedFeatures)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outFeatures)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConfirmStereoVisionPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConfirmStereoVisionPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConfirmPlayableApplicationVideoOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(ratingAge)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConfirmPlayableApplicationVideoOld)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(ratingAge)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConfirmPlayableApplicationVideo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(ratingAge)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConfirmPlayableApplicationVideo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(ratingAge)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsRestrictionEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsRestrictionEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSafetyLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSafetyLevel)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSafetyLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSafetyLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0 && _ < 5), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(level)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSafetyLevel)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(level)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSafetyLevelSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0 && _ < 5), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(level)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSafetyLevelSettings)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pSettings),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(level)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCurrentSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCurrentSettings)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetCustomSafetyLevelSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetCustomSafetyLevelSettings)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDefaultRatingOrganization)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDefaultRatingOrganization)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outOrganization)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDefaultRatingOrganization)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(organization)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDefaultRatingOrganization)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(organization)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFreeCommunicationApplicationListCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFreeCommunicationApplicationListCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddToFreeCommunicationApplicationList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddToFreeCommunicationApplicationList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFreeCommunicationApplicationList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutTitleInfoArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFreeCommunicationApplicationList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutTitleInfoArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UpdateFreeCommunicationApplicationList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pTitleInfoArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UpdateFreeCommunicationApplicationList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pTitleInfoArray)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableFeaturesForReset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableFeaturesForReset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyApplicationDownloadStarted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyApplicationDownloadStarted)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConfirmStereoVisionRestrictionConfigurable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConfirmStereoVisionRestrictionConfigurable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStereoVisionRestriction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStereoVisionRestriction)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outRestricted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetStereoVisionRestriction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetStereoVisionRestriction)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(restricted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetConfirmedStereoVisionPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetConfirmedStereoVisionPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsStereoVisionPermitted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsStereoVisionPermitted)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnlockRestrictionTemporarily)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(code)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnlockRestrictionTemporarily)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(code)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnlockSystemSettingsRestriction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(code)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnlockSystemSettingsRestriction)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(code)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetPinCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(code)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetPinCode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(code)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GenerateInquiryCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GenerateInquiryCode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCodeData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckMasterKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(masterKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckMasterKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(codeData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(masterKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPinCodeLength)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPinCodeLength)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPinCodeChangedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPinCodeChangedEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPinCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outCode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPinCode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outLength),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsPairingActive)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsPairingActive)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSettingsLastUpdated)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSettingsLastUpdated)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPairingAccountInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPairingAccountInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pAccountInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pairingInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAccountNickname)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pNickname)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAccountNickname)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pActualSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pNickname),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAccountState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAccountState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outState),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestPostEvents)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outEventDataArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestPostEvents)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outEventDataArray)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSynchronizationEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSynchronizationEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartPlayTimer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartPlayTimer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopPlayTimer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopPlayTimer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsPlayTimerEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsPlayTimerEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPlayTimerRemainingTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPlayTimerRemainingTime)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsRestrictedByPlayTimer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsRestrictedByPlayTimer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPlayTimerSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPlayTimerSettings)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPlayTimerEventToRequestSuspension)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPlayTimerEventToRequestSuspension)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsPlayTimerAlarmDisabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsPlayTimerAlarmDisabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyWrongPinCodeInputManyTimes)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyWrongPinCodeInputManyTimes)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelNetworkRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelNetworkRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetUnlinkedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetUnlinkedEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearUnlinkedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearUnlinkedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableAllFeatures)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableAllFeatures)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsAlreadyDisabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PostEnableAllFeatures)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PostEnableAllFeatures)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsAlreadyEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsAllFeaturesDisabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsAllFeaturesDisabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsEnabledOnNextBoot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteFromFreeCommunicationApplicationListForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteFromFreeCommunicationApplicationListForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearFreeCommunicationApplicationListForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearFreeCommunicationApplicationListForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetExemptApplicationListCountForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetExemptApplicationListCountForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetExemptApplicationListForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutTitleInfoArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetExemptApplicationListForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutTitleInfoArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UpdateExemptApplicationListForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pTitleInfoArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UpdateExemptApplicationListForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pTitleInfoArray)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddToExemptApplicationListForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddToExemptApplicationListForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteFromExemptApplicationListForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteFromExemptApplicationListForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearExemptApplicationListForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearExemptApplicationListForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeletePairing)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeletePairing)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetPlayTimerSettingsForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetPlayTimerSettingsForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(settings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPlayTimerSpentTimeForTest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPlayTimerSpentTimeForTest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetPlayTimerAlarmDisabledForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetPlayTimerAlarmDisabledForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isDisabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestPairingAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(code)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestPairingAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pAsyncData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pEvent),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(code)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FinishRequestPairing)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FinishRequestPairing)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(asyncData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AuthorizePairingAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AuthorizePairingAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pAsyncData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pEvent),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pairingInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FinishAuthorizePairing)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FinishAuthorizePairing)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pUpdatedInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(asyncData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RetrievePairingInfoAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RetrievePairingInfoAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pAsyncData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FinishRetrievePairingInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FinishRetrievePairingInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(asyncData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnlinkPairingAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnlinkPairingAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pAsyncData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pEvent),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(force)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FinishUnlinkPairing)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FinishUnlinkPairing)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(asyncData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(force)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAccountMiiImageAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAccountMiiImageAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pAsyncData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pEvent),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pActualSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pImage),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FinishGetAccountMiiImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FinishGetAccountMiiImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pActualSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pImage),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(asyncData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAccountMiiImageContentTypeAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pContentType)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAccountMiiImageContentTypeAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pAsyncData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pEvent),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pActualLength),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pContentType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FinishGetAccountMiiImageContentType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pContentType)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FinishGetAccountMiiImageContentType)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pActualLength),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pContentType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(asyncData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SynchronizeParentalControlSettingsAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SynchronizeParentalControlSettingsAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pAsyncData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FinishSynchronizeParentalControlSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FinishSynchronizeParentalControlSettings)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(asyncData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FinishSynchronizeParentalControlSettingsWithLastUpdated)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FinishSynchronizeParentalControlSettingsWithLastUpdated)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outLastUpdated),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(asyncData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestUpdateExemptionListAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != nn::ncm::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestUpdateExemptionListAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pAsyncData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pEvent),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isExempt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckFreeCommunicationPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConfirmLaunchApplicationPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConfirmResumeApplicationPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConfirmSnsPostPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConfirmSystemSettingsPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsRestrictionTemporaryUnlocked)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RevertRestrictionTemporaryUnlocked)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnterRestrictedSystemSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeaveRestrictedSystemSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsRestrictedSystemSettingsEntered)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RevertRestrictedSystemSettingsEntered)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRestrictedFeatures)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConfirmStereoVisionPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConfirmPlayableApplicationVideoOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConfirmPlayableApplicationVideo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsRestrictionEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSafetyLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSafetyLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSafetyLevelSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCurrentSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetCustomSafetyLevelSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDefaultRatingOrganization)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDefaultRatingOrganization)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFreeCommunicationApplicationListCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddToFreeCommunicationApplicationList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFreeCommunicationApplicationList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UpdateFreeCommunicationApplicationList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableFeaturesForReset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyApplicationDownloadStarted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConfirmStereoVisionRestrictionConfigurable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStereoVisionRestriction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetStereoVisionRestriction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetConfirmedStereoVisionPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsStereoVisionPermitted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnlockRestrictionTemporarily)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnlockSystemSettingsRestriction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetPinCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GenerateInquiryCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckMasterKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPinCodeLength)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPinCodeChangedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPinCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsPairingActive)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSettingsLastUpdated)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPairingAccountInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAccountNickname)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAccountState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestPostEvents)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSynchronizationEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartPlayTimer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopPlayTimer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsPlayTimerEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPlayTimerRemainingTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsRestrictedByPlayTimer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPlayTimerSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPlayTimerEventToRequestSuspension)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsPlayTimerAlarmDisabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyWrongPinCodeInputManyTimes)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelNetworkRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetUnlinkedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearUnlinkedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableAllFeatures)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PostEnableAllFeatures)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsAllFeaturesDisabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteFromFreeCommunicationApplicationListForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearFreeCommunicationApplicationListForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetExemptApplicationListCountForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetExemptApplicationListForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UpdateExemptApplicationListForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddToExemptApplicationListForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteFromExemptApplicationListForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearExemptApplicationListForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeletePairing)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetPlayTimerSettingsForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPlayTimerSpentTimeForTest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetPlayTimerAlarmDisabledForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestPairingAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FinishRequestPairing)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AuthorizePairingAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FinishAuthorizePairing)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RetrievePairingInfoAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FinishRetrievePairingInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnlinkPairingAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FinishUnlinkPairing)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAccountMiiImageAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FinishGetAccountMiiImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAccountMiiImageContentTypeAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FinishGetAccountMiiImageContentType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SynchronizeParentalControlSettingsAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FinishSynchronizeParentalControlSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FinishSynchronizeParentalControlSettingsWithLastUpdated)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestUpdateExemptionListAsync)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::pctl::detail::ipc::IParentalControlService))
